/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jp.aonir.fuzzyxml.FuzzyXMLAttribute;
import jp.aonir.fuzzyxml.FuzzyXMLDocument;
import jp.aonir.fuzzyxml.FuzzyXMLElement;
import jp.aonir.fuzzyxml.FuzzyXMLNode;
import jp.aonir.fuzzyxml.FuzzyXMLParser;
import jp.aonir.fuzzyxml.XPath;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.htmleditor.HTMLUtil;
import tk.eclipse.plugin.struts.StrutsConfigResolver;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Tiles;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.xmleditor.editors.XMLValidationHandler;

public class StrutsConfigValidator {
    private IJavaProject project;
    private IFile file;
    private String contents;
    private FuzzyXMLDocument doc;
    private HTMLProjectParams params;
    private List tilesPages;

    public StrutsConfigValidator(IFile file) {
        this.file = file;
        this.project = JavaCore.create((IProject)file.getProject());
    }

    public void doValidate() {
        try {
            SAXParserFactory spfactory = SAXParserFactory.newInstance();
            spfactory.setValidating(true);
            SAXParser parser = spfactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setEntityResolver(new StrutsConfigResolver());
            reader.setErrorHandler((ErrorHandler)new XMLValidationHandler((IResource)this.file));
            reader.parse(new InputSource(this.file.getContents()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.params = new HTMLProjectParams(this.file.getProject());
            this.contents = new String(HTMLUtil.readStream((InputStream)this.file.getContents()));
            this.contents = this.contents.replaceAll("\r\n", " \n");
            this.contents = this.contents.replaceAll("\r", "\n");
            this.doc = new FuzzyXMLParser().parse(this.file.getContents());
            this.tilesPages = new Tiles(this.file.getProject()).getTilesPathList();
            this.validateElement(this.doc.getDocumentElement());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void validateElement(FuzzyXMLElement element) {
        FuzzyXMLAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            if (attrs[i].getName().equals("type") || attrs[i].getName().equals("className")) {
                if (!attrs[i].getValue().equals("") && !this.existsClass(attrs[i].getValue())) {
                    this.addMarker(this.getLineAtOffset(element.getOffset()), Util.createMessage(StrutsPlugin.getResourceString("error.notexists"), new String[]{attrs[i].getValue()}), 1);
                }
            } else if (!element.getName().equals("action") && attrs[i].getName().equals("path") && !attrs[i].getValue().equals("") && !this.existsPath(attrs[i].getValue())) {
                this.addMarker(this.getLineAtOffset(element.getOffset()), Util.createMessage(StrutsPlugin.getResourceString("error.notexists"), new String[]{attrs[i].getValue()}), 1);
            }
            ++i;
        }
        FuzzyXMLNode[] nodes = element.getChildren();
        int i2 = 0;
        while (i2 < nodes.length) {
            if (nodes[i2] instanceof FuzzyXMLElement) {
                this.validateElement((FuzzyXMLElement)nodes[i2]);
            }
            ++i2;
        }
    }

    private int getLineAtOffset(int offset) {
        String text = this.contents.substring(0, offset);
        return text.split("\n").length;
    }

    private boolean existsPath(String path) {
        if (path.endsWith(".do")) {
            path = path.substring(0, path.indexOf(".do"));
            FuzzyXMLNode[] nodes = XPath.selectNodes((FuzzyXMLElement)this.doc.getDocumentElement(), (String)"/struts-config/action-mappings/action");
            int i = 0;
            while (i < nodes.length) {
                FuzzyXMLElement action = (FuzzyXMLElement)nodes[i];
                String actionPath = action.getAttributeNode("path").getValue();
                if (path.equals(actionPath)) {
                    return true;
                }
                ++i;
            }
        } else {
            if (path.indexOf("?") > 0) {
                path = path.substring(0, path.indexOf("?"));
            }
            if (this.tilesPages.contains(path)) {
                return true;
            }
            IFile jsp = this.file.getProject().getFile(new Path(this.params.getRoot()).append(path));
            if (jsp.exists()) {
                return true;
            }
        }
        return false;
    }

    private boolean existsClass(String className) {
        try {
            IType type = this.project.findType(className);
            if (type.isClass() && type.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private void addMarker(int line, String message, int type) {
        try {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.problemmarker");
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("severity", new Integer(type));
            map.put("message", message);
            map.put("lineNumber", new Integer(line));
            marker.setAttributes(map);
        }
        catch (Exception ex) {
            Util.logException(ex);
        }
    }
}

