/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.validator;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.validator.StrutsConfigValidator;

public class StrutsProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (this.getProject() == null) {
            return null;
        }
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta == null) {
            return null;
        }
        IFile file = this.processDelta(delta);
        if (file != null) {
            new StrutsConfigValidator(file).doValidate();
        }
        this.getProject().refreshLocal(2, monitor);
        return null;
    }

    private IFile processDelta(IResourceDelta delta) {
        String path;
        if (delta.getKind() != 0 && ((path = delta.getProjectRelativePath().toString()).endsWith(".jsp") || path.endsWith(".java") || path.endsWith(".class") || path.endsWith(".xml") || path.endsWith(".project") || path.endsWith(".classpath"))) {
            return this.getStrutsConfigXML();
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        int i = 0;
        if (i < children.length) {
            return this.processDelta(children[i]);
        }
        return null;
    }

    private IFile getStrutsConfigXML() {
        try {
            HTMLProjectParams params = new HTMLProjectParams(this.getProject());
            IPath path = new Path(params.getRoot()).append("/WEB-INF/struts-config.xml");
            IFile file = this.getProject().getFile(path);
            if (file.exists()) {
                return file;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

