/*
 * Decompiled with CFR 0.152.
 */
package tk.eclipse.plugin.struts.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import tk.eclipse.plugin.htmleditor.HTMLProjectParams;
import tk.eclipse.plugin.struts.StrutsConfigModel2XML;
import tk.eclipse.plugin.struts.StrutsPlugin;
import tk.eclipse.plugin.struts.Util;
import tk.eclipse.plugin.struts.editors.models.RootModel;
import tk.eclipse.plugin.struts.wizards.StrutsWizardPage;

public class StrutsWizard
extends Wizard
implements INewWizard {
    private StrutsWizardPage page;
    private IStructuredSelection selection;
    private ResourceBundle resource = StrutsPlugin.getDefault().getResourceBundle();
    public static final String[] JARS = new String[]{"/struts-1.1/commons-beanutils.jar", "/struts-1.1/commons-collections.jar", "/struts-1.1/commons-digester.jar", "/struts-1.1/commons-fileupload.jar", "/struts-1.1/commons-lang.jar", "/struts-1.1/commons-logging.jar", "/struts-1.1/commons-validator.jar", "/struts-1.1/jakarta-oro.jar", "/struts-1.1/struts-legacy.jar", "/struts-1.1/struts.jar"};
    public static final String[] TLDS = new String[]{"/struts-1.1/struts-bean.tld", "/struts-1.1/struts-html.tld", "/struts-1.1/struts-logic.tld", "/struts-1.1/struts-nested.tld", "/struts-1.1/struts-template.tld", "/struts-1.1/struts-tiles.tld"};

    public StrutsWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.resource.getString("wizard.strutsSupport.title"));
    }

    public boolean performFinish() {
        final String projectName = this.page.getWebAppRoot();
        final boolean addJARs = this.page.getAddStrutsLibraries();
        final boolean addTLDs = this.page.getAddTLDFiles();
        final boolean createStrutsConfigXML = this.page.getCreateStrutsConfigXML();
        final boolean createWebXML = this.page.getCreateWebXML();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        StrutsWizard.this.doFinish(projectName, addJARs, addTLDs, createStrutsConfigXML, createWebXML, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            Util.openErrorDialog(realException);
            return false;
        }
        return true;
    }

    private void doFinish(String path, boolean addJARs, boolean addTLDs, boolean createStrutsConfigXML, boolean createWebXML, IProgressMonitor monitor) throws CoreException {
        File libdir;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(path));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            Util.throwCoreException(Util.createMessage(this.resource.getString("error.notexists"), new String[]{path}));
        }
        this.addNature(resource.getProject(), path);
        int totalTask = 0;
        if (addJARs) {
            totalTask += JARS.length;
        }
        if (addTLDs) {
            totalTask += TLDS.length;
        }
        if (createStrutsConfigXML) {
            ++totalTask;
        }
        if (createWebXML) {
            ++totalTask;
        }
        monitor.beginTask(StrutsPlugin.getResourceString("wizard.strutsSupport.title"), totalTask);
        int task = 1;
        IContainer container = (IContainer)resource;
        File webinf = container.getFolder((IPath)new Path("/WEB-INF")).getLocation().makeAbsolute().toFile();
        if (!webinf.exists()) {
            webinf.mkdir();
        }
        if (!(libdir = container.getFolder((IPath)new Path("/WEB-INF/lib")).getLocation().makeAbsolute().toFile()).exists()) {
            libdir.mkdir();
        }
        if (addJARs) {
            int i = 0;
            while (i < JARS.length) {
                this.copyFile(monitor, container, JARS[i], "/WEB-INF/lib");
                monitor.worked(task);
                ++task;
                ++i;
            }
            container.refreshLocal(2, monitor);
            IJavaProject project = JavaCore.create((IProject)container.getProject());
            IClasspathEntry[] rawClasspath = project.getRawClasspath();
            ArrayList<IClasspathEntry> list = new ArrayList<IClasspathEntry>();
            list.addAll(Arrays.asList(rawClasspath));
            int i2 = 0;
            while (i2 < JARS.length) {
                String fileName = new File(JARS[i2]).getName();
                IClasspathEntry classPath = JavaCore.newLibraryEntry((IPath)new Path(String.valueOf(path) + "/WEB-INF/lib/" + fileName), null, null);
                if (!list.contains(classPath)) {
                    list.add(classPath);
                }
                ++i2;
            }
            IClasspathEntry[] newClasspath = list.toArray(new IClasspathEntry[list.size()]);
            project.setRawClasspath(newClasspath, monitor);
        }
        if (addTLDs) {
            int i = 0;
            while (i < TLDS.length) {
                this.copyFile(monitor, container, TLDS[i], "/WEB-INF");
                monitor.worked(task);
                ++task;
                ++i;
            }
        }
        if (createStrutsConfigXML) {
            monitor.beginTask(StrutsPlugin.getResourceString("wizard.progress.createStrutsConfigXML"), 1);
            try {
                IFile file = container.getFile((IPath)new Path("/WEB-INF/struts-config.xml"));
                InputStream stream = this.createStrutsConfigStream();
                if (file.exists()) {
                    file.setContents(stream, true, true, monitor);
                } else {
                    file.create(stream, true, monitor);
                }
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            monitor.worked(task++);
        }
        if (createWebXML) {
            monitor.beginTask(StrutsPlugin.getResourceString("wizard.progress.createWebXML"), 1);
            this.copyFile(monitor, container, "/struts-1.1/web.xml", "/WEB-INF");
            monitor.worked(task++);
        }
        container.refreshLocal(2, monitor);
    }

    private void addNature(IProject project, String path) throws CoreException {
        HTMLProjectParams params = new HTMLProjectParams();
        params.setRoot("/" + new Path(path).removeFirstSegments(1).toString());
        params.save(project);
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (natures[i].equals("tk.eclipse.plugin.struts.StrutsProjectNature")) {
                return;
            }
            ++i;
        }
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "tk.eclipse.plugin.struts.StrutsProjectNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }

    private synchronized void copyFile(IProgressMonitor monitor, IContainer container, String entry, String target) {
        try {
            URL url = StrutsPlugin.getDefault().getBundle().getEntry(entry);
            String fileName = new File(entry).getName();
            File file = container.getFile((IPath)new Path(String.valueOf(target) + "/" + fileName)).getLocation().makeAbsolute().toFile();
            InputStream in = url.openStream();
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[8192];
            int length = 0;
            while ((length = in.read(buf)) != -1) {
                ((OutputStream)out).write(buf, 0, length);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception ex) {
            Util.openErrorDialog(ex);
        }
    }

    private InputStream createStrutsConfigStream() {
        StringBuffer sb = new StringBuffer();
        sb.append(StrutsConfigModel2XML.createStrutsConfig(new RootModel()));
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new StrutsWizardPage((ISelection)this.selection);
        this.addPage((IWizardPage)this.page);
    }
}

