/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import tk.javacvs.CVSListener;
import tk.javacvs.CommandExecuter;
import tk.javacvs.DiffInfo;
import tk.javacvs.LogInfo;
import tk.javacvs.TagInfo;
import tk.javacvs.UpdateInfo;
import tk.javacvs.Util;
import tk.javacvs.swing.Main;

public class CVS {
    private String cvsCommand;
    private String charset = "EUC-JP";
    private File messageFile = new File("message.txt");
    private boolean quietMode = true;
    private OutputStream out;
    private ArrayList listeners = new ArrayList();
    public static final int COMMAND_LOG = 0;
    public static final int COMMAND_STATUS = 1;
    public static final int COMMAND_COMMIT = 2;
    public static final int COMMAND_UPDATE = 3;
    public static final int COMMAND_TAG = 4;
    public static final int COMMAND_REMOVE = 5;
    public static final int COMMAND_DIFF = 6;
    public static final int COMMAND_ADD = 7;
    public static final int COMMAND_CHECKOUT = 8;
    public static final int COMMAND_IMPORT = 9;

    public CVS(String cvsCommand, OutputStream out) {
        this.cvsCommand = cvsCommand;
        this.out = out;
    }

    public void addCVSListener(CVSListener listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(listener);
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public boolean getQuietMode() {
        return this.quietMode;
    }

    public void setCVSCommand(String cvsCommand) {
        if (cvsCommand != null) {
            this.cvsCommand = cvsCommand;
        }
    }

    public String getCVSCommand() {
        return this.cvsCommand;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void cvsimport(String cvsRoot, String module, File importDir, String venderTag, String releaseTag) throws IOException {
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs import ");
        sb.append(this.cvsCommand);
        sb.append(" -d ");
        sb.append(cvsRoot);
        if (this.getQuietMode()) {
            sb.append(" -q");
        }
        sb.append(" import -m \"\" ");
        sb.append(module);
        sb.append(" ");
        sb.append(venderTag);
        sb.append(" ");
        sb.append(releaseTag);
        msg.append(module);
        msg.append(" ");
        msg.append(venderTag);
        msg.append(" ");
        msg.append(releaseTag);
        this.executeCommand(sb.toString(), importDir, 9, msg.toString());
    }

    private String getModulePath(File file) {
        String path = file.getName();
        boolean flag = true;
        while (flag) {
            File parent = file.getParentFile();
            File cvsDir = new File(parent, "CVS");
            if (cvsDir.exists() && cvsDir.isDirectory()) {
                path = parent.getName() + "/" + path;
                file = parent;
                continue;
            }
            flag = false;
        }
        return path;
    }

    public File checkout(File file, File localDir, String rev, boolean date) throws IOException {
        String modulePath = this.getModulePath(file);
        StringBuffer sb = new StringBuffer();
        sb.append(this.cvsCommand);
        sb.append(" -d ");
        sb.append(this.getCVSRoot(file));
        if (this.getQuietMode()) {
            sb.append(" -q");
        }
        sb.append(" checkout ");
        if (rev != null && !rev.equals("")) {
            if (date) {
                sb.append("-D ");
                sb.append(rev);
                sb.append(" ");
            } else {
                sb.append("-r ");
                sb.append(rev);
                sb.append(" ");
            }
        }
        sb.append(modulePath);
        CommandExecuter executer = new CommandExecuter();
        executer.setDirectory(localDir);
        executer.execute(sb.toString(), true);
        return new File(localDir, modulePath);
    }

    public void checkout(String cvsRoot, String module, File localDir) throws IOException {
        StringBuffer sb = new StringBuffer();
        sb.append(this.cvsCommand);
        sb.append(" -d ");
        sb.append(cvsRoot);
        if (this.getQuietMode()) {
            sb.append(" -q");
        }
        sb.append(" checkout ");
        sb.append(module);
        this.executeCommand(sb.toString(), localDir, 8, "cvs checkout " + module);
    }

    public void remove(File root, File[] files, boolean currentOnly, boolean removeLocal) throws IOException {
        if (files == null || files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs remove");
        sb.append(this.createCommonCommandString(files));
        sb.append(" remove");
        if (currentOnly) {
            sb.append(" -l");
            msg.append(" -l");
        }
        if (removeLocal) {
            sb.append(" -f");
            msg.append(" -f");
        }
        sb.append(this.createFilesString(root, files));
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 5, msg.toString());
    }

    public void tag(File root, TagInfo info) throws IOException {
        File[] files = info.getFiles();
        if (files == null || files.length == 0) {
            return;
        }
        if (info.getTagName() == null || info.getTagName().equals("")) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs tag");
        sb.append(this.createCommonCommandString(files));
        sb.append(" tag");
        if (info.getCurrentOnly()) {
            sb.append(" -l");
            msg.append(" -l");
        }
        if (info.getConfirm()) {
            sb.append(" -c");
            msg.append(" -c");
        }
        if (info.getOverride()) {
            sb.append(" -F");
            msg.append(" -F");
        }
        if (info.getRemove()) {
            sb.append(" -d");
            msg.append(" -d");
        }
        if (info.getBranch()) {
            sb.append(" -b");
            msg.append(" -b");
        }
        sb.append(" ");
        sb.append(info.getTagName());
        sb.append(this.createFilesString(root, files));
        msg.append(" ");
        msg.append(info.getTagName());
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 4, msg.toString());
    }

    public void add(File root, File[] files, boolean isBinary) throws IOException {
        if (files == null || files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs add");
        sb.append(this.createCommonCommandString(files));
        sb.append(" add");
        if (isBinary) {
            sb.append(" -kb");
            msg.append(" -kb");
        }
        sb.append(this.createFilesString(root, files));
        msg.append(this.createFilesString(root, files));
        this.executeCommand(sb.toString(), root, 7, msg.toString());
    }

    public void diff(File root, DiffInfo info) throws IOException {
        File[] files = info.getFiles();
        if (files == null || files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs diff");
        sb.append(this.createCommonCommandString(files));
        sb.append(" diff");
        if (info.getCurrentOnly()) {
            sb.append(" -l");
            msg.append(" -l");
        }
        if (info.getSkipSpace()) {
            sb.append(" -w");
            msg.append(" -w");
        }
        if (info.getSkipLetterCase()) {
            sb.append(" -i");
            msg.append(" -i");
        }
        if (!info.getRevision1().equals("")) {
            if (info.getSelectDate1()) {
                sb.append(" -D " + info.getRevision1());
                msg.append(" -D " + info.getRevision1());
            } else {
                sb.append(" -r " + info.getRevision1());
                msg.append(" -r " + info.getRevision1());
            }
        }
        if (!info.getRevision2().equals("")) {
            if (info.getSelectDate1()) {
                sb.append(" -D " + info.getRevision2());
                msg.append(" -D " + info.getRevision2());
            } else {
                sb.append(" -r " + info.getRevision2());
                msg.append(" -r " + info.getRevision2());
            }
        }
        sb.append(this.createFilesString(root, files));
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 6, msg.toString());
    }

    public void status(File root, File[] files) throws IOException {
        if (files == null || files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs statuc");
        sb.append(this.createCommonCommandString(files));
        sb.append(" status");
        sb.append(this.createFilesString(root, files));
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 1, msg.toString());
    }

    public void log(File root, LogInfo info) throws IOException {
        File[] files = info.getFiles();
        if (files == null || files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs log");
        sb.append(this.createCommonCommandString(files));
        sb.append("log");
        if (info.getOnlyBranch()) {
            sb.append(" -b");
            msg.append(" -b");
        }
        if (info.getCurrentOnly()) {
            sb.append(" -l");
            msg.append(" -l");
        }
        if (info.getNoTag()) {
            sb.append(" -N");
            msg.append(" -N");
        }
        if (info.getNoLog()) {
            sb.append(" -h");
            msg.append(" -h");
        }
        if (info.getOnlyRCS()) {
            sb.append(" -R");
            msg.append(" -R");
        }
        sb.append(this.createFilesString(root, files));
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 0, msg.toString());
    }

    public void update(File root, UpdateInfo info) throws IOException {
        File[] files = info.getFiles();
        if (files == null || files.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs update");
        sb.append(this.createCommonCommandString(files));
        sb.append("update");
        if (info.getCurrentOnly()) {
            sb.append(" -l");
            msg.append("-l");
        }
        if (info.getCreateDir()) {
            sb.append(" -d");
            msg.append("-d");
        }
        if (info.getRemoveEmpty()) {
            sb.append(" -P");
            msg.append("-P");
        }
        if (info.getRemoveSticky()) {
            sb.append(" -A");
            msg.append("-A");
        }
        if (info.getUpdateLocal()) {
            sb.append(" -C");
            msg.append("-C");
        }
        if (info.getRevision() != null && !info.getRevision().equals("")) {
            if (info.getSelectDate()) {
                sb.append(" -D " + info.getRevision());
                msg.append(" -D " + info.getRevision());
            } else {
                sb.append(" -r " + info.getRevision());
                msg.append(" -r " + info.getRevision());
            }
        }
        if (info.getMergeRevision1() != null && !info.getMergeRevision1().equals("")) {
            sb.append(" -j " + info.getMergeRevision1());
            msg.append(" -j " + info.getMergeRevision1());
        }
        if (info.getMergeRevision2() != null && !info.getMergeRevision2().equals("")) {
            sb.append(" -j " + info.getMergeRevision2());
            msg.append(" -j " + info.getMergeRevision2());
        }
        sb.append(this.createFilesString(root, files));
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 3, msg.toString());
    }

    public void commit(File root, File[] files, String message, boolean currentOnly) throws IOException {
        if (files == null || files.length == 0) {
            return;
        }
        this.makeMessageFile(message);
        StringBuffer sb = new StringBuffer();
        StringBuffer msg = new StringBuffer("cvs commit");
        sb.append(this.createCommonCommandString(files));
        sb.append("commit -F ");
        sb.append(this.messageFile.getAbsolutePath());
        if (currentOnly) {
            sb.append(" -l");
        }
        sb.append(this.createFilesString(root, files));
        msg.append(this.createMessageFilesString(files));
        this.executeCommand(sb.toString(), root, 2, msg.toString());
    }

    private String createFilesString(File root, File[] files) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            String fullPath = files[i].getAbsolutePath();
            String rootPath = root.getAbsolutePath();
            sb.append(" ");
            if (rootPath.equals(fullPath)) {
                sb.append(".");
                continue;
            }
            sb.append(fullPath.substring(rootPath.length() + 1, fullPath.length()));
        }
        return sb.toString();
    }

    private String createMessageFilesString(File[] files) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            sb.append(" ");
            sb.append(files[i].getName());
        }
        return sb.toString();
    }

    private String createCommonCommandString(File[] files) throws IOException {
        String cvsRoot = this.getCVSRoot(files[0]);
        StringBuffer sb = new StringBuffer();
        sb.append(this.cvsCommand);
        sb.append(" -d ");
        sb.append(cvsRoot);
        if (this.getQuietMode()) {
            sb.append(" -q");
        }
        sb.append(" ");
        return sb.toString();
    }

    private void executeCommand(String command, File execDir, int code, String message) throws IOException {
        ExecuteCommandThread thread = new ExecuteCommandThread(command, execDir, code, message);
        thread.start();
    }

    private synchronized void callListenerForEndCommand(int command) {
        SwingUtilities.invokeLater(new EndListenerThread(command));
    }

    private synchronized void callListenerForStartCommand(int command) {
        SwingUtilities.invokeLater(new StartListenerThread(command));
    }

    private synchronized void callListenerForError(Exception ex) {
        SwingUtilities.invokeLater(new ErrorListenerThread(ex));
    }

    private String getCVSRoot(File file) throws IOException {
        File cvs = new File(file, "CVS");
        File root = new File(cvs, "Root");
        if (!root.exists()) {
            file = file.getParentFile();
            cvs = new File(file, "CVS");
            root = new File(cvs, "Root");
        }
        String cvsRoot = Util.loadFile(root);
        cvsRoot = Util.replace(cvsRoot, "\r", "");
        cvsRoot = Util.replace(cvsRoot, "\n", "");
        return cvsRoot;
    }

    private synchronized void printMessage(String message) {
        try {
            this.out.write(message.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void makeMessageFile(String message) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.messageFile), this.charset);
        writer.write(message, 0, message.length());
        writer.close();
    }

    private class OutputThread
    extends Thread {
        private BufferedReader in;
        private boolean endFlag = false;

        public OutputThread(InputStream in) {
            try {
                this.in = new BufferedReader(new InputStreamReader(in, "8859_1"));
            }
            catch (Exception ex) {
                this.in = new BufferedReader(new InputStreamReader(in));
            }
        }

        public boolean isEnd() {
            return this.endFlag;
        }

        public void run() {
            try {
                String line = null;
                while ((line = this.in.readLine()) != null) {
                    line = new String(line.getBytes("8859_1"), "JISAutoDetect");
                    CVS.this.printMessage(line + "\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.endFlag = true;
        }
    }

    private class ExecuteCommandThread
    extends Thread {
        private String command;
        private String message;
        private File execDir;
        private int code;

        public ExecuteCommandThread(String command, File execDir, int code, String message) {
            this.command = command;
            this.message = message;
            this.execDir = execDir;
            this.code = code;
        }

        public void run() {
            try {
                CVS.this.callListenerForStartCommand(this.code);
                CVS.this.printMessage(this.message + "\n");
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(this.command, Main.getenv(), new File(this.execDir.getAbsolutePath()));
                OutputThread thread1 = new OutputThread(process.getInputStream());
                OutputThread thread2 = new OutputThread(process.getErrorStream());
                thread1.start();
                thread2.start();
                process.waitFor();
                while (!thread1.isEnd() || !thread2.isEnd()) {
                    ExecuteCommandThread.sleep(100L);
                }
                int result = process.exitValue();
                String exitMessage = Util.getProperty("message.cvs.exit");
                exitMessage = Util.replace(exitMessage, "${code}", String.valueOf(result));
                CVS.this.printMessage(exitMessage + "\n\n");
                CVS.this.callListenerForEndCommand(this.code);
            }
            catch (Exception ex) {
                CVS.this.callListenerForError(ex);
            }
        }
    }

    private class ErrorListenerThread
    extends Thread {
        private Exception ex;

        public ErrorListenerThread(Exception ex) {
            this.ex = ex;
        }

        public void run() {
            for (int i = 0; i < CVS.this.listeners.size(); ++i) {
                CVSListener listener = (CVSListener)CVS.this.listeners.get(i);
                listener.error(this.ex);
            }
        }
    }

    private class StartListenerThread
    extends Thread {
        private int command;

        public StartListenerThread(int command) {
            this.command = command;
        }

        public void run() {
            for (int i = 0; i < CVS.this.listeners.size(); ++i) {
                CVSListener listener = (CVSListener)CVS.this.listeners.get(i);
                listener.startCommand(this.command);
            }
        }
    }

    private class EndListenerThread
    extends Thread {
        private int command;

        public EndListenerThread(int command) {
            this.command = command;
        }

        public void run() {
            for (int i = 0; i < CVS.this.listeners.size(); ++i) {
                CVSListener listener = (CVSListener)CVS.this.listeners.get(i);
                listener.endCommand(this.command);
            }
        }
    }
}

