/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CommandExecuter {
    private OutputStream stdout = null;
    private OutputStream stderr = null;
    private OutputStream stdin = null;
    private boolean isEnd = true;
    private int exitStatus = -1;
    private String lastCommand = null;
    private File dir = null;
    private String[] env = null;

    public void setStdOutputStream(OutputStream out) {
        this.stdout = out;
    }

    public void setErrOutputStream(OutputStream out) {
        this.stderr = out;
    }

    public void setDirectory(File dir) {
        this.dir = dir;
    }

    public void setEnvironment(String[] env) {
        this.env = env;
    }

    public synchronized void execute(String command, boolean block) throws IOException {
        if (!this.isEnd) {
            throw new IOException("\u30b3\u30de\u30f3\u30c9\u306f\u5b9f\u884c\u4e2d\u3067\u3059\u3002(" + this.lastCommand + ")");
        }
        this.isEnd = false;
        this.lastCommand = command;
        CommandExecuteThread thread = new CommandExecuteThread(command);
        if (block) {
            thread.run();
        } else {
            thread.start();
        }
    }

    public synchronized void input(String input) throws IOException {
        if (this.isEnd) {
            throw new IOException("\u30b3\u30de\u30f3\u30c9\u306f\u5b9f\u884c\u4e2d\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        this.stdin.write(input.getBytes());
    }

    public boolean isEnd() {
        return this.isEnd;
    }

    public int getExitStatus() {
        return this.exitStatus;
    }

    public String getLastCommand() {
        return this.lastCommand;
    }

    private class OutputStreamThread
    extends Thread {
        private InputStream in;
        private OutputStream out;

        public OutputStreamThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            try {
                byte[] buf = new byte[8192];
                int length = 0;
                while ((length = this.in.read(buf)) != -1) {
                    if (this.out == null) continue;
                    this.out.write(buf, 0, length);
                }
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class CommandExecuteThread
    extends Thread {
        private String command;

        public CommandExecuteThread(String command) {
            this.command = command;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(this.command, CommandExecuter.this.env, CommandExecuter.this.dir);
                CommandExecuter.this.stdin = process.getOutputStream();
                InputStream in = process.getInputStream();
                InputStream err = process.getErrorStream();
                new OutputStreamThread(in, CommandExecuter.this.stdout).start();
                new OutputStreamThread(err, CommandExecuter.this.stderr).start();
                process.waitFor();
                CommandExecuter.this.exitStatus = process.exitValue();
            }
            catch (Exception exception) {
            }
            finally {
                CommandExecuter.this.isEnd = true;
            }
        }
    }
}

