/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import tk.javacvs.Util;

public class EntryInfo {
    private File file;
    private Object[] result = new Object[0];
    private SimpleDateFormat df = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.ENGLISH);
    public static final int SORT_BY_NAME = 0;
    private FileNameComparator sortNameComparator = new FileNameComparator();

    public EntryInfo(File dir) {
        int i;
        this.file = dir;
        this.df.setTimeZone(TimeZone.getTimeZone("GMT"));
        File[] files = dir.listFiles();
        CVSInfo[] infos = new CVSInfo[]{};
        try {
            infos = this.getCVSInfo();
        }
        catch (Exception ex) {
            // empty catch block
        }
        ArrayList<CVSInfo> list = new ArrayList<CVSInfo>();
        for (i = 0; i < infos.length; ++i) {
            list.add(infos[i]);
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i].isDirectory() && files[i].getName().equals("CVS")) continue;
            boolean flag = false;
            for (int j = 0; j < infos.length; ++j) {
                if (!files[i].equals(infos[j].file)) continue;
                flag = true;
                break;
            }
            if (flag) continue;
            if (files[i].isDirectory() && new File(files[i], "CVS").exists()) {
                list.add(new CVSInfo(files[i], null, null, null, null, false, false, files[i].isDirectory(), false));
                continue;
            }
            list.add(new CVSInfo(files[i], null, null, null, null, true, false, files[i].isDirectory(), false));
        }
        this.result = list.toArray();
    }

    public void sort(int sort, boolean asc) {
        if (sort == 0) {
            this.sortNameComparator.setAsc(asc);
            Arrays.sort(this.result, this.sortNameComparator);
        }
    }

    public int count() {
        return this.result.length;
    }

    public File getFile(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        return info.file;
    }

    public String getTag(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        if (info.tag == null) {
            return "";
        }
        return info.tag.substring(1);
    }

    public String getRevision(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        if (info.revision == null) {
            return "";
        }
        return info.revision;
    }

    public String getOption(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        if (info.revision == null) {
            return "";
        }
        return info.option;
    }

    public boolean isCVSFile(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        return !info.noCVS;
    }

    public boolean isModified(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        return info.modified;
    }

    public boolean isDirectory(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        return info.isDir;
    }

    public boolean isMerged(int i) {
        CVSInfo info = (CVSInfo)this.result[i];
        return info.merged;
    }

    private CVSInfo[] getCVSInfo() throws IOException, ParseException {
        File cvs = new File(this.file, "CVS");
        File entry = new File(cvs, "Entries");
        String text = Util.loadFile(entry);
        String[] lines = Util.split(text, "\n");
        ArrayList<CVSInfo> list = new ArrayList<CVSInfo>();
        for (int i = 0; i < lines.length; ++i) {
            try {
                String[] items = Util.split(lines[i], "/");
                File file = new File(this.file, items[1]);
                String tag = null;
                String revision = null;
                Date date = null;
                boolean modified = false;
                boolean isDir = false;
                boolean merged = false;
                String option = items[4];
                if (items[0].equals("D")) {
                    isDir = true;
                }
                if (!items[2].equals("")) {
                    revision = items[2];
                }
                if (revision != null && revision.equals("0")) {
                    modified = true;
                } else if (revision != null && revision.startsWith("-")) {
                    modified = true;
                } else {
                    Date fileMod;
                    if (items[3].equals("Result of merge")) {
                        modified = true;
                        merged = true;
                    } else if (!items[3].equals("")) {
                        date = this.df.parse(items[3]);
                    }
                    if (items.length >= 6 && !items[5].equals("")) {
                        tag = items[5];
                    }
                    if (file.isFile() && file.exists() && date != null && !(fileMod = new Date(file.lastModified())).toString().equals(date.toString())) {
                        modified = true;
                    }
                }
                list.add(new CVSInfo(file, date, tag, revision, option, false, modified, isDir, merged));
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return list.toArray(new CVSInfo[list.size()]);
    }

    public class FileNameComparator
    implements Comparator {
        private int asc = 1;

        public void setAsc(boolean asc) {
            this.asc = asc ? 1 : -1;
        }

        public int compare(Object obj1, Object obj2) {
            CVSInfo info1 = (CVSInfo)obj1;
            CVSInfo info2 = (CVSInfo)obj2;
            File file1 = info1.file;
            File file2 = info2.file;
            if (info1.isDir && !info2.isDir) {
                return -1 * this.asc;
            }
            if (!info1.isDir && info2.isDir) {
                return 1 * this.asc;
            }
            String str1 = file1.getName();
            String str2 = file2.getName();
            return str1.compareTo(str2) * this.asc;
        }
    }

    private class CVSInfo {
        private File file;
        private Date date;
        private String revision;
        private String tag;
        private String option;
        private boolean noCVS;
        private boolean modified;
        private boolean isDir;
        private boolean merged;

        public CVSInfo(File file, Date date, String tag, String revision, String option, boolean noCVS, boolean modified, boolean isDir, boolean merged) {
            this.file = file;
            this.date = date;
            this.tag = tag;
            this.revision = revision;
            this.option = option;
            this.noCVS = noCVS;
            this.modified = modified;
            this.isDir = isDir;
            this.merged = merged;
        }
    }
}

