/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class Util {
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss", Locale.ENGLISH);
    private static ResourceBundle resources = ResourceBundle.getBundle("resources.javacvs", Locale.getDefault());
    private static int debug = Util.parseInt(Util.getProperty("debug.mode"));
    private static File logfile = new File(Util.getProperty("debug.file"));

    public static boolean match(String text, String search) {
        int index1 = 0;
        int index2 = 0;
        while (index1 < text.length() && index2 < search.length()) {
            char c2 = search.charAt(index2);
            ++index2;
            if (c2 == '*') {
                if (index2 < search.length()) {
                    c2 = search.charAt(index2);
                    ++index2;
                    boolean flag = false;
                    while (index1 < text.length()) {
                        char c1 = text.charAt(index1);
                        ++index1;
                        if (c2 != c1) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    return false;
                }
                return true;
            }
            if (c2 == '?') {
                ++index1;
                continue;
            }
            char c1 = text.charAt(index1);
            ++index1;
            if (c1 == c2) continue;
            return false;
        }
        return index1 == text.length() && index2 == search.length();
    }

    public static String[] split(String s1, String s2) {
        if (s1 == null) {
            return null;
        }
        ArrayList<String> v = new ArrayList<String>();
        int last = 0;
        int index = 0;
        while ((index = s1.indexOf(s2, last)) != -1) {
            v.add(s1.substring(last, index));
            last = index + s2.length();
        }
        if (last != s1.length()) {
            v.add(s1.substring(last));
        }
        return v.toArray(new String[v.size()]);
    }

    public static String replace(String s, String s1, String s2) {
        if (s == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int index = -1;
        int count = 0;
        while ((index = s.indexOf(s1, count)) != -1) {
            sb.append(s.substring(count, index));
            sb.append(s2);
            count = index + s1.length();
        }
        sb.append(s.substring(count, s.length()));
        return sb.toString();
    }

    public static String loadFile(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        int length = 0;
        while ((length = in.read(buf)) != -1) {
            out.write(buf, 0, length);
        }
        in.close();
        String text = new String(out.toByteArray());
        return text;
    }

    public static void saveFile(File file, String str) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(file);
        out.write(str.getBytes());
        out.flush();
        out.close();
    }

    public static String trim(String str) {
        char c;
        int i;
        if (str == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        boolean flagTop = false;
        for (i = 0; i < str.length(); ++i) {
            c = str.charAt(i);
            if (!flagTop && (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u3000')) continue;
            sb.append(c);
            flagTop = true;
        }
        for (i = sb.length() - 1; i >= 0 && ((c = sb.charAt(i)) == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\u3000'); --i) {
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    public static int parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            return 0;
        }
    }

    public static String formatDate(Date date) {
        return df.format(date);
    }

    public static void removeDirectory(File dir) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isFile()) {
                files[i].delete();
                continue;
            }
            Util.removeDirectory(files[i]);
        }
        dir.delete();
    }

    public static String getProperty(String key) {
        String str;
        try {
            str = resources.getString(key);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    public static URL getPropertyURL(String key) {
        String name = Util.getProperty(key);
        URL url = null;
        if (name != null) {
            url = name.getClass().getResource(name);
        }
        return url;
    }

    public static Image getPropertyImage(String key) {
        URL url = Util.getPropertyURL(key);
        Image image = null;
        if (url != null) {
            image = new ImageIcon(url).getImage();
        }
        return image;
    }

    public static void log(String message) {
        if (debug == 1) {
            try {
                FileWriter fw = new FileWriter(logfile, true);
                fw.write("[" + Util.formatDate(new Date()) + "]" + message + "\n");
                fw.flush();
                fw.close();
            }
            catch (Exception logEx) {
                logEx.printStackTrace();
            }
        }
    }

    public static void log(Exception ex) {
        if (debug == 1) {
            try {
                PrintWriter pw = new PrintWriter(new FileWriter(logfile, true));
                pw.write("[" + Util.formatDate(new Date()) + "]\n");
                ex.printStackTrace(pw);
                pw.flush();
                pw.close();
            }
            catch (Exception logEx) {
                logEx.printStackTrace();
            }
        }
    }
}

