/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import tk.javacvs.Util;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.action.AbstractToggleAction;
import tk.javacvs.swing.action.AddAction;
import tk.javacvs.swing.action.CVSAction;
import tk.javacvs.swing.action.CVSOnlyAction;
import tk.javacvs.swing.action.CheckoutAction;
import tk.javacvs.swing.action.ClearOutputViewAction;
import tk.javacvs.swing.action.CommitAction;
import tk.javacvs.swing.action.ConfigAction;
import tk.javacvs.swing.action.CreateTagAction;
import tk.javacvs.swing.action.DiffAction;
import tk.javacvs.swing.action.GraphAction;
import tk.javacvs.swing.action.ImportAction;
import tk.javacvs.swing.action.LogAction;
import tk.javacvs.swing.action.ModOnlyAction;
import tk.javacvs.swing.action.MountAction;
import tk.javacvs.swing.action.NoCVSOnlyAction;
import tk.javacvs.swing.action.OpenAction;
import tk.javacvs.swing.action.OutputViewCopyAction;
import tk.javacvs.swing.action.OutputViewSelectAllAction;
import tk.javacvs.swing.action.RecurseAction;
import tk.javacvs.swing.action.ReloadAction;
import tk.javacvs.swing.action.RemoveAction;
import tk.javacvs.swing.action.RemoveLocalAction;
import tk.javacvs.swing.action.RemoveTagAction;
import tk.javacvs.swing.action.StatusAction;
import tk.javacvs.swing.action.UnmountAction;
import tk.javacvs.swing.action.UpdateAction;
import tk.javacvs.swing.action.VersionAction;

public class Actions {
    private HashMap actions = new HashMap();
    private HashMap toggles = new HashMap();
    private HashMap nemonic = new HashMap();
    private HashMap accelerator = new HashMap();

    public Actions(MainWindow window) {
        this.actions.put("Mount", new MountAction(Util.getProperty("menu.file.mount"), new ImageIcon(Util.getPropertyImage("icon.etc_folder")), window));
        this.nemonic.put("Mount", new Integer(77));
        this.actions.put("Unmount", new UnmountAction(Util.getProperty("menu.file.unmount"), window));
        this.nemonic.put("Unmount", new Integer(85));
        this.actions.put("Checkout", new CheckoutAction(Util.getProperty("menu.file.checkout"), new ImageIcon(Util.getPropertyImage("icon.checkout")), window));
        this.nemonic.put("Checkout", new Integer(67));
        this.actions.put("Import", new ImportAction(Util.getProperty("menu.file.import"), new ImageIcon(Util.getPropertyImage("icon.import")), window));
        this.nemonic.put("Import", new Integer(73));
        this.actions.put("Config", new ConfigAction(Util.getProperty("menu.file.config"), window));
        this.nemonic.put("Config", new Integer(83));
        this.actions.put("Open", new OpenAction(Util.getProperty("menu.file.open"), window));
        this.nemonic.put("Open", new Integer(79));
        this.accelerator.put("Open", "control O");
        this.actions.put("Update", new UpdateAction(Util.getProperty("menu.cvs.update"), new ImageIcon(Util.getPropertyImage("icon.update")), window));
        this.nemonic.put("Update", new Integer(85));
        this.accelerator.put("Update", "control U");
        this.actions.put("Commit", new CommitAction(Util.getProperty("menu.cvs.commit"), new ImageIcon(Util.getPropertyImage("icon.commit")), window));
        this.nemonic.put("Commit", new Integer(67));
        this.accelerator.put("Commit", "control C");
        this.actions.put("Add", new AddAction(Util.getProperty("menu.cvs.add"), new ImageIcon(Util.getPropertyImage("icon.add")), window));
        this.nemonic.put("Add", new Integer(65));
        this.accelerator.put("Add", "control A");
        this.actions.put("Add Binary", new AddAction(Util.getProperty("menu.cvs.addkb"), new ImageIcon(Util.getPropertyImage("icon.addkb")), window, true));
        this.nemonic.put("Add Binary", new Integer(66));
        this.accelerator.put("Add Binary", "control B");
        this.actions.put("Remove from Local", new RemoveLocalAction(Util.getProperty("menu.cvs.delete"), window));
        this.actions.put("Remove from Repository", new RemoveAction(Util.getProperty("menu.cvs.remove"), new ImageIcon(Util.getPropertyImage("icon.remove")), window));
        this.nemonic.put("Remove from Repository", new Integer(82));
        this.accelerator.put("Remove from Repository", "DELETE");
        this.actions.put("Diff", new DiffAction(Util.getProperty("menu.cvs.diff"), new ImageIcon(Util.getPropertyImage("icon.diff")), window));
        this.nemonic.put("Diff", new Integer(68));
        this.accelerator.put("Diff", "control D");
        this.actions.put("Log", new LogAction(Util.getProperty("menu.cvs.log"), new ImageIcon(Util.getPropertyImage("icon.log")), window));
        this.nemonic.put("Log", new Integer(76));
        this.accelerator.put("Log", "control L");
        this.actions.put("Status", new StatusAction(Util.getProperty("menu.cvs.status"), new ImageIcon(Util.getPropertyImage("icon.status")), window));
        this.nemonic.put("Status", new Integer(83));
        this.accelerator.put("Status", "control S");
        this.actions.put("Graph", new GraphAction(Util.getProperty("menu.cvs.graph"), new ImageIcon(Util.getPropertyImage("icon.graph")), window));
        this.nemonic.put("Graph", new Integer(71));
        this.accelerator.put("Graph", "control G");
        this.actions.put("Create Tag", new CreateTagAction(Util.getProperty("menu.cvs.createtag"), new ImageIcon(Util.getPropertyImage("icon.createtag")), window));
        this.nemonic.put("Create Tag", new Integer(84));
        this.accelerator.put("Create Tag", "control T");
        this.actions.put("Remove Tag", new RemoveTagAction(Util.getProperty("menu.cvs.removetag"), new ImageIcon(Util.getPropertyImage("icon.removetag")), window));
        this.actions.put("Reload", new ReloadAction(Util.getProperty("menu.view.reload"), new ImageIcon(Util.getPropertyImage("icon.reload")), window));
        this.nemonic.put("Reload", new Integer(69));
        this.accelerator.put("Reload", "F5");
        this.actions.put("OutputClear", new ClearOutputViewAction(Util.getProperty("menu.view.clear"), window));
        this.actions.put("OutputCopy", new OutputViewCopyAction(Util.getProperty("menu.view.copy"), window));
        this.actions.put("OutputSelectAll", new OutputViewSelectAllAction(Util.getProperty("menu.view.selectall"), window));
        this.actions.put("Version", new VersionAction(Util.getProperty("menu.help.version"), window));
        this.nemonic.put("Version", new Integer(86));
        this.toggles.put("Recurse", new RecurseAction(Util.getProperty("menu.view.recurse"), new ImageIcon(Util.getPropertyImage("icon.recurse")), window));
        this.nemonic.put("Recurse", new Integer(82));
        this.toggles.put("ModOnly", new ModOnlyAction(Util.getProperty("menu.view.modonly"), new ImageIcon(Util.getPropertyImage("icon.modonly")), window));
        this.nemonic.put("ModOnly", new Integer(77));
        this.toggles.put("NoCVSOnly", new NoCVSOnlyAction(Util.getProperty("menu.view.nocvsonly"), new ImageIcon(Util.getPropertyImage("icon.nocvsonly")), window));
        this.nemonic.put("NoCVSOnly", new Integer(78));
        this.toggles.put("CVSOnly", new CVSOnlyAction(Util.getProperty("menu.view.cvsonly"), new ImageIcon(Util.getPropertyImage("icon.cvsonly")), window));
        this.nemonic.put("CVSOnly", new Integer(86));
    }

    public CVSAction getAction(String key) {
        CVSAction action = (CVSAction)this.actions.get(key);
        return action;
    }

    public int getNemonic(String key) {
        if (this.nemonic.get(key) == null) {
            return -1;
        }
        return (Integer)this.nemonic.get(key);
    }

    public String getAccelerator(String key) {
        if (this.accelerator.get(key) == null) {
            return null;
        }
        return (String)this.accelerator.get(key);
    }

    public JMenuItem getMenuItem(String key) {
        String accelerator;
        JMenuItem item = new JMenuItem(this.getAction(key));
        int nemonic = this.getNemonic(key);
        if (nemonic != -1) {
            item.setMnemonic(nemonic);
        }
        if ((accelerator = this.getAccelerator(key)) != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
        return item;
    }

    public JCheckBoxMenuItem getToggleMenuItem(String key) {
        String accelerator;
        JCheckBoxMenuItem item = this.getToggleAction(key).createMenuItem();
        int nemonic = this.getNemonic(key);
        if (nemonic != -1) {
            item.setMnemonic(nemonic);
        }
        if ((accelerator = this.getAccelerator(key)) != null) {
            item.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
        return item;
    }

    public AbstractToggleAction getToggleAction(String key) {
        AbstractToggleAction action = (AbstractToggleAction)this.toggles.get(key);
        return action;
    }

    public void updateActions() {
        Iterator i = this.actions.keySet().iterator();
        while (i.hasNext()) {
            CVSAction action = (CVSAction)this.actions.get(i.next());
            action.update();
        }
    }
}

