/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import tk.javacvs.Util;

public class Config {
    private ArrayList mountInfo = new ArrayList();
    private boolean quietMode = false;
    private static final String CONFIG_FILE = "config.dat";
    private String editor = "";
    private String cvsCommand = "cvs";
    private HashMap editors = new HashMap();
    private String charset = "EUC-JP";
    private boolean useExternalDiff = false;
    private String externalDiffProgram = "";

    public boolean addMountDirectory(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        for (int i = 0; i < this.mountInfo.size(); ++i) {
            File file = (File)this.mountInfo.get(i);
            if (!file.equals(dir)) continue;
            return false;
        }
        this.mountInfo.add(dir);
        return true;
    }

    public boolean removeMountDirectory(File dir) {
        for (int i = 0; i < this.mountInfo.size(); ++i) {
            File file = (File)this.mountInfo.get(i);
            if (!file.equals(dir)) continue;
            this.mountInfo.remove(i);
            return true;
        }
        return false;
    }

    public File[] getMountDirectories() {
        return this.mountInfo.toArray(new File[this.mountInfo.size()]);
    }

    public void setQuietMode(boolean quietMode) {
        this.quietMode = quietMode;
    }

    public boolean getQuietMode() {
        return this.quietMode;
    }

    public void setEditor(String editor) {
        if (editor != null) {
            this.editor = editor;
        }
    }

    public String getEditor() {
        return this.editor;
    }

    public void setCVSCommand(String cvsCommand) {
        if (cvsCommand != null) {
            this.cvsCommand = cvsCommand;
        }
    }

    public String getCVSCommand() {
        return this.cvsCommand;
    }

    public void setEditor(String extention, String program) {
        this.editors.put(extention, program);
    }

    public String getEditor(String extention) {
        if (this.editors.get(extention) == null) {
            return this.getEditor();
        }
        return (String)this.editors.get(extention);
    }

    public void removeEditor(String extention) {
        this.editors.remove(extention);
    }

    public String[] getExtentions() {
        Iterator ite = this.editors.keySet().iterator();
        ArrayList list = new ArrayList();
        while (ite.hasNext()) {
            list.add(ite.next());
        }
        return list.toArray(new String[list.size()]);
    }

    public void save() throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(CONFIG_FILE));
        out.write("[mount]");
        out.newLine();
        for (int i = 0; i < this.mountInfo.size(); ++i) {
            File file = (File)this.mountInfo.get(i);
            out.write(file.getAbsolutePath());
            out.newLine();
        }
        out.write("[option]");
        out.newLine();
        out.write("quietMode=" + String.valueOf(this.quietMode));
        out.newLine();
        out.write("editor=" + this.editor);
        out.newLine();
        out.write("cvs=" + this.cvsCommand);
        out.newLine();
        out.write("charset=" + this.charset);
        out.newLine();
        out.write("useExternalDiff=" + this.useExternalDiff);
        out.newLine();
        out.write("externalDiffProgram=" + this.externalDiffProgram);
        out.newLine();
        String[] extentions = this.getExtentions();
        for (int i = 0; i < extentions.length; ++i) {
            out.write("extention." + extentions[i] + "=" + this.getEditor(extentions[i]));
            out.newLine();
        }
        out.flush();
        out.close();
    }

    public void load() throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(CONFIG_FILE));
        String line = null;
        int mode = 0;
        while ((line = in.readLine()) != null) {
            try {
                if ((line = Util.trim(line)).startsWith("#") || line.equals("")) continue;
                if (line.equals("[mount]")) {
                    mode = 1;
                    continue;
                }
                if (line.equals("[option]")) {
                    mode = 2;
                    continue;
                }
                if (mode == 1) {
                    this.addMountDirectory(new File(line));
                }
                if (mode != 2) continue;
                String[] value = new String[]{line.substring(0, line.indexOf("=")), line.substring(line.indexOf("=") + 1)};
                if (value[0].equals("quietMode")) {
                    boolean quietMode = Boolean.valueOf(value[1]);
                    this.setQuietMode(quietMode);
                    continue;
                }
                if (value[0].equals("editor")) {
                    this.setEditor(value[1]);
                    continue;
                }
                if (value[0].equals("cvs")) {
                    this.setCVSCommand(value[1]);
                    continue;
                }
                if (value[0].equals("charset")) {
                    this.setCharset(value[1]);
                    continue;
                }
                if (value[0].equals("useExternalDiff")) {
                    this.setUseExternalDiff(Boolean.valueOf(value[1]));
                    continue;
                }
                if (value[0].equals("externalDiffProgram")) {
                    this.setExternalDiffProgram(value[1]);
                    continue;
                }
                if (!value[0].startsWith("extention.")) continue;
                String extention = value[0].substring(value[0].indexOf(".") + 1);
                this.setEditor(extention, value[1]);
            }
            catch (Exception ex) {}
        }
        in.close();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setUseExternalDiff(boolean useExternalDiff) {
        this.useExternalDiff = useExternalDiff;
    }

    public boolean getUseExternalDiff() {
        return this.useExternalDiff;
    }

    public void setExternalDiffProgram(String externalDiffProgram) {
        this.externalDiffProgram = externalDiffProgram;
    }

    public String getExternalDiffProgram() {
        return this.externalDiffProgram;
    }
}

