/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tk.javacvs.EntryInfo;
import tk.javacvs.Util;
import tk.javacvs.swing.Actions;
import tk.javacvs.swing.FileInfo;
import tk.javacvs.swing.ListView;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SearchInfo;

public class FileList
extends ListView {
    private File dir;
    private MainWindow window;
    private ArrayList data = new ArrayList();
    private JPopupMenu popupMenu;
    private SearchInfo searchInfo;
    private String filter = "";
    private Image imageCVSFolder = Util.getPropertyImage("icon.cvs_folder");
    private Image imageCVSFile = Util.getPropertyImage("icon.cvs_file");
    private Image imageETCFolder = Util.getPropertyImage("icon.etc_folder");
    private Image imageETCFile = Util.getPropertyImage("icon.etc_file");
    private Image imageMissFolder = Util.getPropertyImage("icon.miss_folder");
    private Image imageMissFile = Util.getPropertyImage("icon.miss_file");
    private Image imageModFile = Util.getPropertyImage("icon.mod_file");

    public FileList(MainWindow window) {
        this.window = window;
        this.addColumn("");
        this.addColumn(Util.getProperty("table.column.name"));
        this.addColumn(Util.getProperty("table.column.revision"));
        this.addColumn(Util.getProperty("table.column.option"));
        this.addColumn(Util.getProperty("table.column.status"));
        this.addColumn(Util.getProperty("table.column.tag"));
        this.addColumn(Util.getProperty("table.column.date"));
        TableColumnModel colModel = this.getColumnModel();
        TableColumn col1 = colModel.getColumn(0);
        col1.setPreferredWidth(20);
        col1.setMaxWidth(20);
        ListSelectionModel listModel = this.getSelectionModel();
        listModel.addListSelectionListener(new FolderListListener());
        this.popupMenu = new FileListPopupMenu(window.getActions());
        this.addMouseListener(new FileListMouseListener());
        this.searchInfo = new SearchInfo();
    }

    public void setDirectory(File dir) {
        if (dir != null && !dir.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.dir = dir;
    }

    public void setSearchInfo(SearchInfo searchInfo) {
        this.searchInfo = searchInfo;
        this.reload();
    }

    public SearchInfo getSearchInfo() {
        return this.searchInfo;
    }

    public File getDirectory() {
        return this.dir;
    }

    public void setFilter(String filter) {
        if (!filter.equals(this.filter)) {
            this.filter = filter;
            this.reload();
        }
    }

    public String getFilter() {
        return this.filter;
    }

    public void reload() {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            this.removeRow(0);
        }
        if (this.dir == null) {
            return;
        }
        this.data = new ArrayList();
        this.readDirectory(this.dir);
    }

    private void readDirectory(File dir) {
        EntryInfo info = new EntryInfo(dir);
        info.sort(0, true);
        for (int i = 0; i < info.count(); ++i) {
            File file = info.getFile(i);
            String name = file.getName();
            String rev = info.getRevision(i);
            String tag = info.getTag(i);
            String opt = info.getOption(i);
            Date date = new Date(file.lastModified());
            String stat = Util.getProperty("table.status.file");
            Image image = this.imageCVSFile;
            if (info.isDirectory(i)) {
                if (this.searchInfo == null || !this.searchInfo.getRecurse()) continue;
                this.readDirectory(file);
                continue;
            }
            if (this.searchInfo != null) {
                int skipFlag1 = 0;
                int skipFlag2 = 0;
                int skipFlag3 = 0;
                if (this.searchInfo.getEdit()) {
                    skipFlag1 = !info.isModified(i) ? 1 : -1;
                }
                if (this.searchInfo.getNoCVS()) {
                    skipFlag2 = info.isCVSFile(i) ? 1 : -1;
                }
                if (this.searchInfo.getCVSOnly()) {
                    skipFlag3 = !info.isCVSFile(i) ? 1 : -1;
                }
                if (skipFlag1 == 1 && skipFlag2 != -1 && skipFlag3 != -1 || skipFlag2 == 1 && skipFlag1 != -1 && skipFlag3 != -1 || skipFlag3 == 1 && skipFlag1 != -1 && skipFlag2 != -1) continue;
            }
            if (this.filter != null && !this.filter.equals("") && !Util.match(name, this.filter)) continue;
            if (!info.isCVSFile(i)) {
                stat = stat + Util.getProperty("table.status.no_cvs");
                image = this.imageETCFile;
            } else if (info.isModified(i)) {
                image = this.imageModFile;
            } else if (!file.exists()) {
                image = this.imageMissFile;
            }
            Object[] rowData = new Object[]{image, name, rev, opt, stat, tag, Util.formatDate(date)};
            this.addRow(rowData);
            this.data.add(new FileInfo(info.getFile(i), info.isCVSFile(i)));
        }
    }

    public FileInfo[] getSelectedFileInfo() {
        int[] sel = this.getSelectedRows();
        ArrayList list = new ArrayList();
        for (int i = 0; i < sel.length; ++i) {
            list.add(this.data.get(sel[i]));
        }
        return list.toArray(new FileInfo[list.size()]);
    }

    private class FileListMouseListener
    extends MouseAdapter {
        private FileListMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            File file;
            FileInfo[] info;
            FileList.this.window.setComponentFocus(1);
            FileList.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                FileList.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
            if (evt.getClickCount() == 2 && (info = FileList.this.getSelectedFileInfo()) != null && info.length >= 1 && (file = info[0].getFile()).exists()) {
                if (file.isDirectory()) {
                    FileList.this.setDirectory(file);
                    FileList.this.reload();
                } else {
                    FileList.this.window.openSelectedFile();
                }
            }
        }

        public void mouseReleased(MouseEvent evt) {
            FileList.this.window.setComponentFocus(1);
            FileList.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                FileList.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        public void mousePressed(MouseEvent evt) {
            FileList.this.window.setComponentFocus(1);
            FileList.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                FileList.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class FileListPopupMenu
    extends JPopupMenu {
        public FileListPopupMenu(Actions actions) {
            this.add(actions.getMenuItem("Reload"));
            this.add(actions.getMenuItem("Open"));
            this.addSeparator();
            this.add(actions.getMenuItem("Update"));
            this.add(actions.getMenuItem("Commit"));
            this.addSeparator();
            this.add(actions.getMenuItem("Add"));
            this.add(actions.getMenuItem("Add Binary"));
            this.addSeparator();
            this.add(actions.getMenuItem("Remove from Local"));
            this.add(actions.getMenuItem("Remove from Repository"));
            this.addSeparator();
            this.add(actions.getMenuItem("Diff"));
            this.add(actions.getMenuItem("Log"));
            this.add(actions.getMenuItem("Status"));
            this.add(actions.getMenuItem("Graph"));
            this.addSeparator();
            this.add(actions.getMenuItem("Create Tag"));
            this.add(actions.getMenuItem("Remove Tag"));
        }
    }

    private class FolderListListener
    implements ListSelectionListener {
        private FolderListListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            FileList.this.window.setComponentFocus(1);
            FileList.this.window.updateActions();
        }
    }
}

