/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import tk.javacvs.Util;
import tk.javacvs.swing.Actions;
import tk.javacvs.swing.FileInfo;
import tk.javacvs.swing.MainWindow;

public class FolderTree
extends JTree {
    private MainWindow window;
    private FolderTreeModel model;
    private FolderTreePopupMenu popupMenu;

    public FolderTree(MainWindow window) {
        this.window = window;
        this.model = new FolderTreeModel(new RootNode());
        this.setModel(this.model);
        this.addTreeExpansionListener(new FolderTreeListener());
        this.addTreeSelectionListener(new FolderSelectionListener());
        this.setCellRenderer(new FolderTreeCellRenderer());
        this.popupMenu = new FolderTreePopupMenu(window.getActions());
        this.addMouseListener(new FolderTreeMouseListener());
    }

    public void mountDirectory(File dir) {
        this.model.mount(dir);
    }

    public void unmountDirectory(File dir) {
        this.model.unmount(dir);
    }

    public File getSelectedProjectDirectory() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null || node instanceof RootNode || !((FolderNode)node).isProject()) {
            return null;
        }
        return (File)node.getUserObject();
    }

    public FileInfo getSelectedFileInfo() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null || node instanceof RootNode) {
            return null;
        }
        File file = (File)node.getUserObject();
        return new FileInfo(file, this.isCVSDirectory(file));
    }

    public File getSelectedDirectory() {
        DefaultMutableTreeNode node = this.getSelectedNode();
        if (node == null || node instanceof RootNode) {
            return null;
        }
        return (File)node.getUserObject();
    }

    private boolean isCVSDirectory(File file) {
        File cvsDir = new File(file, "CVS");
        return cvsDir.exists() && cvsDir.isDirectory();
    }

    private DefaultMutableTreeNode getSelectedNode() {
        TreePath path = this.getSelectionPath();
        if (path == null) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        return node;
    }

    private class FolderTreeMouseListener
    extends MouseAdapter {
        private FolderTreeMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            FolderTree.this.window.setComponentFocus(0);
            FolderTree.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                FolderTree.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
        }

        public void mouseReleased(MouseEvent evt) {
            FolderTree.this.window.setComponentFocus(0);
            FolderTree.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                FolderTree.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        public void mousePressed(MouseEvent evt) {
            FolderTree.this.window.setComponentFocus(0);
            FolderTree.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                FolderTree.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class FolderTreePopupMenu
    extends JPopupMenu {
        public FolderTreePopupMenu(Actions actions) {
            this.add(actions.getMenuItem("Update"));
            this.add(actions.getMenuItem("Commit"));
            this.addSeparator();
            this.add(actions.getMenuItem("Add"));
            this.addSeparator();
            this.add(actions.getMenuItem("Remove from Repository"));
            this.addSeparator();
            this.add(actions.getMenuItem("Diff"));
            this.add(actions.getMenuItem("Log"));
            this.add(actions.getMenuItem("Status"));
            this.addSeparator();
            this.add(actions.getMenuItem("Create Tag"));
            this.add(actions.getMenuItem("Remove Tag"));
        }
    }

    public class FolderTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private Icon etc_folder = new ImageIcon(Util.getPropertyImage("icon.etc_folder"));
        private Icon cvs_folder = new ImageIcon(Util.getPropertyImage("icon.cvs_folder"));

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            JLabel cell = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof RootNode) {
                cell.setIcon(this.etc_folder);
            } else if (value instanceof FolderNode) {
                FolderNode node = (FolderNode)value;
                File dir = (File)node.getUserObject();
                if (FolderTree.this.isCVSDirectory(dir)) {
                    cell.setIcon(this.cvs_folder);
                } else {
                    cell.setIcon(this.etc_folder);
                }
            }
            return cell;
        }
    }

    private class FolderSelectionListener
    implements TreeSelectionListener {
        private FolderSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent event) {
            FolderTree.this.window.setComponentFocus(0);
            FolderTree.this.window.updateActions();
            TreePath path = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node instanceof RootNode) {
                FolderTree.this.window.changeListDirectory(null);
                return;
            }
            File file = (File)node.getUserObject();
            FolderTree.this.window.changeListDirectory(file);
        }
    }

    private class FolderTreeListener
    implements TreeExpansionListener {
        private FolderTreeListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            TreePath path = event.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node instanceof RootNode) {
                return;
            }
            node.removeAllChildren();
            File file = (File)node.getUserObject();
            Object[] files = file.listFiles();
            Arrays.sort(files);
            FolderNode lastNode = null;
            for (int i = 0; i < files.length; ++i) {
                if (!((File)files[i]).isDirectory() || ((File)files[i]).getName().equals("CVS")) continue;
                lastNode = new FolderNode((File)files[i]);
                node.add(lastNode);
            }
            FolderTree.this.model.reload(node);
            FolderTree.this.expandPath(new TreePath(node.getPath()));
        }
    }

    private class Folder
    extends File {
        public Folder(File file) {
            super(file.toString());
        }

        public String toString() {
            return this.getName();
        }
    }

    private class FolderNode
    extends DefaultMutableTreeNode {
        private boolean isProject = false;

        public FolderNode(File file) {
            super(new Folder(file));
        }

        public FolderNode(File file, boolean isProject) {
            super(new Folder(file));
            this.isProject = isProject;
        }

        public boolean isProject() {
            return this.isProject;
        }

        public boolean isLeaf() {
            return false;
        }
    }

    private class RootNode
    extends DefaultMutableTreeNode {
        public RootNode() {
            super(Util.getProperty("tree.cvs_projects"));
        }

        public boolean isLeaf() {
            return false;
        }
    }

    private class FolderTreeModel
    extends DefaultTreeModel {
        public FolderTreeModel(TreeNode root) {
            super(root);
        }

        public void mount(File dir) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
            root.add(new FolderNode(dir, true));
            this.reload();
        }

        public void unmount(File dir) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getRoot();
            int count = root.getChildCount();
            for (int i = 0; i < count; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
                File file = (File)node.getUserObject();
                if (!file.equals(dir)) continue;
                root.remove(node);
                break;
            }
            this.reload(root);
        }
    }
}

