/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import tk.javacvs.Util;

public class HistoryComboBox
extends JComboBox {
    private File historyFile;

    public HistoryComboBox(File historyFile) {
        this.setEditable(true);
        this.historyFile = historyFile;
        if (historyFile.exists()) {
            this.loadHistory();
        }
    }

    public String getText() {
        return (String)this.getSelectedItem();
    }

    private void loadHistory() {
        this.addItem("");
        String[] lines = this.getHistoryLines();
        for (int i = 0; i < lines.length; ++i) {
            this.addItem(lines[i]);
        }
    }

    public void saveHistory() {
        try {
            String text = (String)this.getSelectedItem();
            if (text == null || text.equals("")) {
                return;
            }
            String[] lines = this.getHistoryLines();
            boolean flag = true;
            for (int i = 0; i < lines.length; ++i) {
                if (!text.equals(lines[i])) continue;
                flag = false;
                break;
            }
            if (flag) {
                StringBuffer sb = new StringBuffer();
                sb.append(text + "\n");
                for (int i = 0; i < 20 && i < lines.length; ++i) {
                    sb.append(lines[i] + "\n");
                }
                Util.saveFile(this.historyFile, sb.toString());
            }
        }
        catch (IOException ex) {
            Util.log(ex);
        }
    }

    private String[] getHistoryLines() {
        try {
            String history = Util.loadFile(this.historyFile);
            history = Util.replace(history, "\r\n", "\n");
            history = Util.replace(history, "\r", "\n");
            return Util.split(history, "\n");
        }
        catch (Exception ex) {
            return new String[0];
        }
    }
}

