/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import tk.javacvs.CVS;
import tk.javacvs.CVSListener;
import tk.javacvs.Util;
import tk.javacvs.swing.Actions;
import tk.javacvs.swing.Config;
import tk.javacvs.swing.FileInfo;
import tk.javacvs.swing.FileList;
import tk.javacvs.swing.FolderTree;
import tk.javacvs.swing.MainMenu;
import tk.javacvs.swing.OutputView;
import tk.javacvs.swing.SearchInfo;
import tk.javacvs.swing.ToolBar;

public class MainWindow
extends JFrame {
    private CVS cvs;
    private Config config;
    private FolderTree tree;
    private FileList table;
    private OutputView text;
    private Actions actions;
    private MainMenu menu;
    private ToolBar toolbar;
    private String version;
    public static final int FOCUS_TREE = 0;
    public static final int FOCUS_LIST = 1;
    private int focus = -1;

    public MainWindow() {
        if (!new File("./tmp").mkdir()) {
            this.alert(Util.getProperty("message.error_create_tmp"));
            System.exit(1);
        }
        this.config = new Config();
        try {
            this.config.load();
        }
        catch (IOException ex) {
            Util.log(Util.getProperty("message.error_load_config"));
            Util.log(ex);
        }
        this.actions = new Actions(this);
        this.version = Util.getProperty("javacvs.version");
        this.setTitle(this.version);
        this.setIconImage(new ImageIcon(Util.getProperty("javacvs.icon")).getImage());
        this.menu = new MainMenu(this, this.actions);
        this.tree = new FolderTree(this);
        this.table = new FileList(this);
        this.text = new OutputView(this);
        this.toolbar = new ToolBar(this, this.actions);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)this.toolbar, "North");
        JSplitPane hor = new JSplitPane(1);
        hor.add(new JScrollPane(this.tree));
        hor.add(new JScrollPane(this.table));
        JSplitPane ver = new JSplitPane(0);
        ver.add(hor);
        ver.add(new JScrollPane(this.text));
        ver.setDividerLocation(200);
        cp.add((Component)ver, "Center");
        this.setJMenuBar(this.menu);
        this.setSize(640, 400);
        this.addWindowListener(new MainWindowListener());
        File[] files = this.config.getMountDirectories();
        for (int i = 0; i < files.length; ++i) {
            this.mountDirectory(files[i]);
        }
        PipedOutputStream out = new PipedOutputStream();
        this.cvs = new CVS(this.config.getCVSCommand(), out);
        this.cvs.setQuietMode(this.config.getQuietMode());
        this.cvs.setCharset(this.config.getCharset());
        RedirectThread thread = new RedirectThread(out);
        thread.start();
        this.updateActions();
        this.cvs.addCVSListener(new MainCVSListener());
    }

    public CVS getCVS() {
        return this.cvs;
    }

    public void setComponentFocus(int focus) {
        if (focus != 0 && focus != 1) {
            throw new IllegalArgumentException();
        }
        this.focus = focus;
    }

    public void setOutputViewFont(Font font) {
        this.text.setFont(font);
    }

    public void openSelectedFile() {
        FileInfo[] info = this.getSelectedFileInfo();
        for (int i = 0; i < info.length; ++i) {
            File file = info[i].getFile();
            String fileName = file.getName();
            String editor = null;
            if (fileName.indexOf(".") != -1) {
                String extention = fileName.substring(fileName.lastIndexOf(".") + 1);
                editor = this.config.getEditor(extention);
            } else {
                editor = this.config.getEditor();
            }
            if (editor == null || editor.equals("")) {
                this.alert(Util.getProperty("message.no_editor"));
                break;
            }
            String command = editor + " " + file.getAbsolutePath();
            try {
                Runtime runtime = Runtime.getRuntime();
                Process process = runtime.exec(command);
                continue;
            }
            catch (Exception ex) {
                Util.log(Util.getProperty("message.error_open_file"));
                Util.log(ex);
            }
        }
    }

    public OutputView getOutputView() {
        return this.text;
    }

    public void showInformationDialog() {
        String title = Util.getProperty("dialog.title.version");
        String message = this.version + "\n" + "2003-2005 (C) Project Amateras";
        JOptionPane.showMessageDialog(this, message, title, 1);
    }

    public void alert(String message) {
        String title = Util.getProperty("dialog.title.alert");
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    public Actions getActions() {
        return this.actions;
    }

    public void updateActions() {
        this.actions.updateActions();
    }

    public void changeListDirectory(File dir) {
        this.table.setDirectory(dir);
        this.table.setFilter(this.toolbar.getFilter());
        this.table.reload();
    }

    public File getListDirectory() {
        return this.table.getDirectory();
    }

    public void reloadList() {
        this.table.setFilter(this.toolbar.getFilter());
        this.table.reload();
    }

    public Config getConfig() {
        return this.config;
    }

    public void mountDirectory(File file) {
        this.tree.mountDirectory(file);
    }

    public void unmountDirectory(File file) {
        this.tree.unmountDirectory(file);
    }

    public File getSelectedProjectDirectory() {
        if (this.focus == 0) {
            return this.tree.getSelectedProjectDirectory();
        }
        return null;
    }

    public FileInfo[] getSelectedFileInfo() {
        if (this.focus == 0) {
            FileInfo info = this.tree.getSelectedFileInfo();
            if (info == null) {
                return null;
            }
            return new FileInfo[]{info};
        }
        if (this.focus == 1) {
            return this.table.getSelectedFileInfo();
        }
        return null;
    }

    public File getRoot() {
        if (this.focus == 0) {
            return this.tree.getSelectedDirectory().getParentFile();
        }
        if (this.focus == 1) {
            return this.table.getDirectory();
        }
        return null;
    }

    public void setShowRecurse(boolean recurse) {
        this.table.setFilter(this.toolbar.getFilter());
        SearchInfo info = this.table.getSearchInfo();
        info.setRecurse(recurse);
        this.table.setSearchInfo(info);
    }

    public void setShowModOnly(boolean edit) {
        this.table.setFilter(this.toolbar.getFilter());
        SearchInfo info = this.table.getSearchInfo();
        info.setModOnly(edit);
        this.table.setSearchInfo(info);
    }

    public void setShowNoCVSOnly(boolean nocvs) {
        this.table.setFilter(this.toolbar.getFilter());
        SearchInfo info = this.table.getSearchInfo();
        info.setNoCVS(nocvs);
        this.table.setSearchInfo(info);
    }

    public void setShowCVSOnly(boolean cvsOnly) {
        this.table.setFilter(this.toolbar.getFilter());
        SearchInfo info = this.table.getSearchInfo();
        info.setCVSOnly(cvsOnly);
        this.table.setSearchInfo(info);
    }

    private class MainCVSListener
    implements CVSListener {
        private MainCVSListener() {
        }

        public void startCommand(int command) {
        }

        public void endCommand(int command) {
            if (command == 2 || command == 3 || command == 7 || command == 5 || command == 4) {
                MainWindow.this.reloadList();
            }
        }

        public void error(Exception ex) {
            MainWindow.this.alert(ex.getMessage());
            Util.log(ex);
        }
    }

    private class RedirectThread
    extends Thread {
        private BufferedReader in;

        public RedirectThread(PipedOutputStream out) {
            try {
                this.in = new BufferedReader(new InputStreamReader(new PipedInputStream(out)));
            }
            catch (IOException ex) {
                Util.log(ex);
            }
        }

        public void run() {
            String line = null;
            while (true) {
                try {
                    block3: while (true) {
                        RedirectThread.sleep(5L);
                        while (true) {
                            if ((line = this.in.readLine()) == null) continue block3;
                            MainWindow.this.text.insertString(line + "\n");
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private class MainWindowListener
    extends WindowAdapter {
        private MainWindowListener() {
        }

        public void windowClosed(WindowEvent e) {
            this.exit();
        }

        public void windowClosing(WindowEvent e) {
            this.exit();
        }

        private void exit() {
            try {
                MainWindow.this.config.save();
                Util.removeDirectory(new File("./tmp"));
            }
            catch (Exception ex) {
                Util.log(Util.getProperty("message.error_save_config"));
                Util.log(ex);
            }
            System.exit(0);
        }
    }
}

