/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import tk.javacvs.Util;
import tk.javacvs.swing.Actions;
import tk.javacvs.swing.MainWindow;

public class OutputView
extends JTextPane {
    private DefaultStyledDocument doc;
    private Style green;
    private Style red;
    private Style blue;
    private Style yellow;
    private OutputViewPopupMenu popupMenu;
    private MainWindow window;

    public OutputView(MainWindow window) {
        this.window = window;
        this.doc = new DefaultStyledDocument();
        this.setDocument(this.doc);
        this.setEditable(false);
        this.green = this.doc.addStyle(null, null);
        StyleConstants.setForeground(this.green, new Color(0, 128, 0));
        this.red = this.doc.addStyle(null, null);
        StyleConstants.setForeground(this.red, Color.red);
        this.blue = this.doc.addStyle(null, null);
        StyleConstants.setForeground(this.blue, Color.blue);
        this.yellow = this.doc.addStyle(null, null);
        StyleConstants.setForeground(this.yellow, new Color(128, 128, 0));
        this.popupMenu = new OutputViewPopupMenu(window.getActions());
        this.addMouseListener(new OutputViewMouseListener());
    }

    public void insertString(String text) {
        try {
            MutableAttributeSet style = new SimpleAttributeSet();
            if (text.startsWith("====")) {
                style = this.green;
            } else if (text.startsWith("M ")) {
                style = this.red;
            } else if (text.startsWith("? ")) {
                style = this.yellow;
            } else if (text.startsWith("U ")) {
                style = this.green;
            } else if (text.startsWith("A ")) {
                style = this.red;
            } else if (text.startsWith("R ")) {
                style = this.red;
            } else if (text.startsWith("P ")) {
                style = this.red;
            } else if (text.startsWith("C ")) {
                style = this.red;
            } else if (text.startsWith("T ")) {
                style = this.yellow;
            } else if (text.startsWith("N ")) {
                style = this.yellow;
            } else if (text.startsWith("----")) {
                style = this.blue;
            } else if (text.startsWith("> ")) {
                style = this.blue;
            } else if (text.startsWith("< ")) {
                style = this.red;
            }
            this.doc.insertString(this.doc.getLength(), text, style);
            this.setCaretPosition(this.doc.getLength());
        }
        catch (Exception ex) {
            Util.log(ex);
        }
    }

    private class OutputViewMouseListener
    extends MouseAdapter {
        private OutputViewMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            OutputView.this.window.setComponentFocus(0);
            OutputView.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                OutputView.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                return;
            }
        }

        public void mouseReleased(MouseEvent evt) {
            OutputView.this.window.setComponentFocus(0);
            OutputView.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                OutputView.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        public void mousePressed(MouseEvent evt) {
            OutputView.this.window.setComponentFocus(0);
            OutputView.this.window.updateActions();
            if (evt.isPopupTrigger()) {
                OutputView.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }
    }

    private class OutputViewPopupMenu
    extends JPopupMenu {
        public OutputViewPopupMenu(Actions actions) {
            this.add(actions.getMenuItem("OutputCopy"));
            this.addSeparator();
            this.add(actions.getMenuItem("OutputSelectAll"));
            this.add(actions.getMenuItem("OutputClear"));
        }
    }
}

