/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tk.javacvs.Util;
import tk.javacvs.swing.MainWindow;

public class SwingUtil {
    public static JPanel createLabelPanel(JComponent component, String text) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(component);
        panel.add(new JLabel(text));
        return panel;
    }

    public static JPanel createLabelPanel(String text, JComponent component) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new JLabel(text));
        panel.add(component);
        return panel;
    }

    public static JPanel createInputRevisionPanel(JCheckBox checkbox, JComponent text) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(text);
        panel.add(checkbox);
        panel.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.rev_or_date")));
        return panel;
    }

    public static JPanel createVerticalPanel(JComponent[] components) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        for (int i = 0; i < components.length; ++i) {
            panel.add(components[i]);
        }
        JPanel panelWrap = new JPanel();
        panelWrap.setLayout(new FlowLayout(0));
        panelWrap.add(panel);
        return panelWrap;
    }

    public static JPanel createTitledPanel(String text, JComponent component) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)component, "Center");
        panel.setBorder(BorderFactory.createTitledBorder(text));
        return panel;
    }

    public static JPanel createBrowsePanel(MainWindow parent, JTextField text, JButton button) {
        button.addActionListener(new BrowseFileSystemListener(parent, "", text));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(text);
        panel.add(button);
        return panel;
    }

    public static JPanel createBrowsePanel(MainWindow parent, JTextField text, JButton button, String title) {
        JPanel panel = SwingUtil.createBrowsePanel(parent, text, button);
        panel.setBorder(BorderFactory.createTitledBorder(title));
        return panel;
    }

    public static JPanel createBrowseDirPanel(MainWindow parent, JTextField text, JButton button, String title) {
        button.addActionListener(new BrowseFileSystemListener(parent, title, text, true));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        panel.add(text);
        panel.add(button);
        panel.setBorder(BorderFactory.createTitledBorder(title));
        return panel;
    }

    private static class BrowseFileSystemListener
    implements ActionListener {
        private String title;
        private JTextField text;
        private JFileChooser chooser;
        private MainWindow parent;
        private boolean dir;

        public BrowseFileSystemListener(MainWindow parent, String title, JTextField text) {
            this(parent, title, text, false);
        }

        public BrowseFileSystemListener(MainWindow parent, String title, JTextField text, boolean dir) {
            this.parent = parent;
            this.title = title;
            this.text = text;
            this.dir = dir;
            this.chooser = new JFileChooser();
            if (this.dir) {
                this.chooser.setFileSelectionMode(1);
            }
        }

        public void actionPerformed(ActionEvent evt) {
            int result = this.chooser.showOpenDialog(this.parent);
            if (result == 0) {
                File file = this.chooser.getSelectedFile();
                this.text.setText(file.getAbsolutePath());
            }
        }
    }
}

