/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.action;

import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tk.javacvs.Util;
import tk.javacvs.swing.Config;
import tk.javacvs.swing.FileInfo;
import tk.javacvs.swing.MainWindow;

public abstract class CVSAction
extends AbstractAction {
    protected MainWindow window;

    public CVSAction(String name, MainWindow window) {
        super(name, new ImageIcon(Util.getPropertyImage("icon.empty")));
        this.window = window;
    }

    public String getName() {
        return (String)this.getValue("Name");
    }

    public CVSAction(String name, Icon icon, MainWindow window) {
        super(name, icon);
        this.window = window;
    }

    public void update() {
    }

    protected boolean settedCVSCommand() {
        Config config = this.window.getConfig();
        String cvsCommand = config.getCVSCommand();
        return cvsCommand != null && !cvsCommand.equals("");
    }

    protected boolean selectedCVSFiles() {
        FileInfo[] info = this.window.getSelectedFileInfo();
        if (info == null || info.length == 0) {
            return false;
        }
        for (int i = 0; i < info.length; ++i) {
            if (info[i].isCVSFile()) continue;
            return false;
        }
        return true;
    }

    protected boolean selectedNoCVSFiles() {
        FileInfo[] info = this.window.getSelectedFileInfo();
        if (info == null || info.length == 0) {
            return false;
        }
        for (int i = 0; i < info.length; ++i) {
            if (!info[i].isCVSFile()) continue;
            return false;
        }
        return true;
    }

    protected boolean selectedIsExists() {
        FileInfo[] info = this.window.getSelectedFileInfo();
        if (info == null || info.length == 0) {
            return false;
        }
        for (int i = 0; i < info.length; ++i) {
            if (info[i].getFile().exists()) continue;
            return false;
        }
        return true;
    }

    protected boolean selectedFiles() {
        FileInfo[] info = this.window.getSelectedFileInfo();
        if (info == null || info.length == 0) {
            return false;
        }
        for (int i = 0; i < info.length; ++i) {
            if (!info[i].getFile().isDirectory()) continue;
            return false;
        }
        return true;
    }

    protected File[] getSelectedFiles() {
        FileInfo[] info = this.window.getSelectedFileInfo();
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < info.length; ++i) {
            list.add(info[i].getFile());
        }
        File[] files = list.toArray(new File[list.size()]);
        return files;
    }
}

