/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.Icon;
import tk.javacvs.CVS;
import tk.javacvs.LogInfo;
import tk.javacvs.swing.FileInfo;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.action.CVSThreadAction;
import tk.javacvs.swing.graph.Graph;
import tk.javacvs.swing.graph.GraphWindow;

public class GraphAction
extends CVSThreadAction {
    public GraphAction(String name, MainWindow window) {
        super(name, window);
    }

    public GraphAction(String name, Icon icon, MainWindow window) {
        super(name, icon, window);
    }

    public void update() {
        FileInfo[] info = this.window.getSelectedFileInfo();
        if (info == null || info.length != 1 || !info[0].isCVSFile() || !info[0].getFile().isFile()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    public void doProcess() throws Exception {
        PipedOutputStream out = new PipedOutputStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(new PipedInputStream(out)));
        CVS cvs = new CVS(this.window.getConfig().getCVSCommand(), out);
        LogInfo logInfo = new LogInfo();
        File[] files = this.getSelectedFiles();
        logInfo.setFiles(files);
        cvs.log(this.window.getRoot(), logInfo);
        StringBuffer sb = new StringBuffer();
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        in.close();
        out.close();
        Graph graph = new Graph(sb.toString());
        GraphWindow graphWindow = new GraphWindow(this.window, graph, files[0]);
        graphWindow.show();
    }
}

