/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.dialog;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import tk.javacvs.Util;
import tk.javacvs.swing.MainWindow;

public abstract class CVSDialog
extends JDialog {
    protected MainWindow window;
    private JButton ok = new JButton(Util.getProperty("dialog.button.ok"));
    private JButton cancel = new JButton(Util.getProperty("dialog.button.cancel"));

    public CVSDialog(MainWindow window, String title) {
        super((Frame)window, true);
        this.window = window;
        this.setTitle(title);
        Container cp = this.getContentPane();
        JPanel panel = new JPanel();
        panel.add(this.ok);
        panel.add(this.cancel);
        this.ok.addActionListener(new DialogOKListener());
        this.cancel.addActionListener(new DialogCancelListener());
        JPanel subPanel = this.createPanel();
        subPanel.setBorder(BorderFactory.createBevelBorder(0));
        cp.add((Component)subPanel, "North");
        cp.add((Component)panel, "South");
        this.pack();
        this.setResizable(false);
        int x = window.getX() + 16;
        int y = window.getY() + 16;
        this.setLocation(x, y);
    }

    protected abstract JPanel createPanel();

    protected abstract void doProcess() throws Exception;

    private class CVSProcessThread
    extends Thread {
        private CVSProcessThread() {
        }

        public void run() {
            try {
                CVSDialog.this.doProcess();
            }
            catch (Exception ex) {
                CVSDialog.this.window.alert(ex.getMessage());
            }
        }
    }

    private class DialogOKListener
    implements ActionListener {
        private DialogOKListener() {
        }

        public void actionPerformed(ActionEvent event) {
            CVSProcessThread thread = new CVSProcessThread();
            SwingUtilities.invokeLater(thread);
            CVSDialog.this.dispose();
        }
    }

    private class DialogCancelListener
    implements ActionListener {
        private DialogCancelListener() {
        }

        public void actionPerformed(ActionEvent event) {
            CVSDialog.this.dispose();
        }
    }
}

