/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.dialog;

import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tk.javacvs.CVS;
import tk.javacvs.Util;
import tk.javacvs.swing.Config;
import tk.javacvs.swing.HistoryComboBox;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SwingUtil;
import tk.javacvs.swing.dialog.CVSDialog;

public class CheckoutDialog
extends CVSDialog {
    private HistoryComboBox cvsRoot;
    private HistoryComboBox moduleName;
    private JTextField localDir;
    private JCheckBox mount;
    private JButton browse;

    public CheckoutDialog(MainWindow window) {
        super(window, Util.getProperty("dialog.title.checkout"));
    }

    protected JPanel createPanel() {
        this.cvsRoot = new HistoryComboBox(new File("cvsroot.history"));
        this.moduleName = new HistoryComboBox(new File("module.history"));
        this.localDir = new JTextField(20);
        this.mount = new JCheckBox(Util.getProperty("dialog.label.checkout_mount"));
        this.browse = new JButton(Util.getProperty("dialog.button.browse"));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(SwingUtil.createTitledPanel(Util.getProperty("dialog.label.cvsroot"), this.cvsRoot));
        panel.add(SwingUtil.createTitledPanel(Util.getProperty("dialog.label.module"), this.moduleName));
        panel.add(SwingUtil.createBrowseDirPanel(this.window, this.localDir, this.browse, Util.getProperty("dialog.label.local_dir")));
        panel.add(SwingUtil.createVerticalPanel(new JComponent[]{this.mount}));
        return panel;
    }

    protected void doProcess() throws Exception {
        Config config;
        String cvsRoot = this.cvsRoot.getText();
        String moduleName = this.moduleName.getText();
        String localDir = this.localDir.getText();
        File file = new File(localDir);
        File mountDir = new File(file, moduleName);
        if (!(!this.mount.isSelected() || mountDir.exists() && mountDir.isDirectory())) {
            mountDir.mkdir();
        }
        CVS cvs = this.window.getCVS();
        cvs.checkout(cvsRoot, moduleName, file);
        if (this.mount.isSelected() && (config = this.window.getConfig()).addMountDirectory(mountDir)) {
            this.window.mountDirectory(mountDir);
            this.window.updateActions();
        }
        this.cvsRoot.saveHistory();
        this.moduleName.saveHistory();
    }
}

