/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import tk.javacvs.CVS;
import tk.javacvs.Util;
import tk.javacvs.swing.Config;
import tk.javacvs.swing.ListView;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SwingUtil;

public class ConfigDialog
extends JDialog {
    private JTextField cvs;
    private JTextField editor;
    private JCheckBox quietMode;
    private JButton selectCVS;
    private JButton selectEditor;
    private JButton ok;
    private JButton cancel;
    private DefaultTableModel model;
    private MainWindow window;
    private ProgramPanel program;
    private JTextField charset;
    private JCheckBox useExtDiff;
    private JTextField extDiffPrg;
    private JButton browseDiff;

    public ConfigDialog(MainWindow window) {
        super((Frame)window, true);
        this.window = window;
        Config config = window.getConfig();
        String[] extentions = config.getExtentions();
        ExtentionData[] extData = new ExtentionData[extentions.length];
        for (int i = 0; i < extentions.length; ++i) {
            extData[i] = new ExtentionData(extentions[i], config.getEditor(extentions[i]));
        }
        this.setTitle(Util.getProperty("dialog.title.config"));
        JTabbedPane tabPane = new JTabbedPane();
        this.cvs = new JTextField(25);
        this.editor = new JTextField(25);
        this.quietMode = new JCheckBox(Util.getProperty("dialog.label.quietmode"));
        this.selectCVS = new JButton(Util.getProperty("dialog.button.browse"));
        this.selectEditor = new JButton(Util.getProperty("dialog.button.browse"));
        this.ok = new JButton(Util.getProperty("dialog.button.ok"));
        this.cancel = new JButton(Util.getProperty("dialog.button.cancel"));
        this.program = new ProgramPanel(extData);
        this.charset = new JTextField(10);
        this.useExtDiff = new JCheckBox(Util.getProperty("dialog.label.use_ext_diff"));
        this.extDiffPrg = new JTextField(25);
        this.browseDiff = new JButton(Util.getProperty("dialog.button.browse"));
        this.ok.addActionListener(new OKListener());
        this.cancel.addActionListener(new CancelListener());
        JPanel panelCVS = new JPanel();
        panelCVS.setLayout(new BoxLayout(panelCVS, 1));
        panelCVS.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.setup_cvs"), SwingUtil.createBrowsePanel(window, this.cvs, this.selectCVS)));
        panelCVS.add(SwingUtil.createVerticalPanel(new JComponent[]{this.quietMode}));
        panelCVS.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.charset"), this.charset));
        tabPane.addTab(Util.getProperty("dialog.label.setup_cvs"), this.createTabPanel(panelCVS));
        JPanel panelDiff = new JPanel();
        panelDiff.setLayout(new BoxLayout(panelDiff, 1));
        panelDiff.add(SwingUtil.createVerticalPanel(new JComponent[]{this.useExtDiff}));
        panelDiff.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.ext_diff"), SwingUtil.createBrowsePanel(window, this.extDiffPrg, this.browseDiff)));
        this.useExtDiff.addActionListener(new ExternalDiffListener());
        tabPane.addTab(Util.getProperty("dialog.label.diff"), this.createTabPanel(panelDiff));
        JPanel panelEditor = new JPanel();
        panelEditor.setLayout(new BoxLayout(panelEditor, 1));
        panelEditor.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.defaulteditor"), SwingUtil.createBrowsePanel(window, this.editor, this.selectEditor)));
        panelEditor.add(this.program);
        tabPane.addTab(Util.getProperty("dialog.label.setup_editor"), this.createTabPanel(panelEditor));
        JPanel center = new JPanel();
        center.add(tabPane);
        center.setBorder(BorderFactory.createBevelBorder(0));
        JPanel bottom = new JPanel();
        bottom.setLayout(new FlowLayout(2));
        bottom.add(this.ok);
        bottom.add(this.cancel);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add((Component)center, "Center");
        cp.add((Component)bottom, "South");
        this.cvs.setText(config.getCVSCommand());
        this.editor.setText(config.getEditor());
        this.quietMode.setSelected(config.getQuietMode());
        this.charset.setText(config.getCharset());
        this.useExtDiff.setSelected(config.getUseExternalDiff());
        this.extDiffPrg.setText(config.getExternalDiffProgram());
        this.extDiffPrg.setEnabled(config.getUseExternalDiff());
        this.pack();
        this.setResizable(false);
        int x = window.getX() + 16;
        int y = window.getY() + 16;
        this.setLocation(x, y);
    }

    private JPanel createTabPanel(JPanel panel) {
        JPanel container = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)panel, "North");
        return container;
    }

    private class ExtentionData {
        private String extention;
        private String program;

        public ExtentionData(String extention, String program) {
            this.extention = extention;
            this.program = program;
        }

        public String getExtention() {
            return this.extention;
        }

        public String getProgram() {
            return this.program;
        }
    }

    private class ProgramPanel
    extends JPanel {
        private JButton btnAdd = new JButton(Util.getProperty("dialog.button.add"));
        private JButton btnRemove = new JButton(Util.getProperty("dialog.button.remove"));
        private JTextField txtExtention = new JTextField(3);
        private JTextField txtProgram = new JTextField(15);
        private JButton btnBrowse = new JButton(Util.getProperty("dialog.button.browse"));
        private ListView table = new ListView();

        public ProgramPanel(ExtentionData[] data) {
            this.table.addColumn(Util.getProperty("table.column.extention"));
            this.table.addColumn(Util.getProperty("table.column.program"));
            TableColumnModel colModel = this.table.getColumnModel();
            TableColumn col1 = colModel.getColumn(0);
            col1.setPreferredWidth(80);
            col1.setMinWidth(80);
            col1.setMaxWidth(80);
            JPanel panelBrowse = new JPanel();
            panelBrowse.setLayout(new FlowLayout(1));
            panelBrowse.add(new JLabel(Util.getProperty("dialog.label.extention")));
            panelBrowse.add(this.txtExtention);
            panelBrowse.add(SwingUtil.createBrowsePanel(ConfigDialog.this.window, this.txtProgram, this.btnBrowse));
            JPanel panelButton = new JPanel();
            panelButton.setLayout(new FlowLayout(0));
            panelButton.add(this.btnAdd);
            panelButton.add(this.btnRemove);
            JPanel panelSouth = new JPanel();
            panelSouth.setLayout(new BorderLayout());
            panelSouth.add((Component)panelBrowse, "North");
            panelSouth.add((Component)panelButton, "South");
            JScrollPane scroll = new JScrollPane(this.table);
            this.setLayout(new BorderLayout());
            this.add((Component)scroll, "North");
            this.add((Component)panelSouth, "South");
            scroll.setPreferredSize(new Dimension(200, 100));
            this.btnAdd.addActionListener(new ProgramAddListener());
            this.btnRemove.addActionListener(new ProgramRemoveListener());
            for (int i = 0; i < data.length; ++i) {
                this.table.addRow(new String[]{data[i].getExtention(), data[i].getProgram()});
            }
        }

        public ExtentionData[] getData() {
            ExtentionData[] data = new ExtentionData[this.table.getRowCount()];
            for (int i = 0; i < this.table.getRowCount(); ++i) {
                data[i] = new ExtentionData((String)this.table.getValueAt(i, 0), (String)this.table.getValueAt(i, 1));
            }
            return data;
        }

        private class ProgramRemoveListener
        implements ActionListener {
            private ProgramRemoveListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                int[] rows = ProgramPanel.this.table.getSelectedRows();
                if (rows.length != 0) {
                    for (int i = 0; i < rows.length; ++i) {
                        ProgramPanel.this.table.removeRow(rows[i] - i);
                    }
                } else {
                    ConfigDialog.this.window.alert(Util.getProperty("message.error_remove_extprg"));
                }
            }
        }

        private class ProgramAddListener
        implements ActionListener {
            private ProgramAddListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                String extention = ProgramPanel.this.txtExtention.getText();
                String program = ProgramPanel.this.txtProgram.getText();
                if (extention.length() != 0 && program.length() != 0) {
                    ProgramPanel.this.table.addRow(new String[]{extention, program});
                    ProgramPanel.this.txtExtention.setText("");
                    ProgramPanel.this.txtProgram.setText("");
                } else {
                    ConfigDialog.this.window.alert(Util.getProperty("message.error_regist_extprg"));
                }
            }
        }
    }

    private class ExternalDiffListener
    implements ActionListener {
        private ExternalDiffListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConfigDialog.this.extDiffPrg.setEnabled(ConfigDialog.this.useExtDiff.isSelected());
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            ConfigDialog.this.dispose();
        }
    }

    private class OKListener
    implements ActionListener {
        private OKListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            int i;
            Config config = ConfigDialog.this.window.getConfig();
            CVS cvsObj = ConfigDialog.this.window.getCVS();
            config.setCVSCommand(ConfigDialog.this.cvs.getText());
            cvsObj.setCVSCommand(ConfigDialog.this.cvs.getText());
            config.setEditor(ConfigDialog.this.editor.getText());
            config.setQuietMode(ConfigDialog.this.quietMode.isSelected());
            cvsObj.setQuietMode(ConfigDialog.this.quietMode.isSelected());
            config.setCharset(ConfigDialog.this.charset.getText());
            cvsObj.setCharset(ConfigDialog.this.charset.getText());
            config.setUseExternalDiff(ConfigDialog.this.useExtDiff.isSelected());
            config.setExternalDiffProgram(ConfigDialog.this.extDiffPrg.getText());
            ExtentionData[] extData = ConfigDialog.this.program.getData();
            String[] extentions = config.getExtentions();
            for (i = 0; i < extentions.length; ++i) {
                config.removeEditor(extentions[i]);
            }
            for (i = 0; i < extData.length; ++i) {
                config.setEditor(extData[i].getExtention(), extData[i].getProgram());
            }
            ConfigDialog.this.dispose();
        }
    }
}

