/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tk.javacvs.CVS;
import tk.javacvs.DiffInfo;
import tk.javacvs.Util;
import tk.javacvs.swing.Config;
import tk.javacvs.swing.HistoryComboBox;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SwingUtil;
import tk.javacvs.swing.dialog.CVSDialog;

public class DiffDialog
extends CVSDialog {
    private JRadioButton selectLocal;
    private JRadioButton selectLocalRev;
    private JRadioButton selectRevs;
    private JCheckBox selectDate1;
    private JCheckBox selectDate2;
    private HistoryComboBox rev1;
    private HistoryComboBox rev2;
    private JCheckBox currentOnly;
    private JCheckBox skipSpace;
    private JCheckBox skipLetter;
    private File[] files;
    private static int count = 0;

    public DiffDialog(MainWindow window, File[] files) {
        super(window, Util.getProperty("dialog.title.diff"));
        this.files = files;
    }

    protected JPanel createPanel() {
        this.selectLocal = new JRadioButton(Util.getProperty("dialog.label.diff_local"));
        this.selectLocalRev = new JRadioButton(Util.getProperty("dialog.label.diff_local_rev"));
        this.selectRevs = new JRadioButton(Util.getProperty("dialog.label.diff_revs"));
        this.selectDate1 = new JCheckBox(Util.getProperty("dialog.label.select_date"));
        this.selectDate2 = new JCheckBox(Util.getProperty("dialog.label.select_date"));
        this.rev1 = new HistoryComboBox(new File("tag.history"));
        this.rev2 = new HistoryComboBox(new File("tag.history"));
        this.currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
        this.skipSpace = new JCheckBox(Util.getProperty("dialog.label.diff_space"));
        this.skipLetter = new JCheckBox(Util.getProperty("dialog.label.diff_letter"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.selectLocal);
        group.add(this.selectLocalRev);
        group.add(this.selectRevs);
        this.selectLocal.setSelected(true);
        RadioActionListener radioListener = new RadioActionListener();
        this.selectLocal.addActionListener(radioListener);
        this.selectLocalRev.addActionListener(radioListener);
        this.selectRevs.addActionListener(radioListener);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(SwingUtil.createVerticalPanel(new JComponent[]{this.selectLocal, this.selectLocalRev, this.selectRevs}));
        panel.add(SwingUtil.createInputRevisionPanel(this.selectDate1, this.rev1));
        panel.add(SwingUtil.createInputRevisionPanel(this.selectDate2, this.rev2));
        panel.add(SwingUtil.createVerticalPanel(new JComponent[]{this.currentOnly, this.skipSpace, this.skipLetter}));
        this.rev1.setEnabled(false);
        this.rev2.setEnabled(false);
        this.selectDate1.setEnabled(false);
        this.selectDate2.setEnabled(false);
        if (this.window.getConfig().getUseExternalDiff()) {
            this.currentOnly.setEnabled(false);
            this.skipSpace.setEnabled(false);
            this.skipLetter.setEnabled(false);
        }
        return panel;
    }

    protected void doProcess() throws IOException {
        Config config = this.window.getConfig();
        if (config.getUseExternalDiff()) {
            String program = config.getExternalDiffProgram();
            if (program.equals("")) {
                this.window.alert("\u5916\u90e8Diff\u30d7\u30ed\u30b0\u30e9\u30e0\u304c\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
                return;
            }
            for (int i = 0; i < this.files.length; ++i) {
                this.externalDiff(this.files[i]);
            }
        } else {
            DiffInfo info = new DiffInfo();
            info.setFiles(this.files);
            info.setCurrentOnly(this.currentOnly.isSelected());
            info.setSkipSpace(this.skipSpace.isSelected());
            info.setSkipLetterCase(this.skipLetter.isSelected());
            if (this.rev1.isEnabled()) {
                info.setRevision1(this.rev1.getText());
                info.setSelectDate1(this.selectDate1.isSelected());
            }
            if (this.rev2.isEnabled()) {
                info.setRevision2(this.rev2.getText());
                info.setSelectDate2(this.selectDate2.isSelected());
            }
            CVS cvs = this.window.getCVS();
            cvs.diff(this.window.getRoot(), info);
            this.rev1.saveHistory();
            this.rev2.saveHistory();
        }
    }

    private void externalDiff(File file) throws IOException {
        CVS cvs = this.window.getCVS();
        File tmp1 = null;
        tmp1 = this.rev1.isEnabled() ? cvs.checkout(file, this.createTempDirectory(), this.rev1.getText(), this.selectDate1.isSelected()) : cvs.checkout(file, this.createTempDirectory(), null, false);
        String path1 = tmp1.getAbsolutePath();
        String path2 = file.getAbsolutePath();
        if (this.rev2.isEnabled()) {
            File tmp2 = cvs.checkout(file, this.createTempDirectory(), this.rev2.getText(), this.selectDate2.isSelected());
            path2 = tmp2.getAbsolutePath();
        }
        String program = this.window.getConfig().getExternalDiffProgram();
        String command = program + " " + path1 + " " + path2;
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(command);
    }

    private File createTempDirectory() {
        File dir = new File("./tmp/difftmp" + count);
        dir.mkdir();
        ++count;
        return dir;
    }

    private class RadioActionListener
    implements ActionListener {
        private RadioActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            if (obj == DiffDialog.this.selectLocal) {
                DiffDialog.this.rev1.setEnabled(false);
                DiffDialog.this.rev2.setEnabled(false);
                DiffDialog.this.selectDate1.setEnabled(false);
                DiffDialog.this.selectDate2.setEnabled(false);
            } else if (obj == DiffDialog.this.selectLocalRev) {
                DiffDialog.this.rev1.setEnabled(true);
                DiffDialog.this.rev2.setEnabled(false);
                DiffDialog.this.selectDate1.setEnabled(true);
                DiffDialog.this.selectDate2.setEnabled(false);
            } else if (obj == DiffDialog.this.selectRevs) {
                DiffDialog.this.rev1.setEnabled(true);
                DiffDialog.this.rev2.setEnabled(true);
                DiffDialog.this.selectDate1.setEnabled(true);
                DiffDialog.this.selectDate2.setEnabled(true);
            }
        }
    }
}

