/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.dialog;

import java.awt.Component;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tk.javacvs.CVS;
import tk.javacvs.Util;
import tk.javacvs.swing.HistoryComboBox;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SwingUtil;
import tk.javacvs.swing.dialog.CVSDialog;

public class ImportDialog
extends CVSDialog {
    private JTextField importDir;
    private JButton browse;
    private JTextField venderTag;
    private JTextField releaseTag;
    private HistoryComboBox cvsRoot;
    private HistoryComboBox moduleName;

    public ImportDialog(MainWindow window) {
        super(window, Util.getProperty("dialog.title.import"));
    }

    public JPanel createPanel() {
        this.cvsRoot = new HistoryComboBox(new File("cvsroot.history"));
        this.moduleName = new HistoryComboBox(new File("module.history"));
        this.importDir = new JTextField(20);
        this.browse = new JButton(Util.getProperty("dialog.button.browse"));
        this.venderTag = new JTextField(8);
        this.releaseTag = new JTextField(8);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(SwingUtil.createTitledPanel(Util.getProperty("dialog.label.cvsroot"), this.cvsRoot));
        JPanel modulePanel = SwingUtil.createTitledPanel(Util.getProperty("dialog.label.module"), this.moduleName);
        JPanel tagPanel = new JPanel();
        tagPanel.add(new JLabel(Util.getProperty("dialog.label.import_vtag")));
        tagPanel.add(this.venderTag);
        tagPanel.add(new JLabel(Util.getProperty("dialog.label.import_rtag")));
        tagPanel.add(this.releaseTag);
        modulePanel.add((Component)tagPanel, "South");
        panel.add(modulePanel);
        panel.add(SwingUtil.createBrowseDirPanel(this.window, this.importDir, this.browse, Util.getProperty("dialog.label.import_dir")));
        return panel;
    }

    protected void doProcess() throws Exception {
        String cvsRoot = this.cvsRoot.getText();
        String moduleName = this.moduleName.getText();
        String importDir = this.importDir.getText();
        String venderTag = this.venderTag.getText();
        String releaseTag = this.releaseTag.getText();
        File dir = new File(importDir);
        CVS cvs = this.window.getCVS();
        cvs.cvsimport(cvsRoot, moduleName, dir, venderTag, releaseTag);
        this.cvsRoot.saveHistory();
        this.moduleName.saveHistory();
    }
}

