/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.dialog;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tk.javacvs.CVS;
import tk.javacvs.UpdateInfo;
import tk.javacvs.Util;
import tk.javacvs.swing.HistoryComboBox;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SwingUtil;
import tk.javacvs.swing.dialog.CVSDialog;

public class UpdateDialog
extends CVSDialog {
    private JCheckBox createDir;
    private JCheckBox removeDir;
    private JCheckBox removeSticky;
    private JCheckBox updateLocal;
    private JCheckBox currentOnly;
    private HistoryComboBox revision;
    private JCheckBox selectDate;
    private JRadioButton noMerge;
    private JRadioButton mergeRev;
    private JRadioButton mergeRevs;
    private HistoryComboBox mergeRevision1;
    private HistoryComboBox mergeRevision2;
    private JCheckBox checkMerge;
    private File[] files;

    public UpdateDialog(MainWindow window, File[] files) {
        super(window, Util.getProperty("dialog.title.update"));
        this.files = files;
    }

    protected JPanel createPanel() {
        this.createDir = new JCheckBox(Util.getProperty("dialog.label.upd_create_dir"));
        this.removeDir = new JCheckBox(Util.getProperty("dialog.label.upd_del_empty"));
        this.removeSticky = new JCheckBox(Util.getProperty("dialog.label.upd_del_sticky"));
        this.updateLocal = new JCheckBox(Util.getProperty("dialog.label.upd_del_local"));
        this.currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
        this.revision = new HistoryComboBox(new File("tag.history"));
        this.selectDate = new JCheckBox(Util.getProperty("dialog.label.select_date"));
        this.noMerge = new JRadioButton(Util.getProperty("dialog.label.merge_none"));
        this.mergeRev = new JRadioButton(Util.getProperty("dialog.label.merge_rev"));
        this.mergeRevs = new JRadioButton(Util.getProperty("dialog.label.merge_revs"));
        this.mergeRevision1 = new HistoryComboBox(new File("tag.history"));
        this.mergeRevision2 = new HistoryComboBox(new File("tag.history"));
        this.checkMerge = new JCheckBox(Util.getProperty("dialog.label.merge"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.noMerge);
        group.add(this.mergeRev);
        group.add(this.mergeRevs);
        this.noMerge.setSelected(true);
        RadioActionListener radioListener = new RadioActionListener();
        this.noMerge.addActionListener(radioListener);
        this.mergeRev.addActionListener(radioListener);
        this.mergeRevs.addActionListener(radioListener);
        this.mergeRevision1.setEnabled(false);
        this.mergeRevision2.setEnabled(false);
        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, 1));
        panel1.add(SwingUtil.createVerticalPanel(new JComponent[]{this.createDir, this.removeSticky, this.updateLocal, this.currentOnly, this.removeDir}));
        panel1.add(SwingUtil.createInputRevisionPanel(this.selectDate, this.revision));
        panel1.add(SwingUtil.createVerticalPanel(new JComponent[]{this.checkMerge}));
        JPanel panel2 = new JPanel();
        panel2.setLayout(new BoxLayout(panel2, 1));
        panel2.add(SwingUtil.createVerticalPanel(new JComponent[]{this.noMerge, this.mergeRev, this.mergeRevs}));
        panel2.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.merge_text"), this.mergeRevision1));
        panel2.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.merge_text"), this.mergeRevision2));
        panel2.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.merge")));
        panel1.add(panel2);
        this.checkMerge.addActionListener(new MergeActionListener(panel2));
        panel2.setVisible(false);
        return panel1;
    }

    protected void doProcess() throws Exception {
        UpdateInfo info = new UpdateInfo();
        info.setFiles(this.files);
        info.setRemoveEmpty(this.removeDir.isSelected());
        info.setRemoveSticky(this.removeSticky.isSelected());
        info.setCreateDir(this.createDir.isSelected());
        info.setCurrentOnly(this.currentOnly.isSelected());
        info.setUpdateLocal(this.updateLocal.isSelected());
        info.setRevision(this.revision.getText());
        info.setSelectDate(this.selectDate.isSelected());
        if (this.mergeRev.isSelected()) {
            info.setMergeRevision1(this.mergeRevision1.getText());
        } else if (this.mergeRevs.isSelected()) {
            info.setMergeRevision1(this.mergeRevision1.getText());
            info.setMergeRevision2(this.mergeRevision2.getText());
        }
        CVS cvs = this.window.getCVS();
        cvs.update(this.window.getRoot(), info);
        this.revision.saveHistory();
        this.mergeRevision1.saveHistory();
        this.mergeRevision2.saveHistory();
    }

    private class MergeActionListener
    implements ActionListener {
        private JPanel mergePanel;

        public MergeActionListener(JPanel mergePanel) {
            this.mergePanel = mergePanel;
        }

        public void actionPerformed(ActionEvent evt) {
            this.mergePanel.setVisible(UpdateDialog.this.checkMerge.isSelected());
            UpdateDialog.this.pack();
        }
    }

    private class RadioActionListener
    implements ActionListener {
        private RadioActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            if (obj == UpdateDialog.this.noMerge) {
                UpdateDialog.this.mergeRevision1.setEnabled(false);
                UpdateDialog.this.mergeRevision2.setEnabled(false);
            } else if (obj == UpdateDialog.this.mergeRev) {
                UpdateDialog.this.mergeRevision1.setEnabled(true);
                UpdateDialog.this.mergeRevision2.setEnabled(false);
            } else if (obj == UpdateDialog.this.mergeRevs) {
                UpdateDialog.this.mergeRevision1.setEnabled(true);
                UpdateDialog.this.mergeRevision2.setEnabled(true);
            }
        }
    }
}

