/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.graph;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JPanel;
import tk.javacvs.Util;
import tk.javacvs.swing.graph.Revision;

public class Graph
extends JPanel {
    private Revision[] revs;

    public Graph(String log) {
        this.revs = Graph.getRevisions(log);
        this.setLayout(new GraphLayoutManager());
        for (int i = 0; i < this.revs.length; ++i) {
            this.add(this.revs[i]);
        }
        this.doLayout();
    }

    public void addRevisionMouseListener(MouseListener listener) {
        for (int i = 0; i < this.revs.length; ++i) {
            this.revs[i].addMouseListener(listener);
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        for (int i = 0; i < this.revs.length; ++i) {
            int endY;
            int endX;
            int startY;
            int startX;
            Dimension fromDim;
            Point fromLoc;
            Dimension myDim;
            Point myLoc;
            int fromRev;
            Revision from = this.revs[i].getFrom();
            if (from == null) continue;
            int myRev = Util.split(this.revs[i].getRevision(), ".").length;
            if (myRev == (fromRev = Util.split(from.getRevision(), ".").length)) {
                myLoc = this.revs[i].getLocation();
                myDim = this.revs[i].getPreferredSize();
                fromLoc = from.getLocation();
                fromDim = from.getPreferredSize();
                startX = (int)(fromLoc.getX() + fromDim.getWidth() / 2.0);
                startY = (int)(fromLoc.getY() + fromDim.getHeight());
                endX = startX;
                endY = (int)myLoc.getY();
                g.drawLine(startX, startY, endX, endY);
                continue;
            }
            myLoc = this.revs[i].getLocation();
            myDim = this.revs[i].getPreferredSize();
            fromLoc = from.getLocation();
            fromDim = from.getPreferredSize();
            startX = (int)(myLoc.getX() + myDim.getWidth() / 2.0);
            startY = (int)(fromLoc.getY() + fromDim.getHeight() / 2.0);
            endX = startX;
            endY = (int)myLoc.getY();
            g.drawLine(startX, startY, endX, endY);
            startX = (int)(fromLoc.getX() + fromDim.getWidth());
            endY = startY;
            g.drawLine(startX, startY, endX, endY);
        }
    }

    private static Revision[] getRevisions(String log) {
        ArrayList list = Graph.parseLog(log);
        ArrayList<Revision> revs = new ArrayList<Revision>();
        ArrayList<HashMap> branch = new ArrayList<HashMap>();
        Revision from = null;
        for (int i = list.size() - 1; i >= 0; --i) {
            HashMap hash = (HashMap)list.get(i);
            String revision = (String)hash.get("Revision");
            String comment = (String)hash.get("Comment");
            String[] tags = (String[])hash.get("Tag");
            String user = (String)hash.get("User");
            String date = (String)hash.get("Date");
            int splitLength = Util.split(revision, ".").length;
            if (splitLength != 2) {
                int insertIndex = 0;
                for (int j = 0; j < branch.size(); ++j) {
                    ++insertIndex;
                    HashMap map = (HashMap)branch.get(j);
                    if (splitLength >= Util.split((String)map.get("Revision"), ".").length) continue;
                    --insertIndex;
                    break;
                }
                branch.add(insertIndex, hash);
                continue;
            }
            Revision rev = new Revision(revision, tags, user, date, comment, from);
            revs.add(rev);
            from = rev;
        }
        ArrayList<Revision> branchRevs = new ArrayList<Revision>();
        for (int i = 0; i < branch.size(); ++i) {
            HashMap hash = (HashMap)branch.get(i);
            String revision = (String)hash.get("Revision");
            String comment = (String)hash.get("Comment");
            String[] tags = (String[])hash.get("Tag");
            String user = (String)hash.get("User");
            String date = (String)hash.get("Date");
            from = null;
            String searchRev = revision;
            while (from == null) {
                Revision revObj;
                int j;
                if (searchRev.indexOf(".0.") != -1) {
                    searchRev = searchRev.substring(0, searchRev.lastIndexOf(".0."));
                } else if (searchRev.endsWith(".1")) {
                    searchRev = searchRev.substring(0, searchRev.lastIndexOf("."));
                    String bNum = searchRev.substring(searchRev.lastIndexOf("."), searchRev.length());
                    searchRev = searchRev.substring(0, searchRev.lastIndexOf("."));
                    searchRev = searchRev + ".0" + bNum;
                } else {
                    searchRev = searchRev.substring(0, searchRev.lastIndexOf("."));
                }
                int loop = 0;
                if (loop == 0) {
                    for (j = 0; j < branchRevs.size(); ++j) {
                        revObj = (Revision)branchRevs.get(j);
                        String branchRevision = revObj.getRevision();
                        if (!(branchRevision = branchRevision.substring(0, branchRevision.lastIndexOf("."))).equals(searchRev)) continue;
                        from = revObj;
                        break;
                    }
                }
                for (j = 0; j < revs.size(); ++j) {
                    revObj = (Revision)revs.get(j);
                    if (!revObj.getRevision().equals(searchRev)) continue;
                    from = revObj;
                    break;
                }
                ++loop;
            }
            Revision rev = new Revision(revision, tags, user, date, comment, from);
            revs.add(rev);
            branchRevs.add(rev);
        }
        return revs.toArray(new Revision[revs.size()]);
    }

    private static ArrayList parseLog(String log) {
        ArrayList list = new ArrayList();
        String[] lines = Util.split(log, "\n");
        String revision = null;
        String user = null;
        String date = null;
        HashMap<String, ArrayList> tagMap = new HashMap<String, ArrayList>();
        StringBuffer comment = new StringBuffer();
        int mode = 0;
        for (int i = 0; i < lines.length; ++i) {
            String[] dim;
            if (mode == 0 && lines[i].startsWith("\t")) {
                ArrayList tagList;
                dim = null;
                dim = lines[i].indexOf(":") != -1 ? Util.split(lines[i], ":") : Util.split(lines[i], " ");
                String rev = null;
                String tag = null;
                if (dim[0].indexOf(".") != -1) {
                    rev = Util.trim(dim[0]);
                    tag = Util.trim(dim[1]);
                } else {
                    rev = Util.trim(dim[1]);
                    tag = Util.trim(dim[0]);
                }
                if (tagMap.get(rev) == null) {
                    tagList = new ArrayList();
                    tagList.add(tag);
                    tagMap.put(rev, tagList);
                    continue;
                }
                tagList = (ArrayList)tagMap.get(rev);
                tagList.add(tag);
                continue;
            }
            if (mode == 0 && lines[i].startsWith("----------------------------")) {
                mode = 1;
                continue;
            }
            if (mode == 1) {
                revision = Util.trim(lines[i]);
                mode = 2;
                comment.append(lines[i] + "\n");
                if (revision.indexOf(":") != -1) {
                    revision = Util.trim(Util.split(revision, ":")[1]);
                    continue;
                }
                if (revision.indexOf(" ") == -1) continue;
                revision = Util.trim(Util.split(revision, " ")[1]);
                continue;
            }
            if (mode == 2) {
                mode = 3;
                if (lines[i].indexOf(";") != -1) {
                    dim = Util.split(lines[i], ";");
                    date = dim[0].substring(dim[0].indexOf(":") + 1, dim[0].length());
                    user = dim[1].substring(dim[1].indexOf(":") + 1, dim[1].length());
                }
                comment.append(lines[i] + "\n");
                continue;
            }
            if (mode != 3) continue;
            if (lines[i].equals("----------------------------") || lines[i].startsWith("===============================================")) {
                HashMap<String, Object> hash = new HashMap<String, Object>();
                hash.put("Revision", revision);
                hash.put("User", user);
                hash.put("Date", date);
                hash.put("Comment", comment.toString());
                if (tagMap.get(revision) == null) {
                    hash.put("Tag", new String[0]);
                } else {
                    ArrayList tags = (ArrayList)tagMap.get(revision);
                    hash.put("Tag", tags.toArray(new String[tags.size()]));
                }
                list.add(hash);
                comment = new StringBuffer();
                mode = 1;
                continue;
            }
            comment.append(lines[i] + "\n");
        }
        Iterator ite = tagMap.keySet().iterator();
        while (ite.hasNext()) {
            String key = (String)ite.next();
            if (key.indexOf(".0.") == -1) continue;
            HashMap<String, Object> hash = new HashMap<String, Object>();
            hash.put("Revision", key);
            hash.put("Comment", "");
            hash.put("User", "");
            hash.put("Date", "");
            ArrayList tags = (ArrayList)tagMap.get(key);
            hash.put("Tag", tags.toArray(new String[tags.size()]));
            list.add(hash);
        }
        return list;
    }

    private class GraphLayoutManager
    implements LayoutManager {
        private int width = 0;
        private int height = 0;

        private GraphLayoutManager() {
        }

        public void addLayoutComponent(String s, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container target) {
            return new Dimension(this.width, this.height);
        }

        public Dimension minimumLayoutSize(Container target) {
            return new Dimension(this.width, this.height);
        }

        public void layoutContainer(Container target) {
            int count = target.getComponentCount();
            int width = this.getMaxWidth(target);
            int branch = 0;
            for (int i = 0; i < count; ++i) {
                Revision rev = (Revision)target.getComponent(i);
                Dimension dim = rev.getPreferredSize();
                dim.setSize((double)width, dim.getHeight());
                rev.setSize(dim);
                if (rev.getFrom() == null) {
                    rev.setLocation(20, 20);
                } else {
                    Dimension size;
                    Point loc;
                    String[] fromNum;
                    Revision from = rev.getFrom();
                    String[] revNum = Util.split(rev.getRevision(), ".");
                    if (revNum.length == (fromNum = Util.split(from.getRevision(), ".")).length) {
                        loc = from.getLocation();
                        size = from.getSize();
                        rev.setLocation((int)loc.getX(), (int)(loc.getY() + size.getHeight() + 20.0));
                    } else {
                        loc = from.getLocation();
                        size = from.getSize();
                        rev.setLocation(20 + ++branch * (width + 20), (int)(loc.getY() + size.getHeight() + 20.0));
                    }
                }
                Point loc = rev.getLocation();
                int layoutWidth = (int)(loc.getX() + dim.getWidth() + 20.0);
                int layoutHeight = (int)(loc.getY() + dim.getHeight() + 20.0);
                if (this.width < layoutWidth) {
                    this.width = layoutWidth;
                }
                if (this.height >= layoutHeight) continue;
                this.height = layoutHeight;
            }
        }

        private int getMaxWidth(Container target) {
            int count = target.getComponentCount();
            int width = 0;
            for (int i = 0; i < count; ++i) {
                Component comp = target.getComponent(i);
                Dimension dim = comp.getPreferredSize();
                if (!((double)width < dim.getWidth())) continue;
                width = (int)dim.getWidth();
            }
            return width;
        }
    }
}

