/*
 * Decompiled with CFR 0.152.
 */
package tk.javacvs.swing.graph;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import tk.javacvs.Util;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.OutputView;
import tk.javacvs.swing.graph.Graph;
import tk.javacvs.swing.graph.Revision;

public class GraphWindow
extends JFrame {
    private MainWindow window;
    private OutputView output;
    private Graph graph;
    private File file;

    public GraphWindow(MainWindow window, Graph graph, File file) {
        this.window = window;
        this.graph = graph;
        this.file = file;
        this.setTitle(Util.getProperty("menu.cvs.graph") + " - " + file.getName());
        this.output = new OutputView(window);
        JSplitPane split = new JSplitPane(0);
        split.add(new JScrollPane(graph));
        split.add(new JScrollPane(this.output));
        split.setDividerLocation(280);
        graph.addRevisionMouseListener(new RevisionMouseListener());
        this.getContentPane().add(split);
        this.setSize(500, 450);
        int x = (window.getWidth() - this.getWidth()) / 2 + window.getX();
        int y = (window.getHeight() - this.getHeight()) / 2 + window.getY();
        this.setLocation(x, y);
    }

    private class RevisionMouseListener
    extends MouseAdapter {
        private RevisionMouseListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            GraphWindow.this.output.setText("");
            Revision rev = (Revision)evt.getSource();
            String log = rev.getLog();
            if (log.equals("")) {
                return;
            }
            String[] lines = Util.split(log, "\n");
            for (int i = 0; i < lines.length; ++i) {
                GraphWindow.this.output.insertString(lines[i] + "\n");
            }
        }
    }
}

