package tk.javacvs;

import java.io.*;
import java.util.*;

/**
 * CVSR}hJavaC^[tF[XB
 */
public class CVS {

	private String  cvsCommand;
	private String  charset     = "EUC-JP";
	private File    messageFile = new File("message.txt");
	private boolean quietMode    = true;
	private OutputStream out;
	private ArrayList listeners = new ArrayList();
	
	public static final int COMMAND_LOG      = 0;
	public static final int COMMAND_STATUS   = 1;
	public static final int COMMAND_COMMIT   = 2;
	public static final int COMMAND_UPDATE   = 3;
	public static final int COMMAND_TAG      = 4;
	public static final int COMMAND_REMOVE   = 5;
	public static final int COMMAND_DIFF     = 6;
	public static final int COMMAND_ADD      = 7;
	public static final int COMMAND_CHECKOUT = 8;
	public static final int COMMAND_IMPORT   = 9;
	
	/**
	 * RXgN^
	 *
	 * @param cvsCommand cvsR}h
	 * @param cvsRoot    CVSROOT
	 * @param out        cvsR}h̎sʂo͂Xg[
	 */
	public CVS(String cvsCommand,OutputStream out){
		super();
		this.cvsCommand = cvsCommand;
		this.out        = out;
	}
	
	/**
	 * CVSListenerǉ܂B
	 *
	 * @param listener CVSListener
	 */
	public void addCVSListener(CVSListener listener){
		if(listener!=null){
			listeners.add(listener);
		} else {
			throw new NullPointerException();
		}
	}
	
	/**
	 * CVSR}hȃbZ[W[hi-qIvVjŎs邩ǂݒ肵܂B
	 * ftHgłtruełB
	 *
	 * @param quietMode ȃbZ[W[h̏ꍇtrueAłȂꍇfalse
	 */
	public void setQuietMode(boolean quietMode){
		this.quietMode = quietMode;
	}
	
	/**
	 * CVSR}hȃbZ[W[hi-qIvVjŎs邩ǂ擾܂B
	 *
	 * @return ȃbZ[W[h̏ꍇtrueAłȂꍇfalse
	 */
	public boolean getQuietMode(){
		return this.quietMode;
	}
	
	/**
	 * CVS̎st@Cw肵܂B
	 * 
	 * @param cvsCommand CVSR}h
	 */
	public void setCVSCommand(String cvsCommand){
		if(cvsCommand != null){
			this.cvsCommand = cvsCommand;
		}
	}
	
	/**
	 * CVS̎st@C擾܂B
	 * 
	 * @return CVSR}h
	 */
	public String getCVSCommand(){
		return this.cvsCommand;
	}
	
	/**
	 * O̕R[hݒ肵܂BftHgłEUC-JPłB
	 * 
	 * @param charset R[h
	 */
	public void setCharset(String charset){
		this.charset = charset;
	}
	
	/**
	 * O̕R[h擾܂BftHgłEUC-JPłB
	 *
	 * @return R[h
	 */
	public String getCharset(){
		return this.charset;
	}
	////////////////////////////////////////////////////////////////////////////
	// CVSR}hQ
	////////////////////////////////////////////////////////////////////////////
	/**
	 * cvs import
	 *
	 * @param cvsRoot     CVSROOT
	 * @param module      W[
	 * @param importDir   C|[gfBNg
	 * @param venderTag   x_[^O
	 * @param releaseTag  [X^O
	 */
	public void cvsimport(String cvsRoot,String module,File importDir,
					      String venderTag,String releaseTag) throws IOException {
		// ʕ쐬
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs import ");
		sb.append(this.cvsCommand);
		sb.append(" -d ");
		sb.append(cvsRoot);
		if(this.getQuietMode()){
			sb.append(" -q");
		}
		sb.append(" import -m \"\" ");
		sb.append(module);
		sb.append(" ");
		sb.append(venderTag);
		sb.append(" ");
		sb.append(releaseTag);
		
		msg.append(module);
		msg.append(" ");
		msg.append(venderTag);
		msg.append(" ");
		msg.append(releaseTag);
		
		executeCommand(sb.toString(),importDir,COMMAND_IMPORT,msg.toString());
	}
	
	/**
	 * t@C烂W[pX擾܂B
	 *
	 * @param file t@C
	 * @return W[pX
	 */
	private String getModulePath(File file){
		String path = file.getName();
		boolean flag = true;
		while(flag){
			File parent = file.getParentFile();
			File cvsDir = new File(parent,"CVS");
			if(cvsDir.exists() && cvsDir.isDirectory()){
				path = parent.getName() + "/" + path;
				file = parent;
			} else {
				flag = false;
			}
		}
		return path;
	}
	
	/**
	 * OvOgpdiff\ꍇȂǁA
	 * |Wg̓erWior tjw肵
	 * e|fBNgɃ`FbNAEg邽߂̃\bhłB
	 *
	 * CVS상\bhƈقȂAʂ̓Xg[ɂ͏o͂ꂸA
	 * R}h̎s܂ŃubN܂B
	 * ܂ACVSListeneřĂяos܂B
	 *
	 * @param file     `FbNAEgt@CorfBNg
	 * @param localDir `FbNAEgfBNg
	 * @param rev      rW or t
	 * @param date     tǂ
	 * @return `FbNAEgt@C
	 */
	public File checkout(File file,File localDir,String rev,boolean date) throws IOException {
		
		String modulePath = getModulePath(file);
		
		StringBuffer sb  = new StringBuffer();
		sb.append(this.cvsCommand);
		sb.append(" -d ");
		sb.append(getCVSRoot(file));
		if(this.getQuietMode()){
			sb.append(" -q");
		}
		sb.append(" checkout ");
		if(rev!=null && !rev.equals("")){
			if(date){
				sb.append("-D ");
				sb.append(rev);
				sb.append(" ");
			} else {
				sb.append("-r ");
				sb.append(rev);
				sb.append(" ");
			}
		}
		sb.append(modulePath);
		
		CommandExecuter executer = new CommandExecuter();
		executer.setDirectory(localDir);
		executer.execute(sb.toString(),true);
		
		return new File(localDir,modulePath);
	}
	
	/**
	 * cvs checkout
	 *
	 * @param cvsRoot  CVSROOT
	 * @param module   W[
	 * @param localDir `FbNAEgfBNg
	 */
	public void checkout(String cvsRoot,String module,File localDir) throws IOException {
		// ʕ쐬
		StringBuffer sb  = new StringBuffer();
		sb.append(this.cvsCommand);
		sb.append(" -d ");
		sb.append(cvsRoot);
		if(this.getQuietMode()){
			sb.append(" -q");
		}
		sb.append(" checkout ");
		sb.append(module);
		
		executeCommand(sb.toString(),localDir,COMMAND_CHECKOUT,"cvs checkout "+module);
	}
	
	/**
	 * cvs remove
	 * 
	 * @param root        [gfBNg
	 * @param files       t@CQ
	 * @param currentOnly JgfBNĝ݂ΏۂƂ邩ǂ
	 * @param removeLocal [Jt@C폜邩ǂ 
	 */
	public void remove(File root,File[] files,boolean currentOnly,
	                   boolean removeLocal) throws IOException {
		
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs remove");
		sb.append(createCommonCommandString(files));
		sb.append(" remove");
		if(currentOnly){ sb.append(" -l"); msg.append(" -l"); }
		if(removeLocal){ sb.append(" -f"); msg.append(" -f"); }
		sb.append(createFilesString(root,files));
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_REMOVE,msg.toString());
	}
	
	/**
	 * cvs tag
	 * 
	 * @param root [gfBNg
	 * @param info TagInfo
	 */
	public void tag(File root,TagInfo info) throws IOException {
		
		File[] files = info.getFiles();
		
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		// ^Ow肳ĂȂꍇȂɂȂ
		if(info.getTagName()==null || info.getTagName().equals("")){
			return;
		}
		
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs tag");
		sb.append(createCommonCommandString(files));
		sb.append(" tag");
		if(info.getCurrentOnly()){ sb.append(" -l"); msg.append(" -l"); }
		if(info.getConfirm())    { sb.append(" -c"); msg.append(" -c"); }
		if(info.getOverride())   { sb.append(" -F"); msg.append(" -F"); }
		if(info.getRemove())     { sb.append(" -d"); msg.append(" -d"); }
		if(info.getBranch())     { sb.append(" -b"); msg.append(" -b"); }
		
		sb.append(" ");
		sb.append(info.getTagName());
		sb.append(createFilesString(root,files));
		
		msg.append(" ");
		msg.append(info.getTagName());
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_TAG,msg.toString());
	}
	
	/**
	 * cvs add
	 * 
	 * @param root  [gfBNg
	 * @param files Ώۂ̃t@CQ
	 * @param isBinary oCit@CƂĒǉ邩ǂ
	 */
	public void add(File root,File[] files,boolean isBinary) throws IOException {
		
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs add");
		sb.append(createCommonCommandString(files));
		sb.append(" add");
		if(isBinary){
			sb.append(" -kb");
			msg.append(" -kb");
		}
		sb.append(createFilesString(root,files));
		msg.append(createFilesString(root,files));

		executeCommand(sb.toString(),root,COMMAND_ADD,msg.toString());
	}
	
	/**
	 * cvs diff
	 *
	 * @param root [gfBNg
	 * @param info DiffInfo
	 */
	public void diff(File root,DiffInfo info) throws IOException {
		
		File[] files = info.getFiles();
		
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs diff");
		sb.append(createCommonCommandString(files));
		sb.append(" diff");
		if(info.getCurrentOnly())   { sb.append(" -l"); msg.append(" -l"); }
		if(info.getSkipSpace())     { sb.append(" -w"); msg.append(" -w"); }
		if(info.getSkipLetterCase()){ sb.append(" -i"); msg.append(" -i"); }
		
		if(!info.getRevision1().equals("")){
			if(info.getSelectDate1()){
				sb.append(" -D " + info.getRevision1());
				msg.append(" -D " + info.getRevision1());
			} else {
				sb.append(" -r " + info.getRevision1());
				msg.append(" -r " + info.getRevision1());
			}
		}
		
		if(!info.getRevision2().equals("")){
			if(info.getSelectDate1()){
				sb.append(" -D " + info.getRevision2());
				msg.append(" -D " + info.getRevision2());
			} else {
				sb.append(" -r " + info.getRevision2());
				msg.append(" -r " + info.getRevision2());
			}
		}
		
		sb.append(createFilesString(root,files));
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_DIFF,msg.toString());
	}
	
	/**
	 * cvs status
	 *
	 * @param root  [gfBNg
	 * @param files Xe[^X擾t@CQ
	 */
	public void status(File root,File[] files) throws IOException {
	
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs statuc");
		sb.append(createCommonCommandString(files));
		sb.append(" status");
		sb.append(createFilesString(root,files));
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_STATUS,msg.toString());
	}
	
	/**
	 * cvs log
	 *
	 * @param root [gfBNg
	 * @param info LogInfo
	 */
	public void log(File root,LogInfo info) throws IOException {
		
		File[] files = info.getFiles();
		
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs log");
		sb.append(createCommonCommandString(files));
		sb.append("log");
		
		if(info.getOnlyBranch()) { sb.append(" -b"); msg.append(" -b"); }
		if(info.getCurrentOnly()){ sb.append(" -l"); msg.append(" -l"); }
		if(info.getNoTag())      { sb.append(" -N"); msg.append(" -N"); }
		if(info.getNoLog())      { sb.append(" -h"); msg.append(" -h"); }
		if(info.getOnlyRCS())    { sb.append(" -R"); msg.append(" -R"); }
		
		sb.append(createFilesString(root,files));
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_LOG,msg.toString());
	}
	
	
	/**
	 * cvs update
	 *
	 * @param info UpdateInfo
	 */
	public void update(File root,UpdateInfo info) throws IOException {
		
		File[] files = info.getFiles();
		
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs update");
		sb.append(createCommonCommandString(files));
		sb.append("update");
		
		if(info.getCurrentOnly()) { sb.append(" -l"); msg.append("-l"); }
		if(info.getCreateDir())   { sb.append(" -d"); msg.append("-d"); }
		if(info.getRemoveEmpty()) { sb.append(" -P"); msg.append("-P"); }
		if(info.getRemoveSticky()){ sb.append(" -A"); msg.append("-A"); }
		if(info.getUpdateLocal()) { sb.append(" -C"); msg.append("-C"); }
		
		if(info.getRevision()!=null && !info.getRevision().equals("")){
			if(info.getSelectDate()){
				sb.append(" -D " + info.getRevision());
				msg.append(" -D " + info.getRevision());
			} else {
				sb.append(" -r " + info.getRevision());
				msg.append(" -r " + info.getRevision());
			}
		}
		if(info.getMergeRevision1()!=null && !info.getMergeRevision1().equals("")){
			sb.append(" -j " + info.getMergeRevision1());
			msg.append(" -j " + info.getMergeRevision1());
		}
		if(info.getMergeRevision2()!=null && !info.getMergeRevision2().equals("")){
			sb.append(" -j " + info.getMergeRevision2());
			msg.append(" -j " + info.getMergeRevision2());
		}
		
		sb.append(createFilesString(root,files));
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_UPDATE,msg.toString());
	}
	
	/**
	 * cvs commit
	 *
	 * @param root    [gfBNg
	 * @param files   committ@CQ
	 * @param message bZ[W
	 * @param currentOnly Jgt@Ĉ݂ΏۂƂ
	 */
	public void commit(File root,File[] files,String message,boolean currentOnly) throws IOException {
		// t@CQw肳ĂȂꍇ͂ȂɂȂ
		if(files==null || files.length==0){
			return;
		}
		
		// bZ[Wt@C쐬
		this.makeMessageFile(message);
		
		// R}hgݗ
		StringBuffer sb  = new StringBuffer();
		StringBuffer msg = new StringBuffer("cvs commit");
		sb.append(createCommonCommandString(files));
		sb.append("commit -F ");
		sb.append(this.messageFile.getAbsolutePath());
		
		if(currentOnly){ sb.append(" -l"); }
		
		sb.append(createFilesString(root,files));
		msg.append(createMessageFilesString(files));
		
		executeCommand(sb.toString(),root,COMMAND_COMMIT,msg.toString());
	}
	
	////////////////////////////////////////////////////////////////////////////
	// private\bhQ
	////////////////////////////////////////////////////////////////////////////
	/**
	 * t@CQԂ܂B
	 *
	 * @param root  [gfBNg
	 * @param files t@CQ
	 * @return t@C𔼊pXy[XŌ
	 */
	private String createFilesString(File root,File[] files){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<files.length;i++){
			String fullPath = files[i].getAbsolutePath();
			String rootPath = root.getAbsolutePath();
			sb.append(" ");
			if(rootPath.equals(fullPath)){
				sb.append(".");
			} else {
				sb.append(fullPath.substring(rootPath.length()+1,fullPath.length()));
			}
		}
		return sb.toString();
	}
	
	/**
	 * AEgvbgr[ɕ\邽߂̕𐶐܂B
	 */
	private String createMessageFilesString(File[] files){
		StringBuffer sb = new StringBuffer();
		for(int i=0;i<files.length;i++){
			sb.append(" ");
			sb.append(files[i].getName());
		}
		return sb.toString();
	}	
	/**
	 * R}h̋ʕ쐬܂B
	 *
	 * @param files Ώۂ̃t@CQ
	 * @return R}h̋ʕ
	 */
	private String createCommonCommandString(File[] files) throws IOException {
		// CVSROOT擾
		String cvsRoot = getCVSRoot(files[0]);
		
		// ʕ쐬
		StringBuffer sb = new StringBuffer();
		sb.append(this.cvsCommand);
		sb.append(" -d ");
		sb.append(cvsRoot);
		
		if(this.getQuietMode()){
			sb.append(" -q");
		}
		
		sb.append(" ");
		
		return sb.toString();
	}
	
	
	/**
	 * R}hs܂B
	 *
	 * @param command sR}h
	 * @param execDir sfBNg
	 * @param code    R}h̃R[h
	 * @param message \郁bZ[W
	 */
	private void executeCommand(String command,File execDir,
	                            int code,String message) throws IOException {
		ExecuteCommandThread thread = new ExecuteCommandThread(command,execDir,code,message);
		thread.start();
	}
	
	/**
	 * R}hICVSListenerĂяo܂B
	 */
	private synchronized void callListenerForEndCommand(int command){
		javax.swing.SwingUtilities.invokeLater(new EndListenerThread(command));
	}
	
	////////////////////////////////////////////////////////////////////////////
	// XiĂяoXbh
	private class EndListenerThread extends Thread {
		private int command;
		public EndListenerThread(int command){
			this.command = command;
		}
		public void run(){
			for(int i=0;i<listeners.size();i++){
				CVSListener listener = (CVSListener)listeners.get(i);
				listener.endCommand(command);
			}
		}
	}
	
	/**
	 * R}hJnCVSListenerĂяo܂B
	 */
	private synchronized void callListenerForStartCommand(int command){
		javax.swing.SwingUtilities.invokeLater(new StartListenerThread(command));
	}
	
	////////////////////////////////////////////////////////////////////////////
	// XiĂяoXbh
	private class StartListenerThread extends Thread {
		private int command;
		public StartListenerThread(int command){
			this.command = command;
		}
		public void run(){
			for(int i=0;i<listeners.size();i++){
				CVSListener listener = (CVSListener)listeners.get(i);
				listener.startCommand(command);
			}
		}
	}
	
	/**
	 * G[CVSListenerĂяo܂B
	 *
	 * @param ex O
	 */
	private synchronized void callListenerForError(Exception ex){
		javax.swing.SwingUtilities.invokeLater(new ErrorListenerThread(ex));
	}
	
	////////////////////////////////////////////////////////////////////////////
	// XiĂяoXbh
	private class ErrorListenerThread extends Thread {
		private Exception ex;
		public ErrorListenerThread(Exception ex){
			this.ex = ex;
		}
		public void run(){
			for(int i=0;i<listeners.size();i++){
				CVSListener listener = (CVSListener)listeners.get(i);
				listener.error(ex);
			}
		}
	}
	
	/**
	 * CVS/RootCVSROOT擾܂B
	 *
	 * @param file Ώۂ̃t@C
	 * @return CVSROOT
	 */
	private String getCVSRoot(File file) throws IOException {
		
		// CVS/Roott@CCVSROOT擾
		File cvs  = new File(file,"CVS");
		File root = new File(cvs,"Root");
		
		// ݂ȂefBNggp
		if(!root.exists()){
			file = file.getParentFile();
			cvs  = new File(file,"CVS");
			root = new File(cvs,"Root");
		}
		
		String cvsRoot = Util.loadFile(root);
		
		// sR[h폜
		cvsRoot = Util.replace(cvsRoot,"\r","");
		cvsRoot = Util.replace(cvsRoot,"\n","");
		
		return cvsRoot;
	}
	
	/**
	 * o̓Xg[ɃbZ[Wo͂܂B
	 * ̃\bh͕̃XbhĂяo邽߁AĂ܂B
	 *
	 * @param message bZ[W
	 */
	private synchronized void printMessage(String message){
		try {
			this.out.write(message.getBytes());
		} catch(IOException ex){
		}
	}
	
	/**
	 * w肳ꂽR[hŃbZ[Wt@C쐬܂B
	 * 
	 * @param message bZ[W
	 */
	private void makeMessageFile(String message) throws IOException {
		OutputStreamWriter writer = new OutputStreamWriter(new FileOutputStream(this.messageFile),this.charset);
		writer.write(message,0,message.length());
		writer.close();
	}
	
	////////////////////////////////////////////////////////////////////////////
	// R}hsXbh
	////////////////////////////////////////////////////////////////////////////
	private class ExecuteCommandThread extends Thread {
		
		private String command;
		private String message;
		private File   execDir;
		private int    code;
		
		public ExecuteCommandThread(String command,File execDir,int code,String message){
			this.command = command;
			this.message = message;
			this.execDir = execDir;
			this.code    = code;
		}
		
		public void run(){
			try {
				callListenerForStartCommand(this.code);
				printMessage(message + "\n");
				
				Runtime runtime = Runtime.getRuntime();
				Process process = runtime.exec(command,
											   tk.javacvs.swing.Main.getenv(),
											   new File(execDir.getAbsolutePath()));

				OutputThread thread1 = new OutputThread(process.getInputStream());
				OutputThread thread2 = new OutputThread(process.getErrorStream());
				thread1.start();
				thread2.start();
				
				// vZX̏I҂
				process.waitFor();
				// _CNgĂXbhI܂ő҂
				while(!thread1.isEnd() || !thread2.isEnd()){
					sleep(100);
				}
				
				int result = process.exitValue();
				String exitMessage = Util.getProperty("message.cvs.exit");
				exitMessage = Util.replace(exitMessage,"${code}",String.valueOf(result));
				printMessage(exitMessage + "\n\n");
				
				callListenerForEndCommand(code);
				
			} catch(Exception ex){
				callListenerForError(ex);
			}
		}
	}

	////////////////////////////////////////////////////////////////////////////
	//InputStreamo̓Xg[Ƀ_CNgXbh
	////////////////////////////////////////////////////////////////////////////
	private class OutputThread extends Thread {
		
		private BufferedReader in;
		private boolean endFlag = false;
		
		public OutputThread(InputStream in){
			try {
				this.in = new BufferedReader(new InputStreamReader(in,"8859_1"));
			} catch(Exception ex){
				this.in = new BufferedReader(new InputStreamReader(in));
			}
		}
		
		public boolean isEnd(){
			return this.endFlag;
		}
		
		public void run(){
			try {
				String line = null;
				while((line=in.readLine())!=null){
					line = new String(line.getBytes("8859_1"),"JISAutoDetect");
					printMessage(line + "\n");
				}
				
			} catch(Exception ex){
				
			}
			this.endFlag = true;
		}
	}
}
