package tk.javacvs;

import java.io.*;

/**
 * OR}h񓯊Ɏs邽߂̃NXłB
 *
 * @author Naoki Takezoe
 * @version 1.0
 * @since   1.0
 */
public class CommandExecuter {
	
	private OutputStream stdout = null;
	private OutputStream stderr = null;
	private OutputStream stdin  = null;
	private boolean  isEnd       = true;
	private int      exitStatus  = -1;
	private String   lastCommand = null;
	private File     dir         = null;
	private String[] env         = null;
	
	/**
	 * RXgN^B
	 */
	public CommandExecuter(){
		
	}
	
	/**
	 * Wo͂OutputStreamZbg܂B
	 *
	 * @param out Wo͂OutputStream
	 */
	public void setStdOutputStream(OutputStream out){
		this.stdout = out;
	}
	
	/**
	 * WG[o͂OutputStreamZbg܂B
	 *
	 * @param out WG[o͂OutputStream
	 */
	public void setErrOutputStream(OutputStream out){
		this.stderr = out;
	}
	
	/**
	 * R}hsfBNgݒ肵܂B
	 * ftHgł̓JgfBNgɂȂ܂B
	 *
	 * @param dir fBNg
	 */
	public void setDirectory(File dir){
		this.dir = dir;
	}
	
	/**
	 * ϐݒ肵܂B
	 *
	 * @param env ϐ
	 */
	public void setEnvironment(String[] env){
		this.env = env;
	}
	
	/**
	 * R}h񓯊Ŏs܂BR}h̏I҂ɐ䂪߂܂A
	 * P̃R}hI܂ł͎̃R}hs邱Ƃ͂ł܂
	 * is悤ƂƗO𓊂܂jB
	 *
	 * @param command sR}h
	 * @param block   ubN邩ǂ
	 */
	public synchronized void execute(String command,boolean block) throws IOException {
		if(!isEnd){
			throw new IOException("R}h͎słB("+lastCommand+")");
		}
		isEnd = false;
		lastCommand = command;
		
		CommandExecuteThread thread = new CommandExecuteThread(command);
		if(block){
			thread.run();
		} else {
			thread.start();
		}
	}
	
	/**
	 * s̃R}hivZXjɑ΂ē͂^܂B
	 *
	 * @param input ͂镶
	 */
	public synchronized void input(String input) throws IOException {
		if(isEnd){
			throw new IOException("R}h͎sł͂܂B");
		}
		stdin.write(input.getBytes());
	}
	
	/**
	 * R}hIĂ邩ǂ𔻒肵܂B
	 *
	 * @return R}hsłȂtrueAsłfalse
	 */
	public boolean isEnd(){
		return isEnd;
	}
	
	/**
	 * OsR}h̏IXe[^X擾܂B
	 *
	 * @return OsR}h̏IXe[^X
	 */
	public int getExitStatus(){
		return exitStatus;
	}
	
	/**
	 * ŌɎsR}h擾܂B
	 *
	 * @return ŌɎsR}h
	 */
	public String getLastCommand(){
		return this.lastCommand;
	}
	
	/**
	 * R}hsXbhB
	 */
	private class CommandExecuteThread extends Thread {
		
		private String command;
		
		public CommandExecuteThread(String command){
			this.command = command;
		}
		
		public void run(){
			try {
				// R}hs
				Runtime runtime = Runtime.getRuntime();
				Process process = runtime.exec(command,env,dir);
				stdin = process.getOutputStream();
				InputStream in  = process.getInputStream();
				InputStream err = process.getErrorStream();
				// o͂̊ĎXbhJn
				new OutputStreamThread(in ,stdout).start();
				new OutputStreamThread(err,stderr).start();
				// I܂ő҂
				process.waitFor();
				exitStatus = process.exitValue();
			} catch(Exception ex){
				// TODO OóH
			} finally {
				isEnd = true;
			}
		}
	}
	
	/**
	 * R}h̏o͂ĎOutputStreamɏoXbhB
	 */
	private class OutputStreamThread extends Thread {
		
		private InputStream  in;
		private OutputStream out;
		
		public OutputStreamThread(InputStream in,OutputStream out){
			this.in  = in;
			this.out = out;
		}
		
		public void run(){
			try {
				byte[] buf = new byte[1024 * 8];
				int length = 0;
				while((length=in.read(buf))!=-1){
					if(out!=null){
						out.write(buf,0,length);
					}
				}
				in.close();
			} catch(IOException ex){
				// TODO OóH
			}
		}
	}
}
