package tk.javacvs;

import java.util.*;
import java.text.*;
import java.io.*;

/**
 * CVS/Entriest@C̏ǂݍ݁AێNXłB
 */
public class EntryInfo {
	
	private File file;
	
	private Object[] result = new Object[0];
	private SimpleDateFormat df = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy",Locale.ENGLISH);
	
	
	/** t@CŃ\[g */
	public static final int SORT_BY_NAME  = 0;
	//public static final int SORT_BY_STATE = 1;
	//public static final int SORT_BY_DATE  = 2;
	
	/** t@CŃ\[g邽߂Comparator */
	private FileNameComparator sortNameComparator = new FileNameComparator();
	
	/**
	 * RXgN^
	 */
	public EntryInfo(File dir){
		super();
		this.file = dir;

		df.setTimeZone(TimeZone.getTimeZone("GMT"));
		File[]    files = dir.listFiles();
		CVSInfo[] infos = new CVSInfo[0];
		
		try { // G[CVSGgȂƂď
			infos = getCVSInfo();
		} catch(Exception ex){
			//ex.printStackTrace();
		}
		
		ArrayList list = new ArrayList();
		
		for(int i=0;i<infos.length;i++){
			list.add(infos[i]);
		}
		
		// CVSǗÕt@Cǉ
		for(int i=0;i<files.length;i++){
			// CVSfBNg͑ΏۊO
			if(files[i].isDirectory() && files[i].getName().equals("CVS")){
				continue;
			}
			
			boolean flag = false;
			for(int j=0;j<infos.length;j++){
				if(files[i].equals(infos[j].file)){
					flag = true;
					break;
				}
			}
			if(!flag){
				// ƃRs[̃[gfBNg̏ꍇ
				if(files[i].isDirectory() && new File(files[i],"CVS").exists()){
					list.add(new CVSInfo(files[i],null,null,null,null,false,false,files[i].isDirectory(),false));
				// ȊȌꍇ
				} else {
					list.add(new CVSInfo(files[i],null,null,null,null,true,false,files[i].isDirectory(),false));
				}
			}
		}
		
		this.result = list.toArray();
	}
	
	
	/**
	 * \[g܂B
	 *
	 * @param sort \[g@
	 * @param asc  ̏ꍇtrueA~̏ꍇfalse
	 */
	public void sort(int sort,boolean asc){
		if(sort == SORT_BY_NAME){
			sortNameComparator.setAsc(asc);
			Arrays.sort(this.result,sortNameComparator);
		}
	}
	
	/**
	 * t@C擾܂B
	 *
	 * @return t@C
	 */
	public int count(){
		return this.result.length;
	}
	
	/**
	 * FileIuWFNg擾܂B
	 *
	 * @param i CfbNX
	 * @return File
	 */
	public File getFile(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		return info.file;
	}
	
	/**
	 * Sticky^O擾܂B
	 *
	 * @param i CfbNX
	 * @return Sticky^O
	 */
	public String getTag(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		if(info.tag==null){
			return "";
		} else {
			return info.tag.substring(1);
		}
	}
	
	/**
	 * rW擾܂B
	 *
	 * @param i CfbNX
	 * @return rW
	 */
	public String getRevision(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		if(info.revision==null){
			return "";
		} else {
			return info.revision;
		}
	}
	
	/**
	 * IvV擾܂B
	 *
	 * @param i CfbNX
	 * @return IvV
	 */
	public String getOption(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		if(info.revision==null){
			return "";
		} else {
			return info.option;
		}
	}
	
	/**
	 * CVSǗ̃t@Cǂ擾܂B
	 *
	 * @param i CfbNX
	 * @return CVSǗ̃t@C̏ꍇtrueAłȂꍇfalse
	 */
	public boolean isCVSFile(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		return !info.noCVS;
	}
	
	/**
	 * t@CXVĂ邩ǂ擾܂B
	 *
	 * @param i CfbNX
	 * @return XVĂꍇtrueAĂȂꍇfalse
	 */
	public boolean isModified(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		return info.modified;
	}
	
	/**
	 * t@CfBNgǂ擾܂B
	 * CVSǗŁAƃRs[ɑ݂ȂfBNg̏ꍇA
	 * File#isDirectorył̓fBNgǂ𔻕ʂłȂ߁A
	 * {\bhɂĔ肷Kv܂B
	 *
	 * @param i CfbNX
	 * @return fBNg̏ꍇtrueAłȂꍇfalse
	 */
	public boolean isDirectory(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		return info.isDir;
	}
	
	/**
	 * t@C}[WĂ邩ǂ擾܂B
	 *
	 * @param i CfbNX
	 * @return }[WĂꍇtrueAłȂꍇfalse
	 */
	public boolean isMerged(int i){
		CVSInfo info = (CVSInfo)this.result[i];
		return info.merged;
	}
	
	/**
	 * CVS/EntriesɋLqĂ擾܂B
	 */
	private CVSInfo[] getCVSInfo() throws IOException,ParseException {
		
		File cvs   = new File(this.file,"CVS");
		File entry = new File(cvs,"Entries");
		
		String text = Util.loadFile(entry);
		String[] lines = Util.split(text,"\n");
		
		ArrayList list = new ArrayList();
		
		for(int i=0;i<lines.length;i++){
			try {
				String[] items = Util.split(lines[i],"/");
				File    file     = new File(this.file,items[1]);
				String  tag      = null;
				String  revision = null;
				Date    date     = null;
				boolean modified = false;
				boolean isDir    = false;
				boolean merged   = false;
				String  option   = items[4];
				
				if(items[0].equals("D")){
					isDir = true;
				}
				
				if(!items[2].equals("")){
					revision = items[2];
				}
				
				// ǉĂ
				if(revision!=null && revision.equals("0")){
					modified = true;
				// 폜Ă
				} else if(revision!=null && revision.startsWith("-")){
					modified = true;
				// ȊO
				} else {
					// }[Wꂽt@C
					if(items[3].equals("Result of merge")){
						modified = true;
						merged   = true;
					// ȊOiʂ̃t@Cj
					} else if(!items[3].equals("")){
						date = df.parse(items[3]);
					}
					if(items.length>=6 && !items[5].equals("")){
						tag = items[5];
					}
					if(file.isFile() && file.exists() && date!=null){
						Date fileMod = new Date(file.lastModified());
						if(!fileMod.toString().equals(date.toString())){
							modified = true;
						}
					}
				}
				
				list.add(new CVSInfo(file,date,tag,revision,option,false,modified,isDir,merged));
				
			} catch(Exception ex){
				//ex.printStackTrace();
			}
		}
		
		return (CVSInfo[])list.toArray(new CVSInfo[list.size()]);
	}
	
	////////////////////////////////////////////////////////////////////////////
	// CVSt@CorfBNg̏킷NX
	////////////////////////////////////////////////////////////////////////////
	private class CVSInfo {
		
		private File    file;
		private Date    date;
		private String  revision;
		private String  tag;
		private String  option;
		private boolean noCVS;
		private boolean modified;
		private boolean isDir;
		private boolean merged;
		
		public CVSInfo(File file,Date date,String tag,String revision,String option,
		               boolean noCVS,boolean modified,boolean isDir,boolean merged){
		    super();
			this.file     = file;
			this.date     = date;
			this.tag      = tag;
			this.revision = revision;
			this.option   = option;
			this.noCVS    = noCVS;
			this.modified = modified;
			this.isDir    = isDir;
			this.merged   = merged;
		}
	}
	
	////////////////////////////////////////////////////////////////////////////
	// t@CŃ\[g邽߂Comparator
	////////////////////////////////////////////////////////////////////////////
	public class FileNameComparator implements Comparator {
		
		private int asc = 1;
		
		public void setAsc(boolean asc){
			if(asc==true){
				this.asc = 1;
			} else {
				this.asc = -1;
			}
		}
		
		public int compare(Object obj1,Object obj2){
			
			CVSInfo info1 = (CVSInfo)obj1;
			CVSInfo info2 = (CVSInfo)obj2;
			
			File file1 = info1.file;
			File file2 = info2.file;
			
			if(info1.isDir && !info2.isDir){
				return -1 * this.asc;
			} else if(!info1.isDir && info2.isDir){
				return 1 * this.asc;
			}
			
			String str1 = file1.getName();
			String str2 = file2.getName();
			
			return str1.compareTo(str2) * this.asc;
		}
	}
}
