package tk.javacvs;

import java.util.*;
import java.io.*;
import java.awt.*;
import java.net.*;
import java.text.*;
import javax.swing.*;

/**
 * [eBeB\bh񋟂NXB
 */
public class Util {

	///////////////////////////////////////////////////////////////////////
	// ֌W
	///////////////////////////////////////////////////////////////////////
	/**
	 * ChJ[h܂ޕ̃}b`Os܂B
	 * ɂ͈ȉ̃ChJ[h܂߂邱Ƃł܂B
	 * <ul>
	 *   <li>* - Cӂ̕Ƀ}b`</li>
	 *   <li>? - Cӂ̂PɃ}b`</li>
	 * </ul>
	 *
	 * @param text   
	 * @param search 
	 * @return }b`ꍇtrueAȂꍇfalse
	 */
	public static boolean match(String text,String search){
		int index1 = 0;
		int index2 = 0;
		while(index1 < text.length() && index2 < search.length()){
			char c2 = search.charAt(index2);
			index2++;
			if(c2=='*'){
				// }b`镶݂܂Ői߂
				if(index2 < search.length()){
					c2 = search.charAt(index2);
					index2++;
					boolean flag = false;
					while(index1 < text.length()){
						char c1 = text.charAt(index1);
						index1++;
						if(c2==c1){
							flag = true;
							break;
						}
					}
					if(flag){
						continue;
					} else {
						return false;
					}
				} else {
					return true;
				}
			} else if(c2=='?'){
				index1++;
				continue;
			} else {
				char c1 = text.charAt(index1);
				index1++;
				if(c1!=c2){
					return false;
				}
			}
		}
		if(index1!=text.length() || index2!=search.length()){
			return false;
		}
		return true;
	}
	
	/**
	 * w肵ŕAzŕԂ܂B
	 *
	 * @param s1 Ώۂ̕B
	 * @param s2 ̋؂Ɏgp镶B
	 * @return ʂzŕԂ܂Bs1null̏ꍇnullԂ܂B
	 */
	public static String[] split(String s1,String s2){
		if(s1 == null){
			return null;
		}
		ArrayList v  = new ArrayList();
		int last  = 0;
		int index = 0;
		while((index=s1.indexOf(s2,last))!=-1){
			v.add(s1.substring(last,index));
			last = index + s2.length();
		}
		if(last!=s1.length()){
			v.add(s1.substring(last));
		}
		return (String[])v.toArray(new String[v.size()]);
	}
	
	/**
	 * 񒆂̔Cӂ̕w肵ɒu܂B
	 *
	 * @param s  ϊΏۂ̕B
	 * @param s1 s2ɒu镶B
	 * @param s2 s1ɒu镶B
	 * @return ϊ̕Bsnull̏ꍇ͋󕶎Ԃ܂B
	 */
	public static String replace(String s,String s1,String s2){
		
		// s NULLꍇA󕶎Ԃ
		if(s==null){ return ""; }
		
		StringBuffer sb = new StringBuffer();
		int index = -1;
		int count = 0;
		while((index = s.indexOf(s1,count))!=-1){
			sb.append(s.substring(count,index));
			sb.append(s2);
			count = index + s1.length();
		}
		sb.append(s.substring(count,s.length()));
		
		return sb.toString();
	}
	
	/**
	 * t@C𕶎Ƃēǂݍ݂܂BɕR[h̎w͍sȂĂȂ߁A
	 * }`oCg܂ޏꍇAvbgtH[W̕R[hłȂƕ܂B
	 *
	 * @param file ǂݍރt@C
	 * @return 
	 */
	public static String loadFile(File file) throws IOException {
		
		FileInputStream in = new FileInputStream(file);
		ByteArrayOutputStream out = new ByteArrayOutputStream();
		byte[] buf = new byte[1024*8];
		int length = 0;
		
		while((length=in.read(buf))!=-1){
			out.write(buf,0,length);
		}
		
		in.close();
		
		String text = new String(out.toByteArray());
		
		return text;
	}
	
	/**
	 * w肵t@CƂĕۑ܂B
	 * t@C̕R[h̓vbgtH[W̕R[hɂȂ܂B
	 * t@C݂Ȃꍇ͍쐬܂B
	 *
	 * @param file t@C
	 * @param str  
	 */
	public static void saveFile(File file,String str) throws IOException {
		if(!file.exists()){
			file.createNewFile();
		}
		FileOutputStream out = new FileOutputStream(file);
		out.write(str.getBytes());
		out.flush();
		out.close();
	}
	
	/**
	 * ̐擪Ɩ̃^uAXy[Xr܂B
	 * NULL̏ꍇ͋󕶎Ԃ܂B
	 *
	 * @param str B
	 * @return ̕str^uAXy[X菜B
	 */
	public static String trim(String str){
		// NULL̏ꍇA󕶎Ԃ
		if(str==null){
			return "";
		}
		
		StringBuffer sb = new StringBuffer();
		boolean flagTop = false;
		// 擪̋󔒂폜
		for(int i=0;i<str.length();i++){
			char c = str.charAt(i);
			if(flagTop==true || (c!=' ' && c!='\t' && c!='\r' && c!='\n' && c!='@')){
				sb.append(c);
				flagTop = true;
			}
		}
		// ̋󔒂폜
		for(int i=sb.length()-1;i>=0;i--){
			char c = sb.charAt(i);
			if(c==' ' || c=='\t' || c=='\r' || c=='\n' || c=='@'){
				sb.deleteCharAt(i);
			} else {
				break;
			}
		}
		return sb.toString();
	}
	
	/**
	 * 𐮐lɕϊ܂B
	 * ϊɎsꍇ̓[Ԃ܂B
	 *
	 * @param value 
	 * @return liϊɎsꍇ̓[j
	 */
	public static int parseInt(String value){
		try {
			return Integer.parseInt(value);
		} catch(Exception ex){
			return 0;
		}
	}
	
	private static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss",Locale.ENGLISH);
	
	/**
	 * t\ṕuYYYY/MM/DD HH:MI:SSv`ɃtH[}bg܂B
	 *
	 * @param date Date
	 * @return tH[}bgꂽ
	 */
	public static String formatDate(Date date){
		return df.format(date);
	}
	
	/**
	 * fBNg폜܂B
	 */
	public static void removeDirectory(File dir){
		File[] files = dir.listFiles();
		for(int i=0;i<files.length;i++){
			if(files[i].isFile()){
				files[i].delete();
			} else {
				removeDirectory(files[i]);
			}
		}
		dir.delete();
	}
	
	////////////////////////////////////////////////////////////////////
	// vpeB֌W
	////////////////////////////////////////////////////////////////////
	/** \[X */
	private static ResourceBundle resources = ResourceBundle.getBundle("resources.javacvs",Locale.getDefault());
	
	/**
	 * vpeBt@C當擾܂B
	 *
	 * @param key L[
	 * @return 
	 */
	public static String getProperty(String key){
		String str;
		try {
			str = resources.getString(key);
		} catch (MissingResourceException mre) {
			str = null;
		}
		return str;
	}
	
	/**
	 * vpeBt@CURL擾܂B
	 *
	 * @param key L[
	 * @return URL
	 */
	public static URL getPropertyURL(String key){
		String name = getProperty(key);
		URL    url  = null;
		if (name != null) {
			url = name.getClass().getResource(name);
		}
		return url;
	}
	
	/**
	 * vpeBt@CImage擾܂B
	 *
	 * @param key L[
	 * @return Image
	 */
	public static Image getPropertyImage(String key){
		URL   url   = getPropertyURL(key);
		Image image = null;
		if(url!=null){
			image = new ImageIcon(url).getImage();
		}
		return image;
	}
	
	/////////////////////////////////////////////////////////////////////
	// O֌W
	/////////////////////////////////////////////////////////////////////
	/** Oo͂邩ǂ */
	private static int debug = parseInt(getProperty("debug.mode"));
	/** Ot@C */
	private static File logfile = new File(getProperty("debug.file"));
	
	/**
	 * Ot@CɂɃOo͂܂B
	 * resources/javacvs.propertiesdebug.mode=1̏ꍇo͂܂B
	 * o͂t@Cdebug.fileŎw肵܂B
	 *
	 * @param ex Ot@Cɏo͂郁bZ[W
	 */
	public static void log(String message){
		if(debug==1){
			try {
				FileWriter fw = new FileWriter(logfile,true);
				fw.write("[" + formatDate(new Date()) + "]" + message + "\n");
				fw.flush();
				fw.close();
			} catch(Exception logEx){
				logEx.printStackTrace();
			}
		}
	}
	
	/**
	 * Ot@CɃX^bNg[Xo͂܂B
	 * resources/javacvs.propertiesdebug.mode=1̏ꍇo͂܂B
	 * o͂t@Cdebug.fileŎw肵܂B
	 *
	 * @param ex Oo͂O
	 */
	public static void log(Exception ex){
		if(debug==1){
			try {
				PrintWriter pw = new PrintWriter(new FileWriter(logfile,true));
				pw.write("[" + formatDate(new Date()) + "]\n");
				ex.printStackTrace(pw);
				pw.flush();
				pw.close();
			} catch(Exception logEx){
				logEx.printStackTrace();
			}
		}
	}
	
}
