package tk.javacvs.swing;

import java.util.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.action.*;

/**
 * ANV̏ԂꊇǗ邽߂̃ReiNXB
 */
public class Actions {
	
	private HashMap actions     = new HashMap();
	private HashMap toggles     = new HashMap();
	private HashMap nemonic     = new HashMap();
	private HashMap accelerator = new HashMap();
	
	/**
	 * RXgN^B
	 */
	public Actions(MainWindow window){
		super();
		// }Eg
		this.actions.put("Mount",new MountAction(Util.getProperty("menu.file.mount"),new ImageIcon(Util.getPropertyImage("icon.etc_folder")),window));
		this.nemonic.put("Mount",new Integer('M'));
		// }Eg
		this.actions.put("Unmount",new UnmountAction(Util.getProperty("menu.file.unmount"),window));
		this.nemonic.put("Unmount",new Integer('U'));
		// `FbNAEg
		this.actions.put("Checkout",new CheckoutAction(Util.getProperty("menu.file.checkout"),new ImageIcon(Util.getPropertyImage("icon.checkout")),window));
		this.nemonic.put("Checkout",new Integer('C'));
		// C|[g
		this.actions.put("Import",new ImportAction(Util.getProperty("menu.file.import"),new ImageIcon(Util.getPropertyImage("icon.import")),window));
		this.nemonic.put("Import",new Integer('I'));
		// ݒ
		this.actions.put("Config",new ConfigAction(Util.getProperty("menu.file.config"),window));
		this.nemonic.put("Config",new Integer('S'));
		// GfB^ŊJ
		this.actions.put("Open",new OpenAction(Util.getProperty("menu.file.open"),window));
		this.nemonic.put("Open",new Integer('O'));
		this.accelerator.put("Open","control O");
		// XV(uodate)
		this.actions.put("Update",new UpdateAction(Util.getProperty("menu.cvs.update"),new ImageIcon(Util.getPropertyImage("icon.update")),window));
		this.nemonic.put("Update",new Integer('U'));
		this.accelerator.put("Update","control U");
		// i[(commit)
		this.actions.put("Commit",new CommitAction(Util.getProperty("menu.cvs.commit"),new ImageIcon(Util.getPropertyImage("icon.commit")),window));
		this.nemonic.put("Commit",new Integer('C'));
		this.accelerator.put("Commit","control C");
		// ǉ(add)
		this.actions.put("Add",new AddAction(Util.getProperty("menu.cvs.add"),new ImageIcon(Util.getPropertyImage("icon.add")),window));
		this.nemonic.put("Add",new Integer('A'));
		this.accelerator.put("Add","control A");
		// oCit@CƂĒǉ(add -kb)
		this.actions.put("Add Binary",new AddAction(Util.getProperty("menu.cvs.addkb"),new ImageIcon(Util.getPropertyImage("icon.addkb")),window,true));
		this.nemonic.put("Add Binary",new Integer('B'));
		this.accelerator.put("Add Binary","control B");
		// [J폜
		this.actions.put("Remove from Local",new RemoveLocalAction(Util.getProperty("menu.cvs.delete"),window));
		// |Wg폜(remove)
		this.actions.put("Remove from Repository",new RemoveAction(Util.getProperty("menu.cvs.remove"),new ImageIcon(Util.getPropertyImage("icon.remove")),window));
		this.nemonic.put("Remove from Repository",new Integer('R'));
		this.accelerator.put("Remove from Repository","DELETE");
		// (diff)
		this.actions.put("Diff",new DiffAction(Util.getProperty("menu.cvs.diff"),new ImageIcon(Util.getPropertyImage("icon.diff")),window));
		this.nemonic.put("Diff",new Integer('D'));
		this.accelerator.put("Diff","control D");
		// XV(log)
		this.actions.put("Log",new LogAction(Util.getProperty("menu.cvs.log"),new ImageIcon(Util.getPropertyImage("icon.log")),window));
		this.nemonic.put("Log",new Integer('L'));
		this.accelerator.put("Log","control L");
		// (status)
		this.actions.put("Status",new StatusAction(Util.getProperty("menu.cvs.status"),new ImageIcon(Util.getPropertyImage("icon.status")),window));
		this.nemonic.put("Status",new Integer('S'));
		this.accelerator.put("Status","control S");
		// Ot̕\
		this.actions.put("Graph",new GraphAction(Util.getProperty("menu.cvs.graph"),new ImageIcon(Util.getPropertyImage("icon.graph")),window));
		this.nemonic.put("Graph",new Integer('G'));
		this.accelerator.put("Graph","control G");
		// ^O̍쐬
		this.actions.put("Create Tag",new CreateTagAction(Util.getProperty("menu.cvs.createtag"),new ImageIcon(Util.getPropertyImage("icon.createtag")),window));
		this.nemonic.put("Create Tag",new Integer('T'));
		this.accelerator.put("Create Tag","control T");
		// ^O̍폜
		this.actions.put("Remove Tag",new RemoveTagAction(Util.getProperty("menu.cvs.removetag"),new ImageIcon(Util.getPropertyImage("icon.removetag")),window));
		// Xgr[̃[h
		this.actions.put("Reload",new ReloadAction(Util.getProperty("menu.view.reload"),new ImageIcon(Util.getPropertyImage("icon.reload")),window));
		this.nemonic.put("Reload",new Integer('E'));
		this.accelerator.put("Reload","F5");
		// AEgvbgr[̃NA
		this.actions.put("OutputClear",new ClearOutputViewAction(Util.getProperty("menu.view.clear"),window));
		// AEgvbgr[̃Rs[
		this.actions.put("OutputCopy",new OutputViewCopyAction(Util.getProperty("menu.view.copy"),window));
		// AEgvbgr[̍폜
		//this.actions.put("OutputRemove",new OutputViewRemoveAction(Util.getProperty("menu.view.remove"),window));
		// AEgvbgr[̑SI
		this.actions.put("OutputSelectAll",new OutputViewSelectAllAction(Util.getProperty("menu.view.selectall"),window));
		// o[W
		this.actions.put("Version",new VersionAction(Util.getProperty("menu.help.version"),window));
		this.nemonic.put("Version",new Integer('V'));
		// ċAIɕ\
		this.toggles.put("Recurse",new RecurseAction(Util.getProperty("menu.view.recurse"),new ImageIcon(Util.getPropertyImage("icon.recurse")),window));
		this.nemonic.put("Recurse",new Integer('R'));
		// XVꂽt@Ĉݕ\
		this.toggles.put("ModOnly",new ModOnlyAction(Util.getProperty("menu.view.modonly"),new ImageIcon(Util.getPropertyImage("icon.modonly")),window));
		this.nemonic.put("ModOnly",new Integer('M'));
		// CVSǗÕt@Ĉݕ\
		this.toggles.put("NoCVSOnly",new NoCVSOnlyAction(Util.getProperty("menu.view.nocvsonly"),new ImageIcon(Util.getPropertyImage("icon.nocvsonly")),window));
		this.nemonic.put("NoCVSOnly",new Integer('N'));
		// CVSǗ̃t@Ĉݕ\
		this.toggles.put("CVSOnly",new CVSOnlyAction(Util.getProperty("menu.view.cvsonly"),new ImageIcon(Util.getPropertyImage("icon.cvsonly")),window));
		this.nemonic.put("CVSOnly",new Integer('V'));
	}
	
	/**
	 * ANV擾܂B
	 */
	public CVSAction getAction(String key){
		CVSAction action = (CVSAction)actions.get(key);
		return action;
	}
	
	/**
	 * V[gJbg擾܂B
	 */
	public int getNemonic(String key){
		if(nemonic.get(key)==null){
			return -1;
		} else {
			return ((Integer)nemonic.get(key)).intValue();
		}
	}
	
	/**
	 * ANZ[^擾܂B
	 */
	public String getAccelerator(String key){
		if(accelerator.get(key)==null){
			return null;
		} else {
			return (String)accelerator.get(key);
		}
	}
	
	/**
	 * j[ACe擾܂B
	 * V[gJbgAANZ[^͐ݒς̃CX^Xԋp܂B
	 */
	public JMenuItem getMenuItem(String key){
		JMenuItem item = new JMenuItem(getAction(key));
		int nemonic = getNemonic(key);
		if(nemonic!=-1){
			item.setMnemonic(nemonic);
		}
		String accelerator = getAccelerator(key);
		if(accelerator!=null){
			item.setAccelerator(KeyStroke.getKeyStroke(accelerator));
		}
		return item;
	}
	
	/**
	 * gOANṼj[ACei`FbN{bNXj擾܂B
	 * V[gJbgAANZ[^͐ݒς̃CX^Xԋp܂B
	 */
	public JCheckBoxMenuItem getToggleMenuItem(String key){
		JCheckBoxMenuItem item = getToggleAction(key).createMenuItem();
		int nemonic = getNemonic(key);
		if(nemonic!=-1){
			item.setMnemonic(nemonic);
		}
		String accelerator = getAccelerator(key);
		if(accelerator!=null){
			item.setAccelerator(KeyStroke.getKeyStroke(accelerator));
		}
		return item;
	}
	
	/**
	 * gOANV擾܂B
	 */
	public AbstractToggleAction getToggleAction(String key){
		AbstractToggleAction action = (AbstractToggleAction)toggles.get(key);
		return action;
	}
	
	/**
	 * ANV̏ԂXV܂B
	 */
	public void updateActions(){
		Iterator i = actions.keySet().iterator();
		while(i.hasNext()){
			CVSAction action = (CVSAction)actions.get(i.next());
			action.update();
		}
	}
	
}
