package tk.javacvs.swing;

import tk.javacvs.*;
import java.io.*;
import java.util.*;

/**
 * JavaCVS SwingNCAg̐ݒeێNXB
 */
public class Config {
	
	/** fBNgc[Ƀ}EgĂfBNg̏ */
	private ArrayList mountInfo = new ArrayList();
	
	/** ȃbZ[W[h */
	private boolean quietMode = false;
	
	/** ݒt@C */
	private static final String CONFIG_FILE = "config.dat";
	
	/** GfB^ */
	private String editor = "";
	
	/** CVSR}h */
	private String cvsCommand = "cvs";
	
	/** gqƊOvÕ}bv */
	private HashMap editors = new HashMap();
	
	/** O̕R[h */
	private String charset = "EUC-JP";
	
	/** ODIFFvOgp邩ǂ */
	private boolean useExternalDiff = false;
	
	/** ODIFFvO */
	private String externalDiffProgram = "";
	
	/**
	 * RXgN^
	 */
	public Config(){
		super();
	}
	
	/**
	 * }EgfBNgǉ܂B
	 * ƂēnFileIuWFNgfBNgłȂꍇA
	 * ɓfBNg}EgĂꍇfalseԂ܂B
	 *
	 * @param dir fBNg
	 * @return ꍇtrueAsꍇfalse
	 */
	public boolean addMountDirectory(File dir){
		// fBNgǂmF
		if(!dir.isDirectory()){
			return false;
		}
		// ɓfBNgo^ĂȂmF
		for(int i=0;i<mountInfo.size();i++){
			File file = (File)mountInfo.get(i);
			if(file.equals(dir)){
				return false;
			}
		}
		
		// OKǉ
		mountInfo.add(dir);
		return true;
	}
	
	/**
	 * fBNg̃}Eg܂B
	 * w肵fBNg}EgĂȂꍇfalseԂ܂B
	 *
	 * @param dir fBNg
	 * @return ꍇtrueAsꍇfalse
	 */
	public boolean removeMountDirectory(File dir){
		for(int i=0;i<mountInfo.size();i++){
			File file = (File)mountInfo.get(i);
			if(file.equals(dir)){
				mountInfo.remove(i);
				return true;
			}
		}
		return false;
	}
	
	/**
	 * }EgĂfBNg̏擾܂B
	 *
	 * @return File[]
	 */
	public File[] getMountDirectories(){
		return (File[])mountInfo.toArray(new File[mountInfo.size()]);
	}
	
	/**
	 * ȃbZ[W[hǂݒ肵܂B
	 * ftHgłfalsełB
	 *
	 * @param quietMode ȃbZ[W[h̏ꍇtrueAłȂꍇfalse
	 */
	public void setQuietMode(boolean quietMode){
		this.quietMode = quietMode;
	}
	
	/**
	 * ȃbZ[W[hǂ擾܂B
	 * ftHgłfalsełB
	 *
	 * @return ȃbZ[W[h̏ꍇtrueAłȂꍇfalse
	 */
	public boolean getQuietMode(){
		return this.quietMode;
	}
	
	/**
	 * \[XJGfB^ݒ肵܂B
	 *
	 * @param editor GfB^vÕpX
	 */
	public void setEditor(String editor){
		if(editor!=null){
			this.editor = editor;
		}
	}
	
    /**
	 * \[XJGfB^擾܂B
	 *
	 * @return GfB^vÕpX
	 */
	public String getEditor(){
		return this.editor;
	}
	
	/**
	 * CVSR}hݒ肵܂B
	 *
	 * @param cvsCommand CVSR}h̃pX
	 */
	public void setCVSCommand(String cvsCommand){
		if(cvsCommand!=null){
			this.cvsCommand = cvsCommand;
		}
	}

	/**
	 * CVSR}h擾܂B
	 *
	 * @return CVSR}h̃pX
	 */
	public String getCVSCommand(){
		return this.cvsCommand;
	}
	
	/**
	 * gqƊOvOiGfB^j̊֘Atݒ肵܂B
	 *
	 * @param extention gqihbg͕svj
	 * @param program   vO
	 */
	public void setEditor(String extention,String program){
		this.editors.put(extention,program);
	}
	
	/**
	 * gqɊ֘AtꂽOvOiGfB^j擾܂B
	 * ֘AtꂽvO݂Ȃꍇ̓ftHg̃GfB^Ԃ܂B
	 * 
	 * @param extention gqihbg͕svj
	 * @return OvÕpX
	 */
	public String getEditor(String extention){
		if(this.editors.get(extention)==null){
			return this.getEditor();
		} else {
			return (String)this.editors.get(extention);
		}
	}
	
	/**
	 * gqƊOvO̊֘At폜܂B
	 * 
	 * @param extention gqihbg͕svj
	 */
	public void removeEditor(String extention){
		this.editors.remove(extention);
	}
	
	/**
	 * OvOɊ֘AtĂgqzŎ擾܂B
	 *
	 * @return gq̔z
	 */
	public String[] getExtentions(){
		Iterator ite = this.editors.keySet().iterator();
		ArrayList list = new ArrayList();
		while(ite.hasNext()){
			list.add(ite.next());
		}
		return (String[])list.toArray(new String[list.size()]);
	}
	
	/**
	 * ݒۑ܂B
	 */
	public void save() throws IOException {
		
		BufferedWriter out = new BufferedWriter(new FileWriter(CONFIG_FILE));
		
		// }Eg̏o
		out.write("[mount]");
		out.newLine();
		for(int i=0;i<mountInfo.size();i++){
			File file = (File)mountInfo.get(i);
			out.write(file.getAbsolutePath());
			out.newLine();
		}
		
		// IvV̏o
		out.write("[option]");
		out.newLine();
		// ȃbZ[W[h
		out.write("quietMode="+String.valueOf(quietMode));
		out.newLine();
		// GfB^
		out.write("editor="+editor);
		out.newLine();
		// CVSR}h
		out.write("cvs="+cvsCommand);
		out.newLine();
		// O̕R[h
		out.write("charset=" + charset);
		out.newLine();
		// ODIFFvO
		out.write("useExternalDiff=" + useExternalDiff);
		out.newLine();
		out.write("externalDiffProgram=" + externalDiffProgram);
		out.newLine();
		// gqƊOvO̊֘At
		String[] extentions = getExtentions();
		for(int i=0;i<extentions.length;i++){
			out.write("extention." + extentions[i] + "=" + getEditor(extentions[i]));
			out.newLine();
		}
		out.flush();
		out.close();
	}
	
	/**
	 * ݒǂݍ݂܂B
	 */
	public void load() throws IOException {
		
		BufferedReader in = new BufferedReader(new FileReader(CONFIG_FILE));
		String line = null;
		int    mode = 0;
		
		while((line = in.readLine())!=null){
			try {
				// g
				line = Util.trim(line);
				// Rgs
				if(line.startsWith("#") || line.equals("")){
					continue;
				}
				// }Eg擾[h
				if(line.equals("[mount]")){
					mode = 1;
					continue;
				}
				// IvV擾[h
				if(line.equals("[option]")){
					mode = 2;
					continue;
				}
				// }Eg̎擾
				if(mode==1){
					addMountDirectory(new File(line));
				}
				// IvV̎擾
				if(mode==2){
					String[] value = {
						line.substring(0,line.indexOf("=")),
						line.substring(line.indexOf("=")+1)
					};
					// ȃbZ[W[h̎擾
					if(value[0].equals("quietMode")){
						boolean quietMode = Boolean.valueOf(value[1]).booleanValue();
						setQuietMode(quietMode);
					// GfB^̎擾
					} else if(value[0].equals("editor")){
						setEditor(value[1]);
					// CVSR}h̎擾
					} else if(value[0].equals("cvs")){
						setCVSCommand(value[1]);
					// O̕R[h
					} else if(value[0].equals("charset")){
						setCharset(value[1]);
					// ODiffvOgp邩ǂ
					} else if(value[0].equals("useExternalDiff")){
						setUseExternalDiff(Boolean.valueOf(value[1]).booleanValue());
					// ODiffvÕpX
					} else if(value[0].equals("externalDiffProgram")){
						setExternalDiffProgram(value[1]);
					// gqƊOvO̊֘At
					} else if(value[0].startsWith("extention.")){
						String extention = value[0].substring(value[0].indexOf(".")+1);
						setEditor(extention,value[1]);
					}
				}
			} catch(Exception ex){
			}
		}
		in.close();
	}
	
	/**
	 * O̕R[hݒ肵܂BftHgłEUC-JPłB
	 *
	 * @param charset R[h
	 */
	public void setCharset(String charset){
		this.charset = charset;
	}
	
	/**
	 * O̕R[h擾܂BftHgłEUC-JPłB
	 * 
	 * @return R[h
	 */
	public String getCharset(){
		return this.charset;
	}
	
	/**
	 * ODIFFvOgp邩ǂݒ肵܂B
	 *
	 * @param useExternalDiff ODIFFvOgp邩ǂ
	 */
	public void setUseExternalDiff(boolean useExternalDiff){
		this.useExternalDiff = useExternalDiff;
	}
	
	/**
	 * ODIFFvOgp邩ǂ擾܂B
	 *
	 * @return ODIFFvOgp邩ǂ
	 */
	public boolean getUseExternalDiff(){
		return this.useExternalDiff;
	}
	
	/**
	 * ODIFFvÕpXݒ肵܂B
	 *
	 * @param externalDiffProgram ODIFFvÕpX
	 */
	public void setExternalDiffProgram(String externalDiffProgram){
		this.externalDiffProgram = externalDiffProgram;
	}
	
	/**
	 * ODIFFvÕpX擾܂B
	 *
	 * @return ODIFFvÕpX
	 */
	public String getExternalDiffProgram(){
		return this.externalDiffProgram;
	}
}
