package tk.javacvs.swing;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import tk.javacvs.*;

/**
 * t@CXgR|[lg
 */
public class FileList extends ListView {
	
	private File dir;
	//private DefaultTableModel model;
	private MainWindow window;
	private ArrayList data = new ArrayList();
	private JPopupMenu popupMenu;
	private SearchInfo searchInfo;
	private String filter = "";
	
	private Image imageCVSFolder  = Util.getPropertyImage("icon.cvs_folder");
	private Image imageCVSFile    = Util.getPropertyImage("icon.cvs_file");
	private Image imageETCFolder  = Util.getPropertyImage("icon.etc_folder");
	private Image imageETCFile    = Util.getPropertyImage("icon.etc_file");
	private Image imageMissFolder = Util.getPropertyImage("icon.miss_folder");
	private Image imageMissFile   = Util.getPropertyImage("icon.miss_file");
	private Image imageModFile    = Util.getPropertyImage("icon.mod_file");
	
	/**
	 * RXgN^
	 */
	public FileList(MainWindow window){
		super();
		this.window = window;
		// Jǉ
		addColumn("");
		addColumn(Util.getProperty("table.column.name"));
		addColumn(Util.getProperty("table.column.revision"));
		addColumn(Util.getProperty("table.column.option"));
		addColumn(Util.getProperty("table.column.status"));
		addColumn(Util.getProperty("table.column.tag"));
		addColumn(Util.getProperty("table.column.date"));
		// J̕ݒ
		TableColumnModel colModel = this.getColumnModel();
		TableColumn col1 = colModel.getColumn(0);
		col1.setPreferredWidth(20);
		col1.setMaxWidth(20);
		
		ListSelectionModel listModel = this.getSelectionModel();
		listModel.addListSelectionListener(new FolderListListener());
		
		this.popupMenu = new FileListPopupMenu(window.getActions());
		this.addMouseListener(new FileListMouseListener());
		this.searchInfo = new SearchInfo();
	}
	
	/**
	 * Xgŕ\fBNgݒ肵܂B
	 * ̃\bhĂ񂾂ł̓Xg͍ĕ`悳܂B
	 * Xg̍ĕ`sɂ͖Ireload\bhĂяo܂B
	 *
	 * @param dir fBNg
	 */
	public void setDirectory(File dir){
		if(dir!=null && !dir.isDirectory()){
			throw new IllegalArgumentException();
		}
		this.dir = dir;
	}
	
	/**
	 * ZbgAXg[h܂B
	 * 
	 * @param searchInfo 
	 */
	public void setSearchInfo(SearchInfo searchInfo){
		this.searchInfo = searchInfo;
		this.reload();
	}
	
	/**
	 * ݂̃Xgr[̌擾܂B
	 * 
	 * @return 
	 */
	public SearchInfo getSearchInfo(){
		return this.searchInfo;
	}
	
	/**
	 * ̃Xgŕ\̃fBNg擾܂B
	 */
	public File getDirectory(){
		return this.dir;
	}
	
	/**
	 * tB^ݒ肵܂B
	 * tB^񂪌݃ZbgĂ镶ƈقȂꍇ̂݁A
	 * tB^̍ĐݒƃXg̃[hs܂B
	 *
	 * @param filter tB^
	 */
	public void setFilter(String filter){
		if(!filter.equals(this.filter)){
			//System.out.println("tB^Đݒ肵ă[h܂B");
			this.filter = filter;
			this.reload();
		}
	}
	
	/**
	 * tB^擾܂B
	 *
	 * @return tB^
	 */
	public String getFilter(){
		return this.filter;
	}
	
	/**
	 * Xg̃[hs܂B
	 */
	public void reload(){
		// ܂Sč폜
		int rowCount = getRowCount();
		for(int i=0;i<rowCount;i++){
			removeRow(0);
		}
		// null̏ꍇ͂ȂɂȂŏI
		if(this.dir==null){
			return;
		}
		this.data = new ArrayList();
		readDirectory(this.dir);
	}
	
	/** œnfBNg̏ǂݍ݃Xgɒǉ */
	private void readDirectory(File dir){
		
		// ǉ
		EntryInfo info = new EntryInfo(dir);
		info.sort(EntryInfo.SORT_BY_NAME,true);
		
		for(int i=0;i<info.count();i++){
			File   file = info.getFile(i);
			String name = file.getName();
			String rev  = info.getRevision(i);
			String tag  = info.getTag(i);
			String opt  = info.getOption(i);
			Date   date = new Date(file.lastModified());
			
			String stat = Util.getProperty("table.status.file");
			Image image = this.imageCVSFile;
			
			// fBNg͕\Ȃ
			if(info.isDirectory(i)){
				if(this.searchInfo!=null && this.searchInfo.getRecurse()){
					readDirectory(file);
				}
				continue;
			}
			// ɂătB^O
			if(this.searchInfo!=null){
				int skipFlag1 = 0;
				int skipFlag2 = 0;
				int skipFlag3 = 0;
				// XVꂽt@Ĉݕ\
				if(this.searchInfo.getEdit()){
					if(!info.isModified(i)){
						skipFlag1 = 1;
					} else {
						skipFlag1 = -1;
					}
				}
				// CVSǗłȂt@Ĉݕ\
				if(this.searchInfo.getNoCVS()){
					if(info.isCVSFile(i)){
						skipFlag2 = 1;
					} else {
						skipFlag2 = -1;
					}
				}
				// CVSǗ̃t@Ĉݕ\
				if(this.searchInfo.getCVSOnly()){
					if(!info.isCVSFile(i)){
						skipFlag3 = 1;
					} else {
						skipFlag3 = -1;
					}
				}
				// tOĂXLbv
				if((skipFlag1==1 && skipFlag2!=-1 && skipFlag3!=-1) ||
				   (skipFlag2==1 && skipFlag1!=-1 && skipFlag3!=-1) ||
				   (skipFlag3==1 && skipFlag1!=-1 && skipFlag2!=-1)){
					continue;
				}
			}
			// tB^
			if(this.filter!=null && !this.filter.equals("")){
				if(!Util.match(name,this.filter)){
					continue;
				}
			}
			
			if(!info.isCVSFile(i)){
				stat += Util.getProperty("table.status.no_cvs");
				image = this.imageETCFile;
			} else if(info.isModified(i)){
				image = this.imageModFile;
				
			} else if(!file.exists()){
				image = this.imageMissFile;
			}
			
			Object[] rowData = {image,name,rev,opt,stat,tag,Util.formatDate(date)};
			addRow(rowData);
			this.data.add(new FileInfo(info.getFile(i),info.isCVSFile(i)));
		}
	}
	
	/**
	 * IĂt@C̈ꗗ擾܂B
	 */
	public FileInfo[] getSelectedFileInfo(){
		int[] sel = this.getSelectedRows();
		ArrayList list = new ArrayList();
		for(int i=0;i<sel.length;i++){
			list.add(this.data.get(sel[i]));
		}
		return (FileInfo[])list.toArray(new FileInfo[list.size()]);
	}
	
	///////////////////////////////////////////////////////////////////////////
	// e[ũZNVXi
	///////////////////////////////////////////////////////////////////////////
	private class FolderListListener implements ListSelectionListener {
		public void valueChanged(ListSelectionEvent e){
			window.setComponentFocus(MainWindow.FOCUS_LIST);
			window.updateActions();
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// |bvAbvj[
	///////////////////////////////////////////////////////////////////////////
	private class FileListPopupMenu extends JPopupMenu {
		
		public FileListPopupMenu(Actions actions){
			super();
			add(actions.getMenuItem("Reload"));
			add(actions.getMenuItem("Open"));
			addSeparator();
			add(actions.getMenuItem("Update"));
			add(actions.getMenuItem("Commit"));
			addSeparator();
			add(actions.getMenuItem("Add"));
			add(actions.getMenuItem("Add Binary"));
			addSeparator();
			add(actions.getMenuItem("Remove from Local"));
			add(actions.getMenuItem("Remove from Repository"));
			addSeparator();
			add(actions.getMenuItem("Diff"));
			add(actions.getMenuItem("Log"));
			add(actions.getMenuItem("Status"));
			add(actions.getMenuItem("Graph"));
			addSeparator();
			add(actions.getMenuItem("Create Tag"));
			add(actions.getMenuItem("Remove Tag"));
		}
		
	}
	
	///////////////////////////////////////////////////////////////////////////
	// }EXXi
	///////////////////////////////////////////////////////////////////////////
	private class FileListMouseListener extends MouseAdapter {
		
		public void mouseClicked(MouseEvent evt){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_LIST);
			window.updateActions();
			
			// |bvAbvj[
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
				return;
				
			// _uNbNƂ̏
			} else if (evt.getClickCount() == 2){
				FileInfo[] info = getSelectedFileInfo();
				if(info!=null && info.length>=1){
					File file = info[0].getFile();
					if(file.exists()){
						// fBNg̏ꍇ͕\
						if(file.isDirectory()){
							setDirectory(file);
							reload();
							//window.sync(file);
						// t@C̏ꍇ̓GfB^ŊJ
						} else {
							window.openSelectedFile();
						}
					}
				}
			}
		}
		
		public void mouseReleased(MouseEvent evt){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_LIST);
			window.updateActions();
			// |bvAbvj[\
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
			}
		}
		
		public void mousePressed(MouseEvent evt) {
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_LIST);
			window.updateActions();
			// |bvAbvj[\
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
			}
		}
	}
}
