package tk.javacvs.swing;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.tree.*;
import java.util.*;
import java.io.*;
import tk.javacvs.*;

/**
 * fBNgc[R|[lg
 */
public class FolderTree extends JTree {
	
	private MainWindow window;
	private FolderTreeModel model;
	private FolderTreePopupMenu popupMenu;
	
	/**
	 * RXgN^
	 *
	 * @param window MainWindow̃CX^X
	 */
	public FolderTree(MainWindow window){
		super();
		this.window = window;
		this.model  = new FolderTreeModel(new RootNode());
		this.setModel(model);
		this.addTreeExpansionListener(new FolderTreeListener());
		this.addTreeSelectionListener(new FolderSelectionListener());
		this.setCellRenderer(new FolderTreeCellRenderer());
		
		this.popupMenu = new FolderTreePopupMenu(window.getActions());
		this.addMouseListener(new FolderTreeMouseListener());
	}
	
	/**
	 * fBNg}Eg܂B
	 *
	 * @param dir }EgfBNg
	 */
	public void mountDirectory(File dir){
		this.model.mount(dir);
	}
	
	/**
	 * fBNgA}Eg܂B
	 *
	 * @param dir A}EgfBNg
	 */
	public void unmountDirectory(File dir){
		this.model.unmount(dir);
	}
	
	/**
	 * IĂvWFNgm[h̃t@CIuWFNgԂ܂B
	 * [gm[hIĂȂꍇnullԂ܂B
	 *
	 * @return IĂvWFNg
	 */
	public File getSelectedProjectDirectory(){
		DefaultMutableTreeNode node = getSelectedNode();
		if(node == null || node instanceof RootNode || !((FolderNode)node).isProject()){
			return null;
		}
		return (File)node.getUserObject();
	}
	
	/**
	 * IĂfBNgFileInfoIuWFNgƂĕԂ܂B
	 * m[hIĂȂA[gm[hIĂꍇnullԂ܂B
	 *
	 * @return FileInfo
	 */
	public FileInfo getSelectedFileInfo(){
		DefaultMutableTreeNode node = getSelectedNode();
		if(node == null || node instanceof RootNode){
			return null;
		}
		File file = (File)node.getUserObject();
		
		return new FileInfo(file,isCVSDirectory(file));
	}
	
	/**
	 * IĂfBNgԂ܂B
	 * [ƃm[hIĂꍇnullԂ܂B
	 * 
	 * @return IĂfBNg
	 */
	public File getSelectedDirectory(){
		DefaultMutableTreeNode node = getSelectedNode();
		if(node == null || node instanceof RootNode){
			return null;
		}
		return (File)node.getUserObject();
	}
	
	/**
	 * œnfBNgIԂɂ܂B
	 * Xgr[ŃfBNgACRőJڂꍇɎgp܂B
	 *
	 * @param dir fBNg
	 */
	/*
	public void sync(File dir){
		// fBNgǂ
		if(!dir.exists() || !dir.isDirectory()){
			throw new IllegalArgumentException();
		}
		ArrayList list = new ArrayList();
		DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
		list.add(root);
		searchPath(root,dir,list);
		
		// pXJđIԂɂ
		TreePath path = new TreePath(list.toArray());
		this.expandPath(path);
		this.setSelectionPath(path);
	}
	*/
	/**
	 * pXċAIɌB
	 */
	/*
	private void searchPath(DefaultMutableTreeNode node,File dir,ArrayList list){
		for(int i=0;i<node.getChildCount();i++){
			DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
			File file = (File)child.getUserObject();
			if(file.equals(dir)){
				TreePath path = new TreePath(list.toArray());
				this.expandPath(path);
				list.add(child);
				return;
			} else if(dir.getAbsolutePath().startsWith(file.getAbsolutePath())){
				TreePath path = new TreePath(list.toArray());
				this.expandPath(path);
				list.add(child);
				searchPath(child,dir,list);
				return;
			}
		}
	}
	*/
	/**
	 * œnfBNgCVSfBNgǂ𒲂ׂ܂B
	 */
	private boolean isCVSDirectory(File file){
		File cvsDir = new File(file,"CVS");
		if(cvsDir.exists() && cvsDir.isDirectory()){
			return true;
		}
		return false;
	}

	/**
	 * IĂm[h擾܂B
	 * ȂɂIĂȂꍇnullԂ܂B
	 *
	 * @return IĂm[h
	 */
	private DefaultMutableTreeNode getSelectedNode(){
		TreePath path = getSelectionPath();
		if(path==null){
			return null;
		}
		DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
		return node;
	}
	
	///////////////////////////////////////////////////////////////////////////
	// c[f
	///////////////////////////////////////////////////////////////////////////
	private class FolderTreeModel extends DefaultTreeModel {
		/** RXgN^ */
		public FolderTreeModel(TreeNode root){
			super(root);
		}
		/** }Eg */
		public void mount(File dir){
			DefaultMutableTreeNode root = (DefaultMutableTreeNode)getRoot();
			root.add(new FolderNode(dir,true));
			this.reload();
		}
		/** A}Eg */
		public void unmount(File dir){
			DefaultMutableTreeNode root = (DefaultMutableTreeNode)getRoot();
			int count = root.getChildCount();
			for(int i=0;i<count;i++){
				DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getChildAt(i);
				File file = (File)node.getUserObject();
				if(file.equals(dir)){
					root.remove(node);
					break;
				}
			}
			this.reload(root);
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// [gm[h
	///////////////////////////////////////////////////////////////////////////
	private class RootNode extends DefaultMutableTreeNode {
		/** RXgN^ */
		public RootNode(){
			super(Util.getProperty("tree.cvs_projects"));
		}
		/** false */
		public boolean isLeaf(){
			return false;
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// fBNgm[h
	///////////////////////////////////////////////////////////////////////////
	private class FolderNode extends DefaultMutableTreeNode {
		
		private boolean isProject = false;
		
		/** RXgN^ */
		public FolderNode(File file){
			super(new Folder(file));
		}
		/** RXgN^ */
		public FolderNode(File file,boolean isProject){
			super(new Folder(file));
			this.isProject = isProject;
		}
		public boolean isProject(){
			return this.isProject;
		}
		/** false */
		public boolean isLeaf(){
			return false;
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// tH_IuWFNg
	///////////////////////////////////////////////////////////////////////////
	private class Folder extends File {
		/** RXgN^ */
		public Folder(File file){
			super(file.toString());
		}
		/** OԂ */
		public String toString(){
			return getName();
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// tH_̃c[Xi
	///////////////////////////////////////////////////////////////////////////
	private class FolderTreeListener implements TreeExpansionListener {
		/** [ꂽƂiȂɂȂj */
		public void treeCollapsed(TreeExpansionEvent event){
		}
		/** WJꂽƂ */
		public void treeExpanded(TreeExpansionEvent event){
			
			TreePath path = event.getPath();
			DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
			
			// [gm[h̏ꍇ͂ȂɂȂ
			if(node instanceof RootNode){
				return;
			}
			
			node.removeAllChildren();
			File file = (File)node.getUserObject();
			File[] files = file.listFiles();
			Arrays.sort(files);
			DefaultMutableTreeNode lastNode = null;
			
			for(int i=0;i<files.length;i++){
				if(files[i].isDirectory() && !files[i].getName().equals("CVS")){
					lastNode = new FolderNode(files[i]);
					node.add(lastNode);
				}
			}
			model.reload(node);
			expandPath(new TreePath(node.getPath()));
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// tH_̃c[Xi
	///////////////////////////////////////////////////////////////////////////
	private class FolderSelectionListener implements TreeSelectionListener {
		public void valueChanged(TreeSelectionEvent event){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			
			TreePath path = event.getPath();
			DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
			
			// [gm[h̏ꍇ͂ȂɂȂ
			if(node instanceof RootNode){
				window.changeListDirectory(null);
				return;
			}
			
			File file = (File)node.getUserObject();
			window.changeListDirectory(file);
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// c[r[̃Z_
	///////////////////////////////////////////////////////////////////////////
	public class FolderTreeCellRenderer extends DefaultTreeCellRenderer {
		
		private Icon etc_folder = new ImageIcon(Util.getPropertyImage("icon.etc_folder"));
		private Icon cvs_folder = new ImageIcon(Util.getPropertyImage("icon.cvs_folder"));

		public Component getTreeCellRendererComponent(JTree   tree, 
													  Object  value, 
													  boolean selected, 
													  boolean expanded, 
													  boolean leaf, 
													  int     row, 
													  boolean hasFocus) {
			// ftHg̃_OR|[lg擾
			JLabel cell = (JLabel)super.getTreeCellRendererComponent(tree,value,selected,expanded,leaf,row,hasFocus);
			
			// [gm[h̏ꍇ
			if(value instanceof RootNode){
				cell.setIcon(etc_folder);
				
			// tH_m[h̏ꍇ
			} else if(value instanceof FolderNode){
				FolderNode node = (FolderNode)value;
				// vWFNgm[h̏ꍇ
				//if(node.isProject()){
				//	cell.setIcon(cvs_folder);
				// vWFNgm[hȊȌꍇ
				//} else {
					File dir = (File)node.getUserObject();
					// CVSfBNg̏ꍇ
					if(isCVSDirectory(dir)){
						cell.setIcon(cvs_folder);
					// CVSfBNgłȂꍇ
					} else {
						cell.setIcon(etc_folder);
					}
				//}
			}
			//setIcon(\image);
			return cell;
		}
	}

	///////////////////////////////////////////////////////////////////////////
	// |bvAbvj[
	///////////////////////////////////////////////////////////////////////////
	private class FolderTreePopupMenu extends JPopupMenu {
		
		public FolderTreePopupMenu(Actions actions){
			super();
			add(actions.getMenuItem("Update"));
			add(actions.getMenuItem("Commit"));
			addSeparator();
			add(actions.getMenuItem("Add"));
			addSeparator();
			add(actions.getMenuItem("Remove from Repository"));
			addSeparator();
			add(actions.getMenuItem("Diff"));
			add(actions.getMenuItem("Log"));
			add(actions.getMenuItem("Status"));
			addSeparator();
			add(actions.getMenuItem("Create Tag"));
			add(actions.getMenuItem("Remove Tag"));
		}
		
	}
	
	///////////////////////////////////////////////////////////////////////////
	// }EXXi
	///////////////////////////////////////////////////////////////////////////
	private class FolderTreeMouseListener extends MouseAdapter {
		
		public void mouseClicked(MouseEvent evt){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			// |bvAbvj[
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
				return;
			}
		}
		
		public void mouseReleased(MouseEvent evt){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			// |bvAbvj[\
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
			}
		}
		
		public void mousePressed(MouseEvent evt) {
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			// |bvAbvj[\
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
			}
		}
	}
}
