package tk.javacvs.swing;

import java.io.*;
import javax.swing.*;
import tk.javacvs.*;

/**
 * ͓eLđI\ȃR{{bNXB
 */
public class HistoryComboBox extends JComboBox {
	
	private File historyFile;
	
	/**
	 * RXgN^
	 *
	 * @param historyFile ۑt@C
	 */
	public HistoryComboBox(File historyFile){
		super();
		this.setEditable(true);
		this.historyFile = historyFile;
		if(historyFile.exists()){
			loadHistory();
		}
	}
	
	/**
	 * eLXg擾܂B
	 */
	public String getText(){
		return (String)this.getSelectedItem();
	}
	
	/**
	 * [hăR{{bNXɒǉ܂BRXgN^Ă΂܂B
	 */
	private void loadHistory(){
		this.addItem("");
		String[] lines = getHistoryLines();
		for(int i=0;i<lines.length;i++){
			this.addItem(lines[i]);
		}
	}
	
	/**
	 * ۑ܂BV̂珇10܂ŕۑ܂B
	 */
	public void saveHistory(){
		try {
			// 擾
			String text  = (String)this.getSelectedItem();
			if(text==null || text.equals("")){
				return;
			}
			// ̂邩ׂ
			String[] lines = getHistoryLines();
			boolean flag = true;
				for(int i=0;i<lines.length;i++){
				if(text.equals(lines[i])){
					flag = false;
					break;
				}
			}
			// ۑ
			if(flag){
				StringBuffer sb = new StringBuffer();
				sb.append(text + "\n");
				for(int i=0;i<20 && i<lines.length;i++){
					sb.append(lines[i] + "\n");
				}
				Util.saveFile(this.historyFile,sb.toString());
			}
			
		} catch(IOException ex){
			Util.log(ex);
		}
	}
	
	/**
	 * t@Cǂݍ݁APsɕĔzƂĕԋp܂B
	 */
	private String[] getHistoryLines(){
		try {
			String history = Util.loadFile(this.historyFile);
			// sR[h𓝈
			history = Util.replace(history,"\r\n","\n");
			history = Util.replace(history,"\r","\n");
			return Util.split(history,"\n");
		} catch(Exception ex){
			return new String[0];
		}
	}
}
