package tk.javacvs.swing;

import java.awt.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;

/**
 * SwingJTableJX^}CYXgr[R|[lgB
 *
 * @author Naoki Takezoe
 */
public class ListView extends JTable {
	
	private DefaultTableModel model;
	
	/** RXgN^B */
	public ListView(){
		super();
		// fZbg
		this.model = new ListModel();
		this.setModel(this.model);
		// wb_̍ݒ
		JTableHeader header = this.getTableHeader();
		header.setReorderingAllowed(false);
		Dimension dim = header.getPreferredSize();
		dim.height = 20;
		header.setPreferredSize(dim);
		// Obh\ɂ
		Dimension margin = new Dimension(0,1);
		setIntercellSpacing(margin);
		setShowVerticalLines(false);
		setShowHorizontalLines(true);
		// Z_ݒ
		this.setDefaultRenderer(Object.class    ,new ListCellRenderer());
		this.setDefaultRenderer(String.class    ,new ListCellRenderer());
		this.setDefaultRenderer(Image.class     ,new ListCellRenderer());
		this.setDefaultRenderer(ImageIcon.class ,new ListCellRenderer());
	}
	
	/** Jǉ܂B */
	public void addColumn(String columnHeader){
		this.model.addColumn(columnHeader);
	}
	
	/** R[hǉ܂B */
	public void addRow(Object[] rowData){
		this.model.addRow(rowData);
	}
	
	/** R[h폜܂B */
	public void removeRow(int row){
		this.model.removeRow(row);
	}
	
	/** R[hԋp܂B */
	public int getRowCount(){
		if(this.model!=null){
			return this.model.getRowCount();
		} else {
			return 0;
		}
	}
	
	////////////////////////////////////////////////////////////////////////////
	// Xgr[̃Z_
	////////////////////////////////////////////////////////////////////////////
	private class ListCellRenderer extends DefaultTableCellRenderer {
		
		private Color background;
		private Color foreground;
		
		/**
		 * RXgN^
		 */
		public ListCellRenderer(){
			super();
			background = getBackground();
			foreground = getForeground();
			
			Font font = getFont();
			Font newFont = new Font(font.getName(),Font.PLAIN,font.getSize());
			setFont(newFont);
		}
		
		/**
		 * Z_OR|[lgԂ܂B
		 * 
		 * @param table      
		 * @param data       
		 * @param isSelected 
		 * @param row        
		 * @param column     
		 */
		public Component getTableCellRendererComponent(JTable  table,
		                                               Object  data,
		                                               boolean isSelected,
		                                               boolean hasFocus,
		                                               int     row,
		                                               int     column) {

			
			// IĂ镔͐Fς
			if (isSelected){
				setBackground(getSelectionBackground());
				setForeground(getSelectionForeground());
			} else {
				setBackground(background);
				setForeground(foreground);
			}
			
			if(data instanceof String){
				setText((String)data);
				
			} else if(data instanceof ImageIcon){
				setIcon((ImageIcon)data);
				
			} else if(data instanceof Image){
				setIcon(new ImageIcon((Image)data));
			}
			
			return this;
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// e[uf
	///////////////////////////////////////////////////////////////////////////
	private class ListModel extends DefaultTableModel {
		
		public boolean isCellEditable(int row, int column){
			return false;
		}
		
		public Class getColumnClass(int column){
			Vector v = (Vector)dataVector.elementAt(0);
			return v.elementAt(column).getClass();
		}
	}

}
