package tk.javacvs.swing;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import tk.javacvs.*;

/**
 * JavaCVS SwingNCAg̃CEBhE
 */
public class MainWindow extends JFrame {
	
	private CVS        cvs;
	private Config     config;
	private FolderTree tree;
	private FileList   table;
	private OutputView text;
	private Actions    actions;
	private MainMenu   menu;
	private ToolBar    toolbar;
	private String     version;
	
	public static final int FOCUS_TREE = 0;
	public static final int FOCUS_LIST = 1;
	
	private int focus = -1;
	
	/**
	 * RXgN^
	 */
	public MainWindow(){
		super();
		// e|fBNg̍쐬
		if(!new File("./tmp").mkdir()){
			alert(Util.getProperty("message.error_create_tmp"));
			System.exit(1);
		}
		
		// ݒ擾
		this.config = new Config();
		try {
			this.config.load();
		} catch(IOException ex){
			Util.log(Util.getProperty("message.error_load_config"));
			Util.log(ex);
		}
		
		// ANV
		this.actions = new Actions(this);
		
		// R|[lg
		this.version = Util.getProperty("javacvs.version");
		this.setTitle(version);
		this.setIconImage(new ImageIcon(Util.getProperty("javacvs.icon")).getImage());
		
		this.menu    = new MainMenu(this,actions);
		this.tree    = new FolderTree(this);
		this.table   = new FileList(this);
		this.text    = new OutputView(this);
		this.toolbar = new ToolBar(this,actions);
		
		Container cp = this.getContentPane();
		cp.setLayout(new BorderLayout());
		cp.add(this.toolbar,BorderLayout.NORTH);
		
		JSplitPane hor = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT);
		hor.add(new JScrollPane(this.tree));
		hor.add(new JScrollPane(this.table));
		
		JSplitPane ver = new JSplitPane(JSplitPane.VERTICAL_SPLIT);
		ver.add(hor);
		ver.add(new JScrollPane(this.text));
		ver.setDividerLocation(200);
		
		cp.add(ver,BorderLayout.CENTER);
		
		this.setJMenuBar(this.menu);
		this.setSize(640,400);
		this.addWindowListener(new MainWindowListener());
		
		
		// Config̏lEBWFbgɔf
		File[] files = config.getMountDirectories();
		for(int i=0;i<files.length;i++){
			this.mountDirectory(files[i]);
		}
		PipedOutputStream out = new PipedOutputStream();
		this.cvs = new CVS(config.getCVSCommand(),out);
		this.cvs.setQuietMode(config.getQuietMode());
		this.cvs.setCharset(config.getCharset());
		RedirectThread thread = new RedirectThread(out);
		thread.start();
		
		// ANV̏ԂXV
		this.updateActions();
		
		this.cvs.addCVSListener(new MainCVSListener());
	}
	
	/**
	 * Xgr[ŕ\ĂfBNgύXꂽꍇ
	 * c[r[Ɠ邽߂̃\bhB
	 *
	 * @param dir fBNg
	 */
	/*
	public void sync(File dir){
		tree.sync(dir);
	}
	*/
	/**
	 * CVSIuWFNg擾܂B
	 *
	 * @return CVS
	 */
	public CVS getCVS(){
		return this.cvs;
	}
	
	/**
	 * ǂ̃R|[lgŌɃtH[JXĂݒ肵܂B
	 *
	 * @param focus FOCUS_TREEFOCUS_LIST
	 */
	public void setComponentFocus(int focus){
		if(focus!=FOCUS_TREE && focus!=FOCUS_LIST){
			throw new IllegalArgumentException();
		}
		this.focus = focus;
	}
	
	/**
	 * AEgvbgr[̃tHgݒ肵܂B
	 */
	public void setOutputViewFont(Font font){
		this.text.setFont(font);
	}
	
	/**
	 * Xgr[őIĂt@CJ܂B
	 */
	public void openSelectedFile(){
		// IĂt@CGfB^N
		FileInfo[] info = getSelectedFileInfo();
		for(int i=0;i<info.length;i++){
			File   file      = info[i].getFile();
			String fileName  = file.getName();
			String editor    = null;
			// gqꍇ
			if(fileName.indexOf(".")!=-1){
				String extention = fileName.substring(fileName.lastIndexOf(".")+1);
				editor = config.getEditor(extention);
			// gqȂꍇ
			} else {
				editor = config.getEditor();
			}
			// GfB^ݒ肳ĂȂꍇ̓G[ɂ
			if(editor==null || editor.equals("")){
				this.alert(Util.getProperty("message.no_editor"));
				break;
			} else {
				String command   = editor + " " + file.getAbsolutePath();
				try {
					Runtime runtime = Runtime.getRuntime();
					Process process = runtime.exec(command);
				} catch(Exception ex){
					Util.log(Util.getProperty("message.error_open_file"));
					Util.log(ex);
				}
			}
		}
	}
	
	/**
	 * OutputViewNA܂B
	 */
//	public void clearOutputView(){
//		this.text.setText("");
//	}
	
//	public void selectOutputView(){
//		this.text.selectAll();
//	}
	
	/**
	 * OutputView̃CX^X擾܂B
	 */
	public OutputView getOutputView(){
		return this.text;
	}
	
	/**
	 * o[W\܂B
	 */
	public void showInformationDialog(){
		String title   = Util.getProperty("dialog.title.version");
		String message = this.version + "\n" + "2003-2005 (C) Project Amateras";
		JOptionPane.showMessageDialog(this,message,title,JOptionPane.INFORMATION_MESSAGE);
	}
	
	/**
	 * A[g_CAO\܂B
	 *
	 * @param message bZ[W
	 */
	public void alert(String message){
		String title = Util.getProperty("dialog.title.alert");
		JOptionPane.showMessageDialog(this,message,title,JOptionPane.ERROR_MESSAGE);
	}
	
	/**
	 * ActionsIuWFNg擾܂B
	 *
	 * @return Actions
	 */
	public Actions getActions(){
		return this.actions;
	}
	
	/**
	 * ANV̏ԂXV܂B
	 */
	public void updateActions(){
		this.actions.updateActions();
	}
	
	/**
	 * Xgr[ŕ\fBNgύX܂B
	 * Xgr[̃[hs܂B
	 *
	 * @param dir fBNg
	 */
	public void changeListDirectory(File dir){
		this.table.setDirectory(dir);
		this.table.setFilter(this.toolbar.getFilter());
		this.table.reload();
	}
	
	/**
	 * Xgr[ŕ\̃fBNg擾܂B
	 */
	public File getListDirectory(){
		return this.table.getDirectory();
	}

	/**
	 * Xgr[[h܂B
	 */
	public void reloadList(){
		this.table.setFilter(this.toolbar.getFilter());
		this.table.reload();
	}
	
	/**
	 * ConfigIuWFNg擾܂B
	 *
	 * @return Config
	 */
	public Config getConfig(){
		return this.config;
	}
	
	/**
	 * c[r[ɃfBNg}Eg܂B
	 * ConfigIuWFNgɂ͐ݒ͔f܂B
	 *
	 * @param file }EgfBNg
	 */
	public void mountDirectory(File file){
		this.tree.mountDirectory(file);
	}
	
	/**
	 * c[r[fBNgA}Eg܂B
	 * ConfigIuWFNgɂ͐ݒ͔f܂B
	 *
	 * @param file A}EgfBNg
	 */
	public void unmountDirectory(File file){
		this.tree.unmountDirectory(file);
	}
	
	/**
	 * c[r[őIĂvWFNgm[h̃fBNg擾܂B
	 * [gm[hIĂȂꍇnullԂ܂B
	 *
	 * @return c[r[őIĂvWFNg
	 */
	public File getSelectedProjectDirectory(){
		if(this.focus == FOCUS_TREE){
			return tree.getSelectedProjectDirectory();
		} else {
			return null;
		}
	}
	
	/**
	 * Xgr[őIĂt@C̏擾܂B
	 * c[r[ɃtH[JXꍇ̓c[r[őIĂtH_Ԃ܂B
	 * c[r[Ń[gm[hIĂꍇ͒[̔zԂ܂B
	 *
	 * @return FileInfo[]
	 */
	public FileInfo[] getSelectedFileInfo(){
		
		// c[tH[JXĂ
		if(this.focus==FOCUS_TREE){
			FileInfo info = this.tree.getSelectedFileInfo();
			if(info==null){
				return null;
			} else {
				return new FileInfo[]{info};
			}
		// e[utH[JXĂ
		} else if(this.focus==FOCUS_LIST){
			return this.table.getSelectedFileInfo();
		}
		return null;
	}
	
	/**
	 * ݃c[r[܂̓Xgr[ōƑΏۂ̃fBNg擾܂B
	 * c[r[Ń[gm[hIĂꍇnullԂ܂B
	 * 
	 * @return fBNg
	 */
	public File getRoot(){
		// c[tH[JXĂ
		if(this.focus==FOCUS_TREE){
			return this.tree.getSelectedDirectory().getParentFile();
			
		// e[utH[JXĂ
		} else if(this.focus==FOCUS_LIST){
			return this.table.getDirectory();
		}
		return null;
	}
	
	public void setShowRecurse(boolean recurse){
		this.table.setFilter(this.toolbar.getFilter());
		SearchInfo info = this.table.getSearchInfo();
		info.setRecurse(recurse);
		this.table.setSearchInfo(info);
	}
	
	public void setShowModOnly(boolean edit){
		this.table.setFilter(this.toolbar.getFilter());
		SearchInfo info = this.table.getSearchInfo();
		info.setModOnly(edit);
		this.table.setSearchInfo(info);
	}

	public void setShowNoCVSOnly(boolean nocvs){
		this.table.setFilter(this.toolbar.getFilter());
		SearchInfo info = this.table.getSearchInfo();
		info.setNoCVS(nocvs);
		this.table.setSearchInfo(info);
	}

	public void setShowCVSOnly(boolean cvsOnly){
		this.table.setFilter(this.toolbar.getFilter());
		SearchInfo info = this.table.getSearchInfo();
		info.setCVSOnly(cvsOnly);
		this.table.setSearchInfo(info);
	}

	
	////////////////////////////////////////////////////////////////////////////
	// EBhẼXi
	////////////////////////////////////////////////////////////////////////////
	private class MainWindowListener extends WindowAdapter {
		
		public void windowClosed(WindowEvent e){
			this.exit();
		}
		
		public void windowClosing(WindowEvent e){
			this.exit();
		}
		
		private void exit(){
			try {
				// ݒ̕ۑ
				config.save();
				// e|t@C̍폜
				Util.removeDirectory(new File("./tmp"));
			} catch(Exception ex){
				Util.log(Util.getProperty("message.error_save_config"));
				Util.log(ex);
			}
			System.exit(0);
		}
	}
	
	////////////////////////////////////////////////////////////////////////////
	// CVSR}h̏o͂OutputViewɃ_CNgXbh
	////////////////////////////////////////////////////////////////////////////
	private class RedirectThread extends Thread {
		
		private BufferedReader in;
		
		public RedirectThread(PipedOutputStream out){
			super();
			try {
				this.in = new BufferedReader(new InputStreamReader(new PipedInputStream(out)));
			} catch(IOException ex){
				Util.log(ex);
			}
		}
		
		public void run(){
			String line = null;
			while(true){
				try {
					sleep(5);
					while((line=in.readLine())!=null){
						text.insertString(line + "\n");
					}
				} catch(Exception ex){
					//Util.log(ex);
				}
			}
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// CVSR}h̒ʒm󂯎邽߂̃Xi
	///////////////////////////////////////////////////////////////////////////
	private class MainCVSListener implements CVSListener {
		/** R}hJn */
		public void startCommand(int command){
			
		}
		/** R}hI */
		public void endCommand(int command){
			// Kvȏꍇ̂݃Xg[h
			if(command == CVS.COMMAND_COMMIT ||
			   command == CVS.COMMAND_UPDATE ||
			   command == CVS.COMMAND_ADD    ||
			   command == CVS.COMMAND_REMOVE ||
			   command == CVS.COMMAND_TAG){
				
				reloadList();
			}
		}
		/** G[ */
		public void error(Exception ex){
			alert(ex.getMessage());
			Util.log(ex);
		}
	}
}
