package tk.javacvs.swing;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.event.*;
import tk.javacvs.*;

/* AEgvbgr[ */
public class OutputView extends JTextPane {
	
	private DefaultStyledDocument doc;
	private Style green;
	private Style red;
	private Style blue;
	private Style yellow;
	private OutputViewPopupMenu popupMenu;
	private MainWindow window;
	
	/**
	 * RXgN^
	 */
	public OutputView(MainWindow window){
		super();
		this.window = window;
		this.doc    = new DefaultStyledDocument();
		this.setDocument(doc);
		this.setEditable(false);
		
		green = doc.addStyle(null,null);
		StyleConstants.setForeground(green,new Color(0,128,0));
		
		red = doc.addStyle(null,null);
		StyleConstants.setForeground(red,Color.red);
		
		blue = doc.addStyle(null,null);
		StyleConstants.setForeground(blue,Color.blue);
		
		yellow = doc.addStyle(null,null);
		StyleConstants.setForeground(yellow,new Color(128,128,0));
		
		this.popupMenu = new OutputViewPopupMenu(window.getActions());
		this.addMouseListener(new OutputViewMouseListener());
	}
	
	/**
	 * r[ɕǉ܂BPs̕nĂB
	 * CVSR}h̏o͌`ɉĎIɃJ[Oĕ\܂B
	 *
	 * @param text Ps̕
	 */
	public void insertString(String text){
		try {
			AttributeSet style = new SimpleAttributeSet();
			// X^C
			if(text.startsWith("====")){
				style = green;
			} else if(text.startsWith("M ")){
				style = red;
			} else if(text.startsWith("? ")){
				style = yellow;
			} else if(text.startsWith("U ")){
				style = green;
			} else if(text.startsWith("A ")){
				style = red;
			} else if(text.startsWith("R ")){
				style = red;
			} else if(text.startsWith("P ")){
				style = red;
			} else if(text.startsWith("C ")){
				style = red;
			} else if(text.startsWith("T ")){
				style = yellow;
			} else if(text.startsWith("N ")){
				style = yellow;
			} else if(text.startsWith("----")){
				style = blue;
			} else if(text.startsWith("> ")){
				style = blue;
			} else if(text.startsWith("< ")){
				style = red;
			}
			doc.insertString(doc.getLength(),text,style);
			setCaretPosition(doc.getLength());
			
		} catch(Exception ex){
			Util.log(ex);
		}
	}
	
	
	//////////////////////////////////////////////////////////////////
	// |bvAbvj[
	//////////////////////////////////////////////////////////////////
	private class OutputViewPopupMenu extends JPopupMenu {
		public OutputViewPopupMenu(Actions actions){
			super();
			add(actions.getMenuItem("OutputCopy"));
			//add(actions.getMenuItem("OutputRemove"));
			addSeparator();
			add(actions.getMenuItem("OutputSelectAll"));
			add(actions.getMenuItem("OutputClear"));
		}
	}
	
	///////////////////////////////////////////////////////////////////////////
	// }EXXi
	///////////////////////////////////////////////////////////////////////////
	private class OutputViewMouseListener extends MouseAdapter {
		
		public void mouseClicked(MouseEvent evt){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			// |bvAbvj[
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
				return;
			}
		}
		
		public void mouseReleased(MouseEvent evt){
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			// |bvAbvj[\
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
			}
		}
		
		public void mousePressed(MouseEvent evt) {
			// ANV̏ԂXV
			window.setComponentFocus(MainWindow.FOCUS_TREE);
			window.updateActions();
			// |bvAbvj[\
			if(evt.isPopupTrigger()){
				popupMenu.show(evt.getComponent(),evt.getX(),evt.getY());
			}
		}
	}
}
