package tk.javacvs.swing;

import tk.javacvs.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * Swing֌W̃[eBeB\bh񋟂NXłB
 */
public class SwingUtil {
	
	/**
	 * R|[lg̉EɃxzupl쐬܂B
	 *
	 * @param component R|[lg
	 * @param text      eLXg
	 * @return pl
	 */
	public static JPanel createLabelPanel(JComponent component,String text){
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel.add(component);
		panel.add(new JLabel(text));
		return panel;
	}
	
	/**
	 * R|[lg̍Ƀxzupl쐬܂B
	 *
	 * @param text      eLXg
	 * @param component R|[lg
	 * @return pl
	 */
	public static JPanel createLabelPanel(String text,JComponent component){
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel.add(new JLabel(text));
		panel.add(component);
		return panel;
	}
	
	/**
	 * rW͓t͂邽߂̃pl쐬܂B
	 *
	 * @param checkbox utŎwv`FbN{bNX
	 * @param text      rW͓t͂R|[lg
	 * @return pl
	 */
	public static JPanel createInputRevisionPanel(JCheckBox checkbox,JComponent text){
		JPanel panel = new JPanel();
		//panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel.setLayout(new BoxLayout(panel,BoxLayout.X_AXIS));
		panel.add(text);
		panel.add(checkbox);
		//panel.add(new JLabel(Util.getProperty("dialog.label.select_date")));
		panel.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.rev_or_date")));
		return panel;
	}
	
	/**
	 * Rg[cɔzupl쐬܂B
	 *
	 * @param components Rg[̔z
	 * @return pl
	 */
	public static JPanel createVerticalPanel(JComponent[] components){
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		for(int i=0;i<components.length;i++){
			panel.add(components[i]);
		}
		JPanel panelWrap = new JPanel();
		panelWrap.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelWrap.add(panel);
		return panelWrap;
	}
	
	/**
	 * ^Cg̃pl쐬܂B
	 *
	 * @param text      ^Cg
	 * @param component plɕ\R|[lg
	 * @return pl
	 */
	public static JPanel createTitledPanel(String text,JComponent component){
		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(component,BorderLayout.CENTER);
		panel.setBorder(BorderFactory.createTitledBorder(text));
		return panel;
	}
	
	/**
	 * ̓tB[hƎQƃ{^̂pl쐬܂it@CIpjB
	 *
	 * @param text   ̓tB[h
	 * @param button Qƃ{^
	 * @return pl
	 */
	public static JPanel createBrowsePanel(MainWindow parent,JTextField text,JButton button){
		button.addActionListener(new BrowseFileSystemListener(parent,"",text));
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel.add(text);
		panel.add(button);
		return panel;
	}

	/**
	 * ̓tB[hƎQƃ{^̂pl쐬܂it@CIpjB
	 *
	 * @param text   ̓tB[h
	 * @param button Qƃ{^
	 * @param title  {[_̃^Cg
	 */
	public static JPanel createBrowsePanel(MainWindow parent,JTextField text,JButton button,String title){
		JPanel panel = createBrowsePanel(parent,text,button);
		panel.setBorder(BorderFactory.createTitledBorder(title));
		return panel;
	}

	/**
	 * ̓tB[hƎQƃ{^̂pl쐬܂ifBNgIpjB
	 *
	 * @param text   ̓tB[h
	 * @param button Qƃ{^
	 * @param title  {[_̃^Cg
	 * @return pl
	 */
	public static JPanel createBrowseDirPanel(MainWindow parent,JTextField text,JButton button,String title){
		
		button.addActionListener(new BrowseFileSystemListener(parent,title,text,true));
		
		JPanel panel = new JPanel();
		panel.setLayout(new FlowLayout(FlowLayout.LEFT));
		panel.add(text);
		panel.add(button);
		panel.setBorder(BorderFactory.createTitledBorder(title));
		
		return panel;
	}

	
	//////////////////////////////////////////////////////////////////////////////
	// Qƃ{^̃ANVXi
	//////////////////////////////////////////////////////////////////////////////
	private static class BrowseFileSystemListener implements ActionListener {
		
		private String       title;
		private JTextField   text;
		private JFileChooser chooser;
		private MainWindow   parent;
		private boolean      dir;

		public BrowseFileSystemListener(MainWindow parent,String title,JTextField text){
			this(parent,title,text,false);
		}
		
		public BrowseFileSystemListener(MainWindow parent,String title,JTextField text,boolean dir){
			super();
			this.parent  = parent;
			this.title   = title;
			this.text    = text;
			this.dir     = dir;
			this.chooser = new JFileChooser();
			
			if(this.dir){
				this.chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			}
		}
		
		public void actionPerformed(ActionEvent evt){
			int result = this.chooser.showOpenDialog(parent);
			if(result==JFileChooser.APPROVE_OPTION){
				File file = this.chooser.getSelectedFile();
				text.setText(file.getAbsolutePath());
			}
		}
	}
}
