package tk.javacvs.swing;

import java.io.File;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToolBar;

import tk.javacvs.swing.action.CVSAction;

/**
 * JavaCVS̃c[o[łB
 */
public class ToolBar extends JToolBar {
	
	private String lastFilter = "";
	private MainWindow window;
	private HistoryComboBox filter = new HistoryComboBox(new File("filter.history"));;
	
	public ToolBar(MainWindow window,Actions actions){
		
		this.window = window;
		
		addAction(actions.getAction("Update"));
		addAction(actions.getAction("Commit"));
		addSeparator();
		addAction(actions.getAction("Add"));
		addAction(actions.getAction("Add Binary"));
		addAction(actions.getAction("Remove from Repository"));
		addSeparator();
		addAction(actions.getAction("Diff"));
		addAction(actions.getAction("Log"));
		addAction(actions.getAction("Status"));
		addAction(actions.getAction("Graph"));
		addSeparator();
		addAction(actions.getAction("Create Tag"));
		addAction(actions.getAction("Remove Tag"));
		addSeparator();
		
		add(actions.getToggleAction("Recurse").createButton());
		add(filter);
		add(actions.getToggleAction("ModOnly").createButton());
		add(actions.getToggleAction("CVSOnly").createButton());
		add(actions.getToggleAction("NoCVSOnly").createButton());
		addAction(actions.getAction("Reload"));
	}
	
	private void addAction(Action action){
		JButton button = this.add(action);
		button.setToolTipText(((CVSAction)action).getName());
	}
	
	public String getFilter(){
		String filter = this.filter.getText();
		if(filter==null){
			filter = "";
		}
		// ÕtB^ƈꍇ͗ۑ
		if(!lastFilter.equals(filter)){
			if(!filter.equals("")){
				this.filter.saveHistory();
			}
			if(!lastFilter.equals("")){
				// dȂ`FbN
				boolean insertFlag = true;
				for(int i=0;i<this.filter.getItemCount();i++){
					String item = (String)this.filter.getItemAt(i);
					if(item.equals(lastFilter)){
						insertFlag = false;
						break;
					}
				}
				// dȂ痚ɒǉ
				if(insertFlag){
					this.filter.insertItemAt(lastFilter,0);
				}
			}
		}
		lastFilter = filter;
		return filter;
	}
}
