package tk.javacvs.swing.action;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToggleButton;

import tk.javacvs.swing.MainWindow;

/**
 * gOANV̒ۊNXB
 * 
 * @author takezoe
 */
public abstract class AbstractToggleAction implements ActionListener {

	protected MainWindow window;
	protected String text;
	protected Icon   icon;
	protected JToggleButton     button;
	protected JCheckBoxMenuItem menu;
	
	/**
	 * RXgN^B
	 * 
	 * @param text   j[eLXg
	 * @param icon   ACR
	 * @param window MainWindow̃CX^X
	 */
	public AbstractToggleAction(String text,Icon icon,MainWindow window){
		this.window = window;
		this.text   = text;
		this.icon   = icon;
		
		this.button = new JToggleButton(icon);
		this.button.setToolTipText(text);
		this.button.addActionListener(this);
		
		this.menu = new JCheckBoxMenuItem(text,icon);
		this.menu.addActionListener(this);
	}
	
	public void actionPerformed(ActionEvent evt){
		Object source = evt.getSource();
		if(source==this.button){
			this.menu.setSelected(this.button.isSelected());
		} else if(source==this.menu){
			this.button.setSelected(this.menu.isSelected());
		}
		this.doProcess();
	}
	
	/** ɏ܂B */
	protected abstract void doProcess();
	
	/** TuNXp̃\bhBIĂ邩ǂ擾܂B */
	protected boolean isSelected(){
		return this.button.isSelected();
	}
	
	/** JToggleButton擾܂B */
	public JToggleButton createButton(){
		return this.button;
	}
	
	/** JCheckBoxMenuItem擾܂B */
	public JCheckBoxMenuItem createMenuItem(){
		return this.menu;
	}
}
