package tk.javacvs.swing.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;

import javax.swing.Icon;

import tk.javacvs.CVS;
import tk.javacvs.LogInfo;
import tk.javacvs.swing.FileInfo;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.graph.Graph;
import tk.javacvs.swing.graph.GraphWindow;

/**
 * Ot\ANV
 */
public class GraphAction extends CVSThreadAction {
	
	/**
	 * RXgN^
	 */
	public GraphAction(String name,MainWindow window){
		super(name,window);
	}	
	/**
	 * RXgN^
	 */
	public GraphAction(String name,Icon icon,MainWindow window){
		super(name,icon,window);
	}
	
	/**
	 * ̃ANV̏ԂXV܂B
	 */
	public void update(){
		// PCVSt@CIĂꍇ̂ݗL
		FileInfo[] info = window.getSelectedFileInfo();
		if(info==null || info.length!=1 || !info[0].isCVSFile() || !info[0].getFile().isFile()){
			setEnabled(false);
		} else {
			setEnabled(true);
		}
	}
	
	public void doProcess() throws Exception {
		// O擾
		PipedOutputStream out = new PipedOutputStream();
		BufferedReader in = new BufferedReader(new InputStreamReader(new PipedInputStream(out)));
		
		// cvs logR}h̎s
		CVS cvs = new CVS(window.getConfig().getCVSCommand(),out);
		LogInfo logInfo = new LogInfo();
		File[] files = getSelectedFiles();
		logInfo.setFiles(files);
		cvs.log(window.getRoot(),logInfo);
		
		StringBuffer sb = new StringBuffer();
		String line = null;
		try {
			while((line=in.readLine())!=null){
				sb.append(line + "\n");
			}
		} catch(Exception ex){
			//ex.printStackTrace();
		}
		in.close();
		out.close();
		
		Graph graph = new Graph(sb.toString());
		GraphWindow graphWindow = new GraphWindow(window,graph,files[0]);
		graphWindow.show();
	}
}