package tk.javacvs.swing.dialog;

import javax.swing.*;
import javax.swing.border.*;
import java.awt.*;
import java.awt.event.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * CVS̐ݒEs_CAO̒ۊNXB
 */
public abstract class CVSDialog extends JDialog {

	protected MainWindow window;
	private   JButton ok     = new JButton(Util.getProperty("dialog.button.ok"));
	private   JButton cancel = new JButton(Util.getProperty("dialog.button.cancel"));
	
	public CVSDialog(MainWindow window,String title){
		super(window,true);
		this.window = window;
		this.setTitle(title);
		
		// R|[lg̔zu
		Container cp = getContentPane();
		
		JPanel panel = new JPanel();
		panel.add(ok);
		panel.add(cancel);
		ok.addActionListener(new DialogOKListener());
		cancel.addActionListener(new DialogCancelListener());
		
		JPanel subPanel = this.createPanel();
		subPanel.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
		
		cp.add(subPanel,BorderLayout.NORTH);
		cp.add(panel   ,BorderLayout.SOUTH);
		
		this.pack();
		this.setResizable(false);
		
		// _CAOEBhE̒ɕ\
		//int x = (window.getWidth()  - this.getWidth())  / 2 + window.getX();
		//int y = (window.getHeight() - this.getHeight()) / 2 + window.getY();
		int x = window.getX() + 16;
		int y = window.getY() + 16;
		this.setLocation(x,y);
	}
	
	/**
	 * ̃_CAÕpl쐬܂B
	 * TuNXɂĎ܂B
	 */
	protected abstract JPanel createPanel();
	
	/**
	 * ۂ̏Lq܂B
	 */
	protected abstract void doProcess() throws Exception;
	
	//////////////////////////////////////////////////////////////////////////////
	// LZ{^̃Xi
	//////////////////////////////////////////////////////////////////////////////
	private class DialogCancelListener implements ActionListener {
		public void actionPerformed(ActionEvent event){
			dispose();
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	// OK{^̃Xi
	//////////////////////////////////////////////////////////////////////////////
	private class DialogOKListener implements ActionListener {
		public void actionPerformed(ActionEvent event){
			CVSProcessThread thread = new CVSProcessThread();
			SwingUtilities.invokeLater(thread);
			//thread.start();
			dispose();
		}
	}
	
	////////////////////////////////////////////////////////////////////////////
	// XbhŎs
	////////////////////////////////////////////////////////////////////////////
	private class CVSProcessThread extends Thread {
		public void run(){
			try {
				doProcess();
			} catch(Exception ex){
				window.alert(ex.getMessage());
			}
		}
	}
}
