package tk.javacvs.swing.dialog;

import java.io.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * `FbNAEgs_CAOB
 */
public class CheckoutDialog extends CVSDialog {
	
	private HistoryComboBox cvsRoot;
	private HistoryComboBox moduleName;
	private JTextField localDir;
	private JCheckBox  mount;
	private JButton    browse;
	
	public CheckoutDialog(MainWindow window){
		super(window,Util.getProperty("dialog.title.checkout"));
	}
	
	protected JPanel createPanel(){
		// R|[lg̏
		cvsRoot    = new HistoryComboBox(new File("cvsroot.history"));
		moduleName = new HistoryComboBox(new File("module.history"));
		localDir   = new JTextField(20);
		mount      = new JCheckBox(Util.getProperty("dialog.label.checkout_mount"));
		browse     = new JButton(Util.getProperty("dialog.button.browse"));
		// pl̍쐬
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		panel.add(SwingUtil.createTitledPanel(Util.getProperty("dialog.label.cvsroot"),cvsRoot));
		panel.add(SwingUtil.createTitledPanel(Util.getProperty("dialog.label.module"),moduleName));
		panel.add(SwingUtil.createBrowseDirPanel(window,localDir,browse,
												 Util.getProperty("dialog.label.local_dir")));
		panel.add(SwingUtil.createVerticalPanel(new JComponent[]{mount}));
		return panel;
	}
	
	protected void doProcess() throws Exception {
		// p[^擾
		String cvsRoot    = this.cvsRoot.getText();
		String moduleName = this.moduleName.getText();
		String localDir   = this.localDir.getText();
		File   file       = new File(localDir);
		File   mountDir   = new File(file,moduleName);
		
		// }Eg邽߂ɂ炩߃fBNg쐬
		if(this.mount.isSelected()){
			if(!mountDir.exists() || !mountDir.isDirectory()){
				mountDir.mkdir();
			}
		}
		
		// `FbNAEgs
		CVS cvs = window.getCVS();
		cvs.checkout(cvsRoot,moduleName,file);

		// c[r[Ƀ}Eg
		if(this.mount.isSelected()){
			Config config = window.getConfig();
			if(config.addMountDirectory(mountDir)){
				window.mountDirectory(mountDir);
				window.updateActions();
			}
		}
		
		// ۑ
		this.cvsRoot.saveHistory();
		this.moduleName.saveHistory();
	}
}
