package tk.javacvs.swing.dialog;

import java.io.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;
import javax.swing.*;
import java.awt.*;

/**
 * cvs commits_CAOB
 */
public class CommitDialog extends CVSDialog {
	
	private JTextArea message;
	private JCheckBox currentOnly;
	private File[]    files;
	
	/**
	 * RXgN^
	 * 
	 * @param window
	 * @param files
	 */
	public CommitDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.commit"));
		this.files  = files;
	}
	
	/**
	 *
	 */
	protected JPanel createPanel(){
		
		message     = new JTextArea(8,35);
		currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BorderLayout());
		panel1.add(new JLabel(Util.getProperty("dialog.label.message")),BorderLayout.NORTH);
		panel1.add(new JScrollPane(message),BorderLayout.CENTER);
		
		//JPanel panel2 = SwingUtil.createLabelPanel(currentOnly,Util.getProperty("dialog.label.current_only"));
		panel1.add(currentOnly,BorderLayout.SOUTH);
		
		JPanel panel = new JPanel();
		panel.add(panel1);
		
		return panel;
	}
	
	
	protected void doProcess() throws Exception {
		CVS     cvs         = this.window.getCVS();
		String  message     = this.message.getText();
		boolean currentOnly = this.currentOnly.isSelected();
		
		cvs.commit(window.getRoot(),files,message,currentOnly);
	}
}
