package tk.javacvs.swing.dialog;

import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.table.*;
import javax.swing.border.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * JavaCVS SwingtgGh̐ݒsȂ_CAOB
 */
public class ConfigDialog extends JDialog {

	private JTextField        cvs;
	private JTextField        editor;
	private JCheckBox         quietMode;
	private JButton           selectCVS;
	private JButton           selectEditor;
	private JButton           ok;
	private JButton           cancel;
	private DefaultTableModel model;
	private MainWindow        window;
	private ProgramPanel      program;
	private JTextField        charset;
	private JCheckBox         useExtDiff;
	private JTextField        extDiffPrg;
	private JButton           browseDiff;
	
	/**
	 * RXgN^B
	 */
	public ConfigDialog(MainWindow window){
		
		super(window,true);
		this.window = window;
		
		Config config = window.getConfig();
		String[] extentions = config.getExtentions();
		ExtentionData[] extData = new ExtentionData[extentions.length];
		for(int i=0;i<extentions.length;i++){
			extData[i] = new ExtentionData(extentions[i],config.getEditor(extentions[i]));
		}
		
		this.setTitle(Util.getProperty("dialog.title.config"));
		
		JTabbedPane tabPane = new JTabbedPane();

		// R|[lg̔zu
		cvs          = new JTextField(25);
		editor       = new JTextField(25);
		quietMode    = new JCheckBox(Util.getProperty("dialog.label.quietmode"));
		selectCVS    = new JButton(Util.getProperty("dialog.button.browse"));
		selectEditor = new JButton(Util.getProperty("dialog.button.browse"));
		ok           = new JButton(Util.getProperty("dialog.button.ok"));
		cancel       = new JButton(Util.getProperty("dialog.button.cancel"));
		program      = new ProgramPanel(extData);
		charset      = new JTextField(10);
		useExtDiff   = new JCheckBox(Util.getProperty("dialog.label.use_ext_diff"));
		extDiffPrg   = new JTextField(25);
		browseDiff   = new JButton(Util.getProperty("dialog.button.browse"));
		
		ok.addActionListener(new OKListener());
		cancel.addActionListener(new CancelListener());
		
		// CVS֘A̐ݒ荀ڂzupl
		JPanel panelCVS = new JPanel();
		panelCVS.setLayout(new BoxLayout(panelCVS,BoxLayout.Y_AXIS));
		panelCVS.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.setup_cvs"),
		                                        SwingUtil.createBrowsePanel(window,cvs,selectCVS)));
		panelCVS.add(SwingUtil.createVerticalPanel(new JComponent[]{quietMode}));
		panelCVS.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.charset"),charset));
		//panelCVS.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.setup_cvs")));
		
		tabPane.addTab(Util.getProperty("dialog.label.setup_cvs"),createTabPanel(panelCVS));

		// Diff̐ݒ
		JPanel panelDiff = new JPanel();
		panelDiff.setLayout(new BoxLayout(panelDiff,BoxLayout.Y_AXIS));
		panelDiff.add(SwingUtil.createVerticalPanel(new JComponent[]{useExtDiff}));
		panelDiff.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.ext_diff"),
		                                         SwingUtil.createBrowsePanel(window,extDiffPrg,browseDiff)));
		//panelDiff.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.diff")));
		useExtDiff.addActionListener(new ExternalDiffListener());

		tabPane.addTab(Util.getProperty("dialog.label.diff"),createTabPanel(panelDiff));
		
		// GfB^֘A̐ݒ荀ڂzupl
		JPanel panelEditor = new JPanel();
		panelEditor.setLayout(new BoxLayout(panelEditor,BoxLayout.Y_AXIS));
		panelEditor.add(SwingUtil.createLabelPanel(Util.getProperty("dialog.label.defaulteditor"),
		                                           SwingUtil.createBrowsePanel(window,editor,selectEditor)));
		panelEditor.add(program);
		//panelEditor.setBorder(BorderFactory.createTitledBorder(Util.getProperty("dialog.label.setup_editor")));
		
		tabPane.addTab(Util.getProperty("dialog.label.setup_editor"),createTabPanel(panelEditor));

		// CAEg
		JPanel center = new JPanel();
		center.add(tabPane);
		center.setBorder(BorderFactory.createBevelBorder(BevelBorder.RAISED));
		
		// ʉ̃{^CAEg
		JPanel bottom = new JPanel();
		bottom.setLayout(new FlowLayout(FlowLayout.RIGHT));
		bottom.add(ok);
		bottom.add(cancel);
		
		// Ŝzu
		Container cp = this.getContentPane();
		cp.setLayout(new BorderLayout());
		cp.add(center,BorderLayout.CENTER);
		cp.add(bottom,BorderLayout.SOUTH);
		
		cvs.setText(config.getCVSCommand());
		editor.setText(config.getEditor());
		quietMode.setSelected(config.getQuietMode());
		charset.setText(config.getCharset());
		useExtDiff.setSelected(config.getUseExternalDiff());
		extDiffPrg.setText(config.getExternalDiffProgram());
		extDiffPrg.setEnabled(config.getUseExternalDiff());
		
		this.pack();
		this.setResizable(false);
		
		// _CAOEBhE̒ɕ\
		//int x = (window.getWidth()  - this.getWidth())  / 2 + window.getX();
		//int y = (window.getHeight() - this.getHeight()) / 2 + window.getY();
		int x = window.getX() + 16;
		int y = window.getY() + 16;
		this.setLocation(x,y);
	}
	
	private JPanel createTabPanel(JPanel panel){
		JPanel container = new JPanel();
		container.setLayout(new BorderLayout());
		container.add(panel,BorderLayout.NORTH);
		return container;
	}

	//////////////////////////////////////////////////////////////////////////////
	// OK{^̃ANVXi
	//////////////////////////////////////////////////////////////////////////////
	private class OKListener implements ActionListener {
		public void actionPerformed(ActionEvent evt){
			Config config = window.getConfig();
			CVS    cvsObj = window.getCVS();
			// CVSR}hݒ
			config.setCVSCommand(cvs.getText());
			cvsObj.setCVSCommand(cvs.getText());
			// GfB^ݒ
			config.setEditor(editor.getText());
			// ȃbZ[W[hݒ
			config.setQuietMode(quietMode.isSelected());
			cvsObj.setQuietMode(quietMode.isSelected());
			// O̕R[hݒ
			config.setCharset(charset.getText());
			cvsObj.setCharset(charset.getText());
			// ODiffvO̐ݒ
			config.setUseExternalDiff(useExtDiff.isSelected());
			config.setExternalDiffProgram(extDiffPrg.getText());
			// gqƊOvO̊֘At
			ExtentionData[] extData = program.getData();
			String[] extentions = config.getExtentions();
			for(int i=0;i<extentions.length;i++){
				config.removeEditor(extentions[i]);
			}
			for(int i=0;i<extData.length;i++){
				config.setEditor(extData[i].getExtention(),extData[i].getProgram());
			}
			dispose();
		}
	}

	//////////////////////////////////////////////////////////////////////////////
	// LZ{^̃ANVXi
	//////////////////////////////////////////////////////////////////////////////
	private class CancelListener implements ActionListener {
		public void actionPerformed(ActionEvent evt){
			dispose();
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	// ODiffvOg`FbN{bNX̃ANVXi
	//////////////////////////////////////////////////////////////////////////////
	private class ExternalDiffListener implements ActionListener {
		public void actionPerformed(ActionEvent evt){
			extDiffPrg.setEnabled(useExtDiff.isSelected());
		}
	}
	
	//////////////////////////////////////////////////////////////////////////////
	// gqƊOvO̊֘Atspl
	//////////////////////////////////////////////////////////////////////////////
	private class ProgramPanel extends JPanel {
		
		private JButton    btnAdd;
		private JButton    btnRemove;
		private JTextField txtExtention;
		private JTextField txtProgram;
		private JButton    btnBrowse;
		private ListView   table;
		
		public ProgramPanel(ExtentionData[] data){
			btnAdd       = new JButton(Util.getProperty("dialog.button.add"));
			btnRemove    = new JButton(Util.getProperty("dialog.button.remove"));
			txtExtention = new JTextField(3);
			txtProgram   = new JTextField(15);
			btnBrowse    = new JButton(Util.getProperty("dialog.button.browse"));
			table        = new ListView();
			
			// e[uɃJǉ
			table.addColumn(Util.getProperty("table.column.extention"));
			table.addColumn(Util.getProperty("table.column.program"));
			// Jݒ
			TableColumnModel colModel = table.getColumnModel();
			TableColumn col1 = colModel.getColumn(0);
			col1.setPreferredWidth(80);
			col1.setMinWidth(80);
			col1.setMaxWidth(80);

			JPanel panelBrowse = new JPanel();
			panelBrowse.setLayout(new FlowLayout(FlowLayout.CENTER));
			panelBrowse.add(new JLabel(Util.getProperty("dialog.label.extention")));
			panelBrowse.add(txtExtention);
			panelBrowse.add(SwingUtil.createBrowsePanel(window,txtProgram,btnBrowse));
			
			JPanel panelButton = new JPanel();
			panelButton.setLayout(new FlowLayout(FlowLayout.LEFT));
			panelButton.add(btnAdd);
			panelButton.add(btnRemove);
			
			JPanel panelSouth = new JPanel();
			panelSouth.setLayout(new BorderLayout());
			panelSouth.add(panelBrowse,BorderLayout.NORTH);
			panelSouth.add(panelButton,BorderLayout.SOUTH);

			JScrollPane scroll = new JScrollPane(table);
			
			setLayout(new BorderLayout());
			add(scroll,BorderLayout.NORTH);
			add(panelSouth,BorderLayout.SOUTH);
			
			scroll.setPreferredSize(new Dimension(200,100));
			
			btnAdd.addActionListener(new ProgramAddListener());
			btnRemove.addActionListener(new ProgramRemoveListener());
			
			// f[^̏lZbg
			for(int i=0;i<data.length;i++){
				table.addRow(new String[]{data[i].getExtention(),data[i].getProgram()});
			}
		}
		
		public ExtentionData[] getData(){
			ExtentionData[] data = new ExtentionData[table.getRowCount()];
			for(int i=0;i<table.getRowCount();i++){
				data[i] = new ExtentionData((String)table.getValueAt(i,0),
				                            (String)table.getValueAt(i,1));
			}
			return data;
		}
		
		private class ProgramAddListener implements ActionListener {
			public void actionPerformed(ActionEvent evt){
				String extention = txtExtention.getText();
				String program   = txtProgram.getText();
				if(extention.length()!=0 && program.length()!=0){
					table.addRow(new String[]{extention,program});
					txtExtention.setText("");
					txtProgram.setText("");
				} else {
					window.alert(Util.getProperty("message.error_regist_extprg"));
				}
			}
		}
		
		private class ProgramRemoveListener implements ActionListener {
			public void actionPerformed(ActionEvent evt){
				int[] rows = table.getSelectedRows();
				if(rows.length!=0){
					for(int i=0;i<rows.length;i++){
						table.removeRow(rows[i]-i);
					}
				} else {
					window.alert(Util.getProperty("message.error_remove_extprg"));
				}
			}
		}
	}
	
	////////////////////////////////////////////////////////////////////////////
	// gqƃvO̊֘At\NX
	////////////////////////////////////////////////////////////////////////////
	private class ExtentionData {
		
		private String extention;
		private String program;
		
		public ExtentionData(String extention,String program){
			this.extention = extention;
			this.program   = program;
		}
		
		public String getExtention(){
			return this.extention;
		}
		
		public String getProgram(){
			return this.program;
		}
	}
}
