package tk.javacvs.swing.dialog;

import java.awt.*;
import java.io.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * ^O쐬邽߂̃_CAOB
 */
public class CreateTagDialog extends CVSDialog {
	
	private File[] files;
	//private JTextField tagName;
	private HistoryComboBox tagName;
	private JCheckBox currentOnly;
	private JCheckBox override;
	private JCheckBox confirm;
	private JCheckBox branch;
	
	/**
	 * RXgN^
	 *
	 * @param window MainWindow̃CX^X
	 * @param files  Ώۂ̃t@CQ
	 */
	public CreateTagDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.create_tag"));
		this.files = files;
	}
	
	
	/* ( Javadoc)
	 * @see tk.javacvs.swing.dialog.CVSDialog#createPanel()
	 */
	protected JPanel createPanel() {
		// R|[lg̏
		tagName     = new HistoryComboBox(new File("tag.history"));
		currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		override    = new JCheckBox(Util.getProperty("dialog.label.tag_overwrite"));
		confirm     = new JCheckBox(Util.getProperty("dialog.label.tag_confirm"));
		branch      = new JCheckBox(Util.getProperty("dialog.label.tag_branch"));
		
		// R|[lg̔zu
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BoxLayout(panel1,BoxLayout.X_AXIS));
		panel1.add(new JLabel(Util.getProperty("dialog.label.tag_name")));
		panel1.add(tagName);
		
		panel.add(panel1);
		panel.add(SwingUtil.createVerticalPanel(new JComponent[]{currentOnly,confirm,override,branch}));
		return panel;
	}

	/* ( Javadoc)
	 * @see tk.javacvs.swing.dialog.CVSDialog#doProcess()
	 */
	protected void doProcess() throws Exception {
		TagInfo info = new TagInfo();
		info.setFiles(files);
		info.setTagName(tagName.getText());
		info.setCurrentOnly(currentOnly.isSelected());
		info.setOverride(override.isSelected());
		info.setConfirm(confirm.isSelected());
		info.setBranch(branch.isSelected());
		
		CVS cvs = window.getCVS();
		cvs.tag(window.getRoot(),info);
		
		// ^O̗͂ۑ
		tagName.saveHistory();
	}

}
