package tk.javacvs.swing.dialog;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * cvs diff̐ݒs_CAO
 */
public class DiffDialog extends CVSDialog {
	
	private JRadioButton selectLocal;
	private JRadioButton selectLocalRev;
	private JRadioButton selectRevs;
	
	private JCheckBox selectDate1;
	private JCheckBox selectDate2;
	
	private HistoryComboBox rev1;
	private HistoryComboBox rev2;
	
	private JCheckBox currentOnly;
	private JCheckBox skipSpace;
	private JCheckBox skipLetter;
	
	private File[] files;
	
	public DiffDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.diff"));
		this.files  = files;
	}
	
	protected JPanel createPanel(){
		
		selectLocal    = new JRadioButton(Util.getProperty("dialog.label.diff_local"));
		selectLocalRev = new JRadioButton(Util.getProperty("dialog.label.diff_local_rev"));
		selectRevs     = new JRadioButton(Util.getProperty("dialog.label.diff_revs"));
		selectDate1    = new JCheckBox(Util.getProperty("dialog.label.select_date"));
		selectDate2    = new JCheckBox(Util.getProperty("dialog.label.select_date"));
		rev1           = new HistoryComboBox(new File("tag.history"));
		rev2           = new HistoryComboBox(new File("tag.history"));
		currentOnly    = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		skipSpace      = new JCheckBox(Util.getProperty("dialog.label.diff_space"));
		skipLetter     = new JCheckBox(Util.getProperty("dialog.label.diff_letter"));
		
		ButtonGroup group = new ButtonGroup();
		group.add(selectLocal);
		group.add(selectLocalRev);
		group.add(selectRevs);
		selectLocal.setSelected(true);
		
		RadioActionListener radioListener = new RadioActionListener();
		selectLocal.addActionListener(radioListener);
		selectLocalRev.addActionListener(radioListener);
		selectRevs.addActionListener(radioListener);
		
		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		panel.add(SwingUtil.createVerticalPanel(new JComponent[]{selectLocal,selectLocalRev,selectRevs}));
		panel.add(SwingUtil.createInputRevisionPanel(selectDate1,rev1));
		panel.add(SwingUtil.createInputRevisionPanel(selectDate2,rev2));
		panel.add(SwingUtil.createVerticalPanel(new JComponent[]{currentOnly,skipSpace,skipLetter}));
		
		rev1.setEnabled(false);
		rev2.setEnabled(false);
		selectDate1.setEnabled(false);
		selectDate2.setEnabled(false);
		
		if(window.getConfig().getUseExternalDiff()){
			currentOnly.setEnabled(false);
			skipSpace.setEnabled(false);
			skipLetter.setEnabled(false);
		}
		
		return panel;
	}
	/*
	private JPanel createComponentPanel(JComponent component){
		JPanel panel = new JPanel(new FlowLayout(FlowLayout.LEFT));
		panel.add(component);
		return panel;
	}
	*/
	protected void doProcess() throws IOException {
		
		Config config = window.getConfig();
		
		// ODiffvOgp
		if(config.getUseExternalDiff()){
			String program = config.getExternalDiffProgram();
			if(program.equals("")){
				window.alert("ODiffvOw肳Ă܂B");
				return;
			}
			// t@CƂɏ
			for(int i=0;i<files.length;i++){
				externalDiff(files[i]);
			}
		// CVSdiffR}hgp
		} else {
			DiffInfo info = new DiffInfo();
			info.setFiles(files);
			info.setCurrentOnly(currentOnly.isSelected());
			info.setSkipSpace(skipSpace.isSelected());
			info.setSkipLetterCase(skipLetter.isSelected());
			
			if(rev1.isEnabled()){
				info.setRevision1(rev1.getText());
				info.setSelectDate1(selectDate1.isSelected());
			}
			
			if(rev2.isEnabled()){
				info.setRevision2(rev2.getText());
				info.setSelectDate2(selectDate2.isSelected());
			}
			
			CVS cvs = window.getCVS();
			cvs.diff(window.getRoot(),info);
			
			rev1.saveHistory();
			rev2.saveHistory();
		}
	}
	
	
	/**
	 * OR}hgDiffB
	 *
	 * @param file t@C
	 */
	private void externalDiff(File file) throws IOException {
		CVS cvs = window.getCVS();
		
		File tmp1 = null;
		if(rev1.isEnabled()){
			tmp1 = cvs.checkout(file,createTempDirectory(),rev1.getText(),selectDate1.isSelected());
		} else {
			tmp1 = cvs.checkout(file,createTempDirectory(),null,false);
		}
		String path1 = tmp1.getAbsolutePath();
		
		String path2 = file.getAbsolutePath();
		if(rev2.isEnabled()){
			File tmp2 = cvs.checkout(file,createTempDirectory(),rev2.getText(),selectDate2.isSelected());
			path2 = tmp2.getAbsolutePath();
		}
		// OvOs
		String program = window.getConfig().getExternalDiffProgram();
		String command = program + " " + path1 + " " + path2;
		Runtime runtime = Runtime.getRuntime();
		Process process = runtime.exec(command);
	}
	
	/** JE^ */
	private static int count = 0;
	
	/** e|fBNg쐬܂B */
	private File createTempDirectory(){
		File dir = new File("./tmp/difftmp" + count);
		dir.mkdir();
		count++;
		return dir;
	}
	
	/**
	 * e|t@CɃ|Wgupdateeo͂܂B
	 * {CVS.javagďłƂłPhˁcB
	 *
	 * @param file updatet@C
	 * @param tmp  e|t@C
	 */
	/*
	private void cvsUpdate(File file,String revision,boolean date,File tmp) throws IOException,InterruptedException {
		// CVSR}h擾
		Config config = window.getConfig();
		String cvs = config.getCVSCommand();
		// R}h̑gݗ
		StringBuffer sb = new StringBuffer();
		sb.append(cvs);
		sb.append(" -d ");
		sb.append(getCVSRoot(file));
		sb.append(" update -p");
		if(revision!=null && !revision.equals("")){
			if(date){
				sb.append(" -D ");
				sb.append(revision);
			} else {
				sb.append(" -r ");
				sb.append(revision);
			}
		}
		sb.append(" ");
		sb.append(file.getAbsolutePath());
		// R}hsĕWo͂t@CɃ_CNg
		if(!tmp.exists()){
			tmp.createNewFile();
		}
		FileOutputStream out = new FileOutputStream(tmp);
		ByteArrayOutputStream err = new ByteArrayOutputStream();
		CommandExecuter executer = new CommandExecuter();
		executer.setStdOutputStream(out);
		executer.setErrOutputStream(err);
		executer.execute(sb.toString(),true);
		out.close();
		// G[ꍇ
		if(executer.getExitStatus()!=0){
			byte[] errBuf = err.toByteArray();
			err.close();
			if(errBuf.length!=0){
				throw new IOException(new String(errBuf));
			}
		}
	}
	*/
	/**
	 * CVS/RootCVSROOT擾܂BiCVS.javaɓꃁ\bh܂j
	 *
	 * @param file Ώۂ̃t@C
	 * @return CVSROOT
	 */
	/*
	private String getCVSRoot(File file) throws IOException {
		
		// CVS/Roott@CCVSROOT擾
		File cvs  = new File(file,"CVS");
		File root = new File(cvs,"Root");
		
		// ݂ȂefBNggp
		if(!root.exists()){
			file = file.getParentFile();
			cvs  = new File(file,"CVS");
			root = new File(cvs,"Root");
		}
		
		String cvsRoot = Util.loadFile(root);
		
		// sR[h폜
		cvsRoot = Util.replace(cvsRoot,"\r","");
		cvsRoot = Util.replace(cvsRoot,"\n","");
		
		return cvsRoot;
	}
	*/
	////////////////////////////////////////////////////////////////////////////
	// WI{^̃ANVXi
	////////////////////////////////////////////////////////////////////////////
	private class RadioActionListener implements ActionListener {
		public void actionPerformed(ActionEvent evt){
			Object obj = evt.getSource();
			if(obj==selectLocal){
				rev1.setEnabled(false);
				rev2.setEnabled(false);
				selectDate1.setEnabled(false);
				selectDate2.setEnabled(false);
				
			} else if(obj==selectLocalRev){
				rev1.setEnabled(true);
				rev2.setEnabled(false);
				selectDate1.setEnabled(true);
				selectDate2.setEnabled(false);
				
			} else if(obj==selectRevs){
				rev1.setEnabled(true);
				rev2.setEnabled(true);
				selectDate1.setEnabled(true);
				selectDate2.setEnabled(true);
				
			}
		}
	}
	
}
