package tk.javacvs.swing.dialog;

import java.io.*;
import javax.swing.*;
import java.awt.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * C|[gsȂ_CAOB
 */
public class ImportDialog extends CVSDialog {
	
	private JTextField importDir;
	private JButton    browse;
	private JTextField venderTag;
	private JTextField releaseTag;
	private HistoryComboBox cvsRoot;
	private HistoryComboBox moduleName;

	public ImportDialog(MainWindow window){
		super(window,Util.getProperty("dialog.title.import"));
	} 

	public JPanel createPanel(){
		cvsRoot    = new HistoryComboBox(new File("cvsroot.history"));
		moduleName = new HistoryComboBox(new File("module.history"));
		importDir  = new JTextField(20);
		browse     = new JButton(Util.getProperty("dialog.button.browse"));
		venderTag  = new JTextField(8);
		releaseTag = new JTextField(8);

		JPanel panel = new JPanel();
		panel.setLayout(new BoxLayout(panel,BoxLayout.Y_AXIS));
		panel.add(SwingUtil.createTitledPanel(Util.getProperty("dialog.label.cvsroot"),cvsRoot));
		
		JPanel modulePanel = SwingUtil.createTitledPanel(Util.getProperty("dialog.label.module"),moduleName);
		JPanel tagPanel = new JPanel();
		tagPanel.add(new JLabel(Util.getProperty("dialog.label.import_vtag")));
		tagPanel.add(venderTag);
		tagPanel.add(new JLabel(Util.getProperty("dialog.label.import_rtag")));
		tagPanel.add(releaseTag);
		modulePanel.add(tagPanel,BorderLayout.SOUTH);
		
		panel.add(modulePanel);
		panel.add(SwingUtil.createBrowseDirPanel(window,importDir,browse,
												 Util.getProperty("dialog.label.import_dir")));
		
		return panel;
	}

	protected void doProcess() throws Exception {
		// p[^̎擾
		String cvsRoot    = this.cvsRoot.getText();
		String moduleName = this.moduleName.getText();
		String importDir  = this.importDir.getText();
		String venderTag  = this.venderTag.getText();
		String releaseTag = this.releaseTag.getText();
		File   dir        = new File(importDir);
		
		// C|[g̎s
		CVS cvs = window.getCVS();
		cvs.cvsimport(cvsRoot,moduleName,dir,venderTag,releaseTag);
		
		// ۑ
		this.cvsRoot.saveHistory();
		this.moduleName.saveHistory();
	}
}
