package tk.javacvs.swing.dialog;

import java.io.*;
import javax.swing.*;
import java.awt.*;
import tk.javacvs.*;
import tk.javacvs.swing.*;

/**
 * log̐ݒs_CAOB
 */
public class LogDialog extends CVSDialog {
	
	private JCheckBox  onlyBranch;
	private JCheckBox  onlyRCS;
	private JCheckBox  noTag;
	private JCheckBox  noLog;
	private JCheckBox  currentOnly;
	private File[]     files;
	
	public LogDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.log"));
		this.files  = files;
	}
	
	protected JPanel createPanel(){
		
		onlyBranch  = new JCheckBox(Util.getProperty("dialog.label.log_only_trunk"));
		onlyRCS     = new JCheckBox(Util.getProperty("dialog.label.log_only_rcs"));
		noTag       = new JCheckBox(Util.getProperty("dialog.label.log_no_tag"));
		noLog       = new JCheckBox(Util.getProperty("dialog.label.log_no_log"));
		currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		
		JPanel panel1 = new JPanel();
		panel1.setLayout(new GridLayout(5,1));
		panel1.add(onlyBranch);
		panel1.add(onlyRCS);
		panel1.add(noTag);
		panel1.add(noLog);
		panel1.add(currentOnly);
		return panel1;
	}
	
	protected void doProcess() throws Exception {
		
		LogInfo info = new LogInfo();
		info.setFiles(files);
		info.setCurrentOnly(currentOnly.isSelected());
		info.setOnlyRCS(onlyRCS.isSelected());
		info.setOnlyBranch(onlyBranch.isSelected());
		info.setNoTag(noTag.isSelected());
		info.setNoLog(noLog.isSelected());
		
		CVS cvs = window.getCVS();
		cvs.log(window.getRoot(),info);
	}
}
