package tk.javacvs.swing.dialog;

import java.io.File;

import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

import tk.javacvs.CVS;
import tk.javacvs.Util;
import tk.javacvs.swing.MainWindow;
import tk.javacvs.swing.SwingUtil;

/**
 * cvs removes_CAOB
 */
public class RemoveDialog extends CVSDialog {
	
	private JCheckBox currentOnly;
	private JCheckBox removeLocal;
	private File[] files;
	
	public RemoveDialog(MainWindow window,File[] files){
		super(window,Util.getProperty("dialog.title.remove"));
		this.files  = files;
	}
	
	protected JPanel createPanel(){
		
		currentOnly = new JCheckBox(Util.getProperty("dialog.label.current_only"));
		removeLocal = new JCheckBox(Util.getProperty("dialog.label.remove_local"));
		
		JPanel panel1 = new JPanel();
		panel1.setLayout(new BoxLayout(panel1,BoxLayout.Y_AXIS));
		panel1.add(currentOnly);
		panel1.add(removeLocal);
		
		return panel1;
	}
	
	protected void doProcess() throws Exception {
		CVS cvs = window.getCVS();
		cvs.remove(window.getRoot(),this.files,
		           this.currentOnly.isSelected(),this.removeLocal.isSelected());
	}
}
